<?php
// tg_session_simple.php — auto-login SANS token (fait confiance aux données envoyées par le WebApp)
require_once __DIR__ . '/includes/db.php';
if (session_status() === PHP_SESSION_NONE) session_start();
header('Content-Type: application/json; charset=utf-8');

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);

$u = $data['user'] ?? null;
$tid = isset($u['id']) ? (string)$u['id'] : null;
if (!$tid) { echo json_encode(['ok'=>false,'error'=>'no_user']); exit; }

$username   = $u['username']   ?? null;
$first_name = $u['first_name'] ?? null;
$last_name  = $u['last_name']  ?? null;
$photo_url  = $u['photo_url']  ?? null;

// Upsert user
$sql = "INSERT INTO telegram_users (telegram_id, username, first_name, last_name, photo_url, created_at, last_seen, is_banned)
        VALUES (:id,:u,:f,:l,:p,NOW(),NOW(),0)
        ON DUPLICATE KEY UPDATE
          username=VALUES(username),
          first_name=VALUES(first_name),
          last_name=VALUES(last_name),
          photo_url=VALUES(photo_url),
          last_seen=NOW()";
$stmt = $pdo->prepare($sql);
$stmt->execute([
  ':id'=>$tid, ':u'=>$username, ':f'=>$first_name, ':l'=>$last_name, ':p'=>$photo_url
]);

// Session
$_SESSION['telegram_id'] = $tid;
$_SESSION['username']    = $username;
$_SESSION['first_name']  = $first_name;
$_SESSION['last_name']   = $last_name;
$_SESSION['photo_url']   = $photo_url;

echo json_encode(['ok'=>true,'telegram_id'=>$tid]);
