<?php /* modal_verify_result.php — i18n, même structure/classes/IDs */ ?>
<div class="glass-overlay" id="verify-result-modal" role="dialog" aria-modal="true" aria-labelledby="verify-result-title">
  <div class="glass-panel verify-result-panel">
    <div class="panel-head">
      <div class="panel-title" id="verify-result-title"><?= t('verify.result.title','Produit vérifié') ?></div>
      <button class="panel-close" data-close="verify-result-modal" aria-label="<?= t('generic.close') ?>">✕</button>
    </div>

    <div class="panel-body">
      <div class="vr-card">
        <!-- En-tête : vignette + badges + méta -->
        <div class="vr-header">
          <div class="vr-thumb" id="vr-thumb">
            <img id="vr-image" alt="<?= t('verify.result.img_alt','Image produit') ?>">
          </div>

          <div class="vr-top">
            <h3 class="vr-name" id="vr-name">—</h3>

            <div class="vr-badges">
              <span class="vr-badge ok"><?= t('verify.result.badge.ok','✅ Authentique') ?></span>
              <span class="vr-badge cat" id="vr-cat-badge" style="display:none;"></span>
              <span class="vr-badge code"><code id="vr-code">—</code></span>
            </div>

            <dl class="vr-meta">
              <div class="row">
                <dt><?= t('verify.result.meta.date','Date de création') ?></dt>
                <dd id="vr-date">—</dd>
              </div>
              <div class="row">
                <dt><?= t('verify.result.meta.count','Nombre de vérification') ?></dt>
                <dd id="vr-count">0</dd>
              </div>
            </dl>
          </div>
        </div>

        <!-- Description -->
        <div class="vr-descbox">
          <div class="vr-desctitle"><?= t('verify.result.desc.title','Description') ?></div>
          <div class="vr-desc" id="vr-desc">—</div>
        </div>
      </div>
    </div>

    <div class="panel-foot">
      <button class="btn btn-amber btn-xl" data-close="verify-result-modal">✖️ <?= t('generic.close') ?></button>
    </div>
  </div>
</div>
