<?php
if (session_status() === PHP_SESSION_NONE) { @session_start(); }

$tgid = (int)($_SESSION['telegram_id'] ?? 0);

$hasAddress = 0;
try {
  if (!isset($pdo)) { @require_once __DIR__ . '/includes/db.php'; }
  if (isset($pdo) && $tgid > 0) {
    $st = $pdo->prepare("SELECT 1 FROM adresses WHERE telegram_id = ? LIMIT 1");
    $st->execute([$tgid]);
    $hasAddress = $st->fetchColumn() ? 1 : 0;
  }
} catch (Throwable $e) { $hasAddress = 0; }
?>
<div class="glass-overlay" id="cart-modal" data-tgid="<?= $tgid ?>" role="dialog" aria-modal="true" aria-labelledby="cart-title">
  <div class="glass-panel" id="cart-panel">
    <div class="panel-head">
      <div class="panel-title" id="cart-title">🛒 <?= t('cart.title') ?></div>
      <button class="panel-close" data-close="cart-modal" aria-label="<?= t('generic.close') ?>">✕</button>
    </div>

    <div class="panel-body">
      <div class="table-wrap" id="cart-table-wrap">
        <table class="cart-table" id="cart-table" aria-describedby="cart-title">
          <thead>
            <tr>
              <th class="col-prod"><?= t('cart.thead.product') ?></th>
              <th class="col-qty"><?= t('cart.thead.qty') ?></th>
              <th class="col-price"><?= t('cart.thead.price') ?></th>
              <th class="col-del" aria-label="<?= t('cart.thead.delete') ?>"></th>
            </tr>
          </thead>
          <tbody id="cart-tbody"></tbody>
        </table>

        <div class="empty-msg" id="cart-empty" style="display:none;">🧼 <?= t('cart.empty','') ?></div>

        <?php $cart_total_eur = isset($cart_total_eur) ? (float)$cart_total_eur : 0.0; ?>
        <div class="cart-summary" id="cart-summary" style="display:flex;justify-content:space-between;align-items:center;margin-top:10px">
          <span><?= t('cart.total','Total') ?></span>
          <strong
            id="cart-total"
            class="js-price"
            data-price-eur="<?= number_format($cart_total_eur, 2, '.', '') ?>"
            data-total-eur="<?= number_format($cart_total_eur, 2, '.', '') ?>">
            <?= mlz_format_price($cart_total_eur) ?>
          </strong>
        </div>
      </div>
    </div>

    <div class="panel-foot">
      <style>
        /* ⇩⇩⇩ hauteur un peu plus grande pour la cart ⇩⇩⇩ */
        #cart-panel{
          max-height:86vh;
        }

        .wallet-opt{display:flex;align-items:center;gap:8px;margin:8px 0 12px;font-size:12.5px;color:#7c8797}
        .wallet-opt input{width:16px;height:16px}
        .wallet-opt.lock{opacity:.9}
        .wallet-opt.lock input{pointer-events:none}
        .wallet-opt .lock-ico{opacity:.8}
        .wallet-note{display:flex;align-items:center;font-size:12.5px;color:#98a6bb;margin:-6px 0 10px}

        .cart-promo{margin-top:10px;font-size:13px}
        .cart-promo-label{display:block;margin-bottom:4px;color:#9ca3af}
        .cart-promo-row{display:flex;gap:6px}
        .cart-promo-input{
          flex:1;min-width:0;
          border-radius:8px;
          border:1px solid rgba(148,163,184,.5);
          background:#020617;
          color:#e5e7eb;
          padding:6px 10px;
          font-size:13px;
        }
        .cart-promo-feedback{margin-top:4px;font-size:12px}
        .cart-promo-feedback.error{color:#fca5a5}
        .cart-promo-feedback.success{color:#6ee7b7}
        .cart-promo-summary{
          margin-top:6px;
          display:flex;
          align-items:center;
          gap:6px;
          font-size:13px;
          color:#e5e7eb;
        }
        #promo-remove-btn{font-size:11px;padding:0;border:none}

        .cart-addr-alert{background:#fff3cd;border:1px solid #ffe69c;color:#664d03;border-radius:12px;padding:10px 12px;margin:8px 0 12px}
        .cart-addr-alert .msg{font-size:13px;margin-bottom:6px}
        #cart-checkout.is-disabled,
        #cart-checkout[disabled]{
          opacity:.5; filter:grayscale(1);
          pointer-events:none; cursor:not-allowed;
        }
      </style>

<?php if (!$hasAddress): ?>
      <div id="addr-required-box" class="cart-addr-alert" role="alert">
        <div class="msg">⚠️ <?= t('cart.addr_required','Veuillez enregistrer votre adresse avant de pouvoir commander.') ?></div>
      </div>
<?php endif; ?>

      <!-- Code promo : caché tant qu'il n'y a pas d'adresse -->
      <div class="cart-promo" id="cart-promo" style="<?= !$hasAddress ? 'display:none;' : '' ?>">
        <label for="promo-code-input" class="cart-promo-label">
          <?= t('cart.promo_label','Code promo') ?>
        </label>
        <div class="cart-promo-row">
          <input
            type="text"
            id="promo-code-input"
            class="cart-promo-input"
            placeholder="<?= t('cart.promo_placeholder','Entrez votre code') ?>"
            autocomplete="off"
          >
          <button
            type="button"
            id="promo-apply-btn"
            class="btn btn-amber btn-xs"
          ><?= t('cart.promo_apply','Appliquer') ?></button>
        </div>
        <div class="cart-promo-feedback" id="promo-feedback" aria-live="polite"></div>
        <div class="cart-promo-summary" id="promo-summary" style="display:none;">
          <span class="label"><?= t('cart.promo_applied','Réduction') ?> :</span>
          <span class="value" id="promo-discount-amount">-0,00 €</span>
          <button type="button" id="promo-remove-btn" class="btn btn-link btn-xs text-danger">
            <?= t('cart.promo_remove','Retirer') ?>
          </button>
        </div>
      </div>

      <div id="wallet-option" class="wallet-opt lock" aria-disabled="true">
        <input type="checkbox" id="use-wallet" checked disabled />
        <label
          for="use-wallet"
          id="use-wallet-label"
          data-original="<?= htmlspecialchars(t('wallet.label'), ENT_QUOTES, 'UTF-8') ?>"
        >
          <?= t('wallet.label') ?> <span class="lock-ico">🔒</span>
        </label>
      </div>

      <div
        class="wallet-note"
        id="wallet-note"
        aria-hidden="true"
        data-empty="<?= htmlspecialchars(t('wallet.note_empty',''), ENT_QUOTES, 'UTF-8') ?>"
        data-full="<?= htmlspecialchars(t('wallet.note_full',''), ENT_QUOTES, 'UTF-8') ?>"
        data-part="<?= htmlspecialchars(t('wallet.note_part',''), ENT_QUOTES, 'UTF-8') ?>"
      ></div>

      <button
        id="cart-checkout"
        class="btn btn-primary btn-xs<?= !$hasAddress ? ' is-disabled' : '' ?>"
        <?= !$hasAddress ? 'aria-disabled="true" disabled' : 'aria-disabled="false"' ?>
      >📦 <?= t('cart.checkout','') ?></button>
      <button class="btn btn-amber btn-xs" id="cart-edit-address">🚛 <?= t('cart.edit_address','') ?></button>
    </div>
  </div>
</div>

<div class="glass-overlay" id="order-modal" role="dialog" aria-modal="true" aria-labelledby="order-title" style="display:none">
  <div class="glass-panel" id="order-panel">
    <div class="panel-head">
      <div class="panel-title" id="order-title"><?= t('order.title','') ?></div>
      <button class="panel-close" data-close="order-modal" aria-label="<?= t('generic.close') ?>">✕</button>
    </div>
    <div class="panel-body">
      <div class="order-result">
        <div class="status-icon" id="order-status">✓</div>
        <h3 class="order-heading" id="order-heading"><?= t('order.title','') ?></h3>
        <p class="order-msg" id="order-msg"><?= t('order.message','') ?></p>
        <div class="order-meta" id="order-meta" style="display:none;"></div>
      </div>
    </div>
    <div class="panel-foot">
      <button class="btn btn-amber btn-xl" data-close="order-modal"><?= t('generic.ok','OK') ?></button>
    </div>
  </div>
</div>

<script>
(function () {
  const $ = s => document.querySelector(s);

  const optEl   = $('#wallet-option');
  const labelEl = $('#use-wallet-label');
  const noteEl  = $('#wallet-note');
  const cb      = $('#use-wallet');

  function T(key, fallback) {
    try { return (window.I18N && window.I18N[key]) || fallback || key; }
    catch(_) { return fallback || key; }
  }

  function formatByCurrency(eurAmount) {
    const C = window.MLZ_CURRENCY_BOOT || {
      code:'EUR', symbol:'€', rate:1, dec:2, pos:'suffix', decsep:',', thousand:' '
    };
    const amount = Number(eurAmount||0) * Number(C.rate||1);
    const dec    = Math.max(0, (C.dec|0));
    const fixed  = amount.toFixed(dec);
    let [i,d]    = fixed.split('.');
    i = i.replace(/\B(?=(\d{3})+(?!\d))/g, C.thousand);
    const core   = dec ? (i + C.decsep + d) : i;
    return C.pos === 'prefix' ? (C.symbol + core) : (core + ' ' + C.symbol);
  }

  function setPriceSpan(span, eur) {
    if (!span) return;
    span.classList.add('js-price');
    span.setAttribute('data-price-eur', Number(eur||0).toFixed(2));
    span.textContent = formatByCurrency(eur);
  }

  function parseAnyAmount(txt){
    if (!txt) return NaN;
    const s0 = String(txt);
    const s1 = s0.replace(/[^\d,.\s-]/g,'').replace(/\s/g,'');
    if (s1.includes(',') && s1.includes('.')) {
      return parseFloat(s1.replace(/,/g,'').replace('.',',' ).replace(',', '.'));
    }
    return parseFloat(s1.replace(',', '.'));
  }

  function getTotalEUR() {
    const n = document.querySelector('.cart-total-amount, #cart-total');
    if (!n) return 0;
    const attr = n.getAttribute('data-price-eur');
    if (attr != null && attr !== '') return Number(attr) || 0;
    return Number(parseAnyAmount(n.textContent)) || 0;
  }

  function getWalletEUR() {
    if (optEl && optEl.dataset.balance_eur != null) {
      const v = Number(optEl.dataset.balance_eur);
      if (!Number.isNaN(v)) return v;
    }
    if (optEl && optEl.dataset.balance != null) {
      const v = Number(parseAnyAmount(optEl.dataset.balance));
      if (!Number.isNaN(v)) return v;
    }
    if (typeof window.WALLET_EUR === 'number') return window.WALLET_EUR;
    if (labelEl) {
      const m = /([\d\s.,]+)\s*[€$฿]?/.exec(labelEl.textContent || '');
      if (m) {
        const v = Number(parseAnyAmount(m[1]));
        if (!Number.isNaN(v)) return v;
      }
    }
    return 0;
  }

  function renderLabel(balanceEUR){
    if (!labelEl) return;
    labelEl.innerHTML =
      T('wallet.label.prefix', 'Utiliser mon wallet de ')
      + '<span id="wallet-balance-amt"></span>'
      + T('wallet.label.suffix', ' pour finaliser la commande')
      + ' <span class="lock-ico">🔒</span>';
    setPriceSpan(document.getElementById('wallet-balance-amt'), balanceEUR);
  }

  function renderNote(totalEUR, balanceEUR){
    if (!noteEl) return;
    noteEl.innerHTML = '';
    if (balanceEUR <= 0.009) {
      noteEl.textContent = T('wallet.note_empty','Votre wallet est vide. La commande restera possible.');
      return;
    }
    if (balanceEUR >= totalEUR) {
      noteEl.textContent = T('wallet.note_full','Le montant total sera intégralement déduit de votre wallet.');
      return;
    }
    const pay  = Math.min(balanceEUR, totalEUR);
    const rest = Math.max(0, totalEUR - pay);

    const frag = document.createDocumentFragment();
    frag.append(document.createTextNode(T('wallet.note_part.lead','Votre wallet paiera ')));
    const s1 = document.createElement('span'); s1.id='wallet-pay-amt';  frag.appendChild(s1);
    frag.append(document.createTextNode(T('wallet.note_part.mid',' . Reste à payer : ')));
    const s2 = document.createElement('span'); s2.id='wallet-rest-amt'; frag.appendChild(s2);
    frag.append(document.createTextNode('.'));
    noteEl.appendChild(frag);

    setPriceSpan(document.getElementById('wallet-pay-amt'),  pay);
    setPriceSpan(document.getElementById('wallet-rest-amt'), rest);
  }

  function render(){
    const totalEUR   = getTotalEUR();
    const balanceEUR = getWalletEUR();
    const canUse     = balanceEUR > 0.009;

    renderLabel(balanceEUR);
    renderNote(totalEUR, balanceEUR);

    if (optEl) optEl.classList.toggle('lock', !canUse);
    if (cb) { cb.disabled = !canUse; cb.checked = canUse ? cb.checked : false; }

    try { document.dispatchEvent(new CustomEvent('mlz:wallet:render')); } catch(_){}
  }

  ['cart:updated','wallet:updated','mlz:cart-refreshed'].forEach(ev=>{
    document.addEventListener(ev, render);
  });

  const totalNode = document.querySelector('.cart-total-amount') || document.querySelector('#cart-total');
  if (totalNode){
    new MutationObserver(render).observe(totalNode, {
      childList:true, subtree:true, characterData:true,
      attributes:true, attributeFilter:['data-price-eur']
    });
  }

  document.addEventListener('mlz:currency-changed', render);

  if (document.readyState === 'loading') document.addEventListener('DOMContentLoaded', render);
  else render();
})();
</script>

<script>
function fmtEUR(v){ return (Math.round(v*100)/100).toLocaleString('fr-FR',{style:'currency',currency:'EUR'}); }
function parseEUR(text){
  if(!text) return 0;
  let s=String(text).trim().replace(/\u202F|\s/g,'');
  const i=s.lastIndexOf(',');
  if(i>=0){ s=s.slice(0,i).replace(/,/g,'')+'.'+s.slice(i+1); }
  s=s.replace(/[^\d.\-]/g,'');
  return parseFloat(s)||0;
}
function getCartTotalEUR(){
  const el=document.getElementById('cart-total');
  return el?parseEUR(el.textContent):0;
}
function setLabelAmount(labelEl, amountText){
  if(!labelEl) return;
  const original=labelEl.getAttribute('data-original')||labelEl.textContent;
  labelEl.setAttribute('data-original', original);
  const base=original.replace(/[-+]?\d[\d\s\u202F.,]*\s?€/u,'{amount}');
  labelEl.textContent=base.replace('{amount}', amountText)+' ';
  const ico=document.createElement('span'); ico.className='lock-ico'; ico.textContent='🔒'; labelEl.appendChild(ico);
}
function replaceCurrencies(text, values){
  let i=0;
  return String(text||'').replace(/[-+]?\d[\d\s\u202F.,]*\s?€/gu, ()=> (i<values.length?values[i++]:arguments[0]));
}

(function(){
  const modal=document.getElementById('cart-modal');
  const tgid=Number(modal?.dataset?.tgid||0);
  const wrap=document.getElementById('wallet-option');
  const label=document.getElementById('use-wallet-label');
  const note=document.getElementById('wallet-note');
  const chk=document.getElementById('use-wallet');
  const btnCta=document.getElementById('cart-checkout');
  const totalEl=document.getElementById('cart-total');

  function forceUseWalletFlag(){ document.cookie='use_wallet=1; path=/; max-age=300'; }
  forceUseWalletFlag();
  if(btnCta) btnCta.addEventListener('click', forceUseWalletFlag, {capture:true});

  const _fetch=window.fetch;
  window.fetch=function(input,init){
    try{
      let url=(typeof input==='string')?input:(input?.url||'');
      if(url && url.indexOf('checkout.php')!==-1){
        if(!init) init={};
        if(init.body instanceof FormData){ init.body.set('use_wallet','1'); }
        else if(typeof init.body==='string'){ init.body+=(init.body?'&':'')+'use_wallet=1'; }
        else{ const u=new URL(url,location.href); u.searchParams.set('use_wallet','1'); input=u.toString(); }
        document.cookie='use_wallet=1; path=/; max-age=300';
      }
    }catch(e){}
    return _fetch.apply(this, arguments);
  };

  async function fetchBalanceEUR(){
    try{
      const r=await fetch(`/api/get_balance.php?telegram_id=${tgid}`);
      const j=await r.json();
      const rate=Number(j.eur_per_btc||j.rate_eur||0);
      const sats=Number(j.balance_sats||0);
      if(rate) return (sats/1e8)*rate;
      return Number(j.balance_eur||0);
    }catch(e){ return 0; }
  }

  async function refreshWalletUI(){
    const balanceEur=await fetchBalanceEUR();
    setLabelAmount(label, fmtEUR(balanceEur));

    const totalEur=getCartTotalEUR();
    if(note){
      const tEmpty=note.dataset.empty||'';
      const tFull =note.dataset.full ||'';
      const tPart =note.dataset.part ||'';
      if(balanceEur<=0){
        note.textContent=tEmpty;
      }else if(balanceEur>=totalEur){
        note.textContent=tFull;
      }else{
        const walletPay=Math.min(balanceEur,totalEur);
        const rest=Math.max(0, parseFloat((totalEur-walletPay).toFixed(2)));
        note.textContent=replaceCurrencies(tPart, [fmtEUR(walletPay), fmtEUR(rest)]);
      }
    }

    if(wrap){
      wrap.classList.add('lock');
      if(chk){ chk.checked=true; chk.disabled=true; chk.setAttribute('aria-disabled','true'); }
    }
  }
  window.refreshWalletUI=refreshWalletUI;

  function isOpen(){ return modal && modal.offsetParent!==null && getComputedStyle(modal).display!=='none'; }
  function onOpenCheck(){ if(isOpen()) refreshWalletUI(); }

  if('MutationObserver' in window){
    new MutationObserver(onOpenCheck).observe(modal,{attributes:true,attributeFilter:['style','class','aria-hidden']});
  }
  document.addEventListener('click',(e)=>{
    const el=e.target.closest('[data-open="cart-modal"], [href="#cart-modal"], #dock-cart, .open-cart, #header-cart');
    if(el) setTimeout(onOpenCheck,0);
  });
  if(totalEl && 'MutationObserver' in window){
    new MutationObserver(()=>{ refreshWalletUI(); }).observe(totalEl,{childList:true,characterData:true,subtree:true});
  }
  document.addEventListener('visibilitychange',()=>{ if(document.visibilityState==='visible' && isOpen()) refreshWalletUI(); });
  window.addEventListener('focus',()=>{ if(isOpen()) refreshWalletUI(); });
  setInterval(()=>{ if(isOpen()) refreshWalletUI(); },10000);
  document.addEventListener('DOMContentLoaded', onOpenCheck);
})();
</script>

<script>
(function(){
  if (window.__MLZ_CART_FIX) return; window.__MLZ_CART_FIX = 1;
  const modal = document.getElementById('cart-modal');
  if (!modal) return;

  function openLocal(){
    modal.classList.add('open');
    modal.style.display = 'block';
    document.body.classList.add('no-scroll');
  }
  function closeLocal(){
    modal.classList.remove('open');
    modal.style.display = 'none';
    document.body.classList.remove('no-scroll');
  }

  window.MLZ_openCartModal = function(){
    try { if (window.openOverlay) return openOverlay('cart-modal'); } catch(e){}
    openLocal();
  };

  document.addEventListener('click', function(e){
    const t = e.target.closest && e.target.closest('[data-open="cart-modal"], [href="#cart-modal"], #dock-cart, .open-cart, #header-cart');
    if (!t) return;
    e.preventDefault();
    window.MLZ_openCartModal();
  }, {capture:true});

  modal.addEventListener('click', function(e){ if (e.target === modal) closeLocal(); });
  const closeBtn = modal.querySelector('[data-close="cart-modal"]');
  if (closeBtn) closeBtn.addEventListener('click', function(e){ e.preventDefault(); closeLocal(); });
  document.addEventListener('keydown', function(e){ if (e.key === 'Escape' && (modal.classList.contains('open') || getComputedStyle(modal).display !== 'none')) closeLocal(); });
})();
</script>

<script>
(function(){
  if (window.__MLZ_WALLET_FIX) return; window.__MLZ_WALLET_FIX = 1;
  const modal = document.getElementById('cart-modal');
  if (!modal) return;

  const wrap  = document.getElementById('wallet-option');
  const label = document.getElementById('use-wallet-label');
  const note  = document.getElementById('wallet-note');
  const chk   = document.getElementById('use-wallet');

  function fmt(n){ try { return new Intl.NumberFormat(navigator.language||'fr-FR',{style:'currency',currency:'EUR'}).format(+n); } catch(_){ return (+n).toFixed(2)+' €'; } }
  function txt(key, fb){ try { return (window.I18N && window.I18N[key]) || fb || ''; } catch(_){ return fb || ''; } }

  function getTid(){
    let t = Number(modal.dataset.tgid || 0);
    if (!t && typeof window.__MLZ_TID === 'number') t = Number(window.__MLZ_TID);
    if (!t){ try{ const id = window?.Telegram?.WebApp?.initDataUnsafe?.user?.id; if(id) t = Number(id);}catch(_){ } }
    return t;
  }

  async function fetchBalance(){
    try{
      const t = getTid();
      const url = t ? `/api/get_balance.php?telegram_id=${t}` : `/api/get_balance.php`;
      const r = await fetch(url, {credentials:'include'});
      const j = await r.json();
      const direct = (typeof j.balance_eur === 'number' && j.balance_eur)
                  || (typeof j.wallet_eur  === 'number' && j.wallet_eur)
                  || (j.balance && (j.balance.eur || j.balance.EUR));
      if (typeof direct === 'number') return direct;
      const rate = Number(j.eur_per_btc || j.rate_eur || j.btc_eur || 0);
      const sats = Number(j.balance_sats || j.sats || 0);
      if (rate && sats >= 0) return (sats/1e8) * rate;
    }catch(_){}
    if (wrap && wrap.dataset.balance){
      const s = String(wrap.dataset.balance).replace(/[^\d,.\s]/g,'').replace(/\s/g,'').replace(',', '.');
      const n = parseFloat(s); if (Number.isFinite(n)) return n;
    }
    return 0;
  }

  function setLabel(amount){
    if (!label) return;
    const base = label.getAttribute('data-original') || label.textContent;
    label.setAttribute('data-original', base);
    const fmtAmount = fmt(amount);
    const next = base.includes('{balance}')
      ? base.replace('{balance}', fmtAmount)
      : base.replace(/[-+]?\d[\d\s\u202F.,]*\s?€/u, fmtAmount);
    label.innerHTML = next + ' <span class="lock-ico">🔒</span>';
  }

  function setNote(balance, total){
    if (!note) return;
    const empty = note.dataset.empty || txt('wallet.note_empty','');
    const full  = note.dataset.full  || txt('wallet.note_full','');
    const part  = note.dataset.part  || txt('wallet.note_part','');

    let msg='';
    if (balance <= 0.009) msg = empty;
    else if (balance >= total) msg = full;
    else {
      const pay  = Math.min(balance, total);
      const rest = Math.max(0, total - pay);
      msg = (part || '').replace('{pay}', fmt(pay)).replace('{rest}', fmt(rest));
    }
    note.textContent = msg;
    note.setAttribute('aria-hidden','false');
  }

  function getTotal(){
    const n1 = document.querySelector('.cart-total-amount');
    if (n1){ const m=n1.textContent.match(/[-+]?\d[\d\s\u202F.,]*\s?€/u); if(m){ const s=m[0].replace(/\s|\u202F/g,'').replace(',', '.'); const v=parseFloat(s); if(!isNaN(v)) return v; } }
    const n2 = document.getElementById('cart-total');
    if (n2){ const s=(n2.dataset.totalEur || n2.value || n2.textContent || '').replace(/\s|\u202F/g,'').replace(',', '.'); const v=parseFloat(s); if(!isNaN(v)) return v; }
    return 0;
  }

  async function refresh(){
    const bal = await fetchBalance();
    setLabel(bal);
    setNote(bal, getTotal());
    if (wrap){
      wrap.dataset.balance = String(bal);
      wrap.classList.add('lock');
      if (chk){ chk.checked=true; chk.disabled=true; chk.setAttribute('aria-disabled','true'); }
    }
    document.dispatchEvent(new Event('wallet:updated'));
  }
  window.refreshWalletUI = refresh;

  function isOpen(){
    if (!modal) return false;
    const s = getComputedStyle(modal);
    return modal.classList.contains('open') || s.display !== 'none' && s.visibility !== 'hidden';
  }
  function onOpen(){ if (isOpen()) refresh(); }

  if ('MutationObserver' in window){
    new MutationObserver(onOpen).observe(modal, {attributes:true, attributeFilter:['style','class','aria-hidden']});
  }
  document.addEventListener('click', e=>{
    if (e.target.closest('[data-open="cart-modal"], [href="#cart-modal"], #dock-cart, .open-cart, #header-cart')) {
      setTimeout(onOpen, 0);
    }
  });
  document.addEventListener('DOMContentLoaded', onOpen);
  window.addEventListener('focus', ()=>{ if (isOpen()) refresh(); });
  setInterval(()=>{ if (isOpen()) refresh(); }, 10000);
})();
</script>

<script>
(function(){
  const modal = document.getElementById('cart-modal');
  const btn   = document.getElementById('cart-checkout');
  const promoBox = document.getElementById('cart-promo');
  let   box   = document.getElementById('addr-required-box');

  function setState(has){
    if (!btn) return;
    if (has){
      btn.disabled = false;
      btn.classList.remove('is-disabled');
      btn.setAttribute('aria-disabled','false');
      if (!box) box = document.getElementById('addr-required-box');
      if (box){ box.style.display='none'; box.setAttribute('aria-hidden','true'); }
      if (promoBox) promoBox.style.display = '';
    } else {
      btn.disabled = true;
      btn.classList.add('is-disabled');
      btn.setAttribute('aria-disabled','true');
      if (!box) box = document.getElementById('addr-required-box');
      if (box){ box.style.display='block'; box.removeAttribute('aria-hidden'); }
      if (promoBox) promoBox.style.display = 'none';
    }
  }

  async function hasAddress(){
    try{
      const fd = new FormData(); fd.append('action','address.get');
      const r  = await fetch('/api/index.php', { method:'POST', body:fd, credentials:'include' });
      const j  = await r.json();
      const a  = j && j.address;
      return !!(a && (a.adresse || a.ville || a.cp || a.code_postal || a.tel || a.nom || a.prenom));
    }catch(_){
      return !(btn && btn.disabled);
    }
  }

  async function refresh(){ setState(await hasAddress()); }

  if (window.MutationObserver && modal){
    new MutationObserver(()=>{
      const open = modal.classList.contains('open') || (getComputedStyle(modal).display !== 'none');
      if (open) refresh();
    }).observe(modal, {attributes:true, attributeFilter:['class','style','aria-hidden']});
  }

  if (modal && (modal.classList.contains('open') || getComputedStyle(modal).display !== 'none')) refresh();

  document.addEventListener('click', function(e){
    if (!e.target.closest('#address-save')) return;
    let tries = 0;
    const timer = setInterval(async ()=>{
      tries++;
      const ok = await hasAddress();
      if (ok || tries >= 24){ clearInterval(timer); refresh(); }
    }, 250);
  }, {capture:true});

  document.addEventListener('click', function(e){
    const closeAddr = e.target.closest('[data-close="address-modal"]');
    if (closeAddr) setTimeout(refresh, 50);
  }, {capture:true});

  document.addEventListener('mlz:address-saved', refresh);
})();
</script>

<script>
(function(){
  const input      = document.getElementById('promo-code-input');
  const applyBtn   = document.getElementById('promo-apply-btn');
  const removeBtn  = document.getElementById('promo-remove-btn');
  const feedback   = document.getElementById('promo-feedback');
  const summaryBox = document.getElementById('promo-summary');
  const discountEl = document.getElementById('promo-discount-amount');
  const totalEl    = document.getElementById('cart-total');

  if (!input || !applyBtn || !totalEl) return;

  function setFeedback(msg, ok){
    if (!feedback) return;
    feedback.textContent = msg || '';
    feedback.classList.remove('error','success');
    if (!msg) return;
    feedback.classList.add(ok ? 'success' : 'error');
  }

  function setTotal(newTotal){
    const v = Number(newTotal) || 0;
    totalEl.setAttribute('data-price-eur', v.toFixed(2));
    if (typeof fmtEUR === 'function') {
      totalEl.textContent = fmtEUR(v);
    } else {
      totalEl.textContent = v.toFixed(2) + ' €';
    }
    try { document.dispatchEvent(new Event('wallet:updated')); } catch(e){}
    try { document.dispatchEvent(new Event('cart:updated')); } catch(e){}
  }

  function applyPromo(code){
    code = (code || '').trim();
    if (!code){
      setFeedback("<?= t('cart.promo_enter','Veuillez entrer un code promo.') ?>", false);
      return;
    }

    applyBtn.disabled = true;
    const originalText = applyBtn.textContent;
    applyBtn.textContent = "<?= t('cart.promo_loading','...') ?>";
    setFeedback('', false);

    const fd = new FormData();
    fd.append('code', code);

    fetch('/apply_promo.php', {
      method: 'POST',
      body: fd,
      credentials: 'include'
    })
    .then(r => r.json())
    .then(j => {
      if (!j || !j.ok){
        summaryBox.style.display = 'none';
        setFeedback(j && j.message ? j.message : "<?= t('cart.promo_invalid','Code promo invalide.') ?>", false);
        if (j && j.total_before != null){
          setTotal(j.total_before);
        }
        try { document.dispatchEvent(new CustomEvent('cart:promo-updated',{detail:{active:false}})); } catch(e){}
        return;
      }

      const totalAfter = Number(j.total_after || 0);
      const discount   = Number(j.discount_value || 0);

      setTotal(totalAfter);
      if (discountEl) {
        if (j.discount_label) {
          discountEl.textContent = j.discount_label;
        } else if (typeof fmtEUR === 'function') {
          discountEl.textContent = '-' + fmtEUR(discount);
        } else {
          discountEl.textContent = '-' + (discount.toFixed ? discount.toFixed(2) : discount) + ' €';
        }
      }
      summaryBox.style.display = 'flex';
      setFeedback(j.message || "<?= t('cart.promo_ok','Code appliqué.') ?>", true);

      try {
        document.dispatchEvent(new CustomEvent('cart:promo-updated', {
          detail: {
            active: true,
            code: j.code || code,
            discount_value: discount,
            total_after: totalAfter
          }
        }));
      } catch(e){}
    })
    .catch(() => {
      setFeedback("<?= t('cart.promo_error','Erreur lors de la vérification du code.') ?>", false);
    })
    .finally(() => {
      applyBtn.disabled = false;
      applyBtn.textContent = originalText;
    });
  }

  applyBtn.addEventListener('click', function(){
    applyPromo(input.value);
  });
  input.addEventListener('keydown', function(e){
    if (e.key === 'Enter'){
      e.preventDefault();
      applyPromo(input.value);
    }
  });

  if (removeBtn){
    removeBtn.addEventListener('click', function(){
      input.value = '';
      const fd = new FormData();
      fd.append('clear','1');
      fetch('/apply_promo.php', {
        method:'POST',
        body:fd,
        credentials:'include'
      }).catch(()=>{});
      summaryBox.style.display = 'none';
      setFeedback("<?= t('cart.promo_removed','Code promo retiré.') ?>", true);
      try { document.dispatchEvent(new CustomEvent('cart:promo-updated',{detail:{active:false}})); } catch(e){}
    });
  }
})();
</script>