<?php
// modal_btc_deposit.php — overlay dépôt BTC (SPA-soft + devise live)

// Boot
$root = __DIR__;
if (!isset($pdo)) {
  $dbPath = $root . '/includes/db.php';
  if (file_exists($dbPath)) require_once $dbPath;
}
require_once $root . '/includes/currency.php';
if (file_exists($root . '/includes/tg_boot_soft.php')) require_once $root . '/includes/tg_boot_soft.php';

// Telegram ID
$telegramId = 0;
if (isset($TG['id'])) $telegramId = (int)$TG['id'];
elseif (isset($tg_user['telegram_id'])) $telegramId = (int)$tg_user['telegram_id'];
elseif (isset($_SESSION['telegram_id'])) $telegramId = (int)$_SESSION['telegram_id'];

// Balance (sats) + éventuelle adresse
$balance_sats = 0; $btc_address = '';
if ($telegramId > 0 && isset($pdo)) {
  $st = $pdo->prepare('SELECT balance_sats, btc_address FROM telegram_users WHERE telegram_id = ? LIMIT 1');
  $st->execute([$telegramId]);
  $row = $st->fetch(PDO::FETCH_ASSOC);
  if ($row) {
    $balance_sats = (int)($row['balance_sats'] ?? 0);
    $btc_address  = (string)($row['btc_address'] ?? '');
  }
}

// Taux BTC→EUR (fallback si pas de helper global/config)
if (!function_exists('mlz_btc_eur_rate')) {
  function mlz_btc_eur_rate(): float {
    if (isset($GLOBALS['BTC_EUR_RATE'])) return (float)$GLOBALS['BTC_EUR_RATE'];
    if (getenv('BTC_EUR_RATE')) return (float)getenv('BTC_EUR_RATE');
    try {
      global $pdo;
      if ($pdo instanceof PDO) {
        $q = $pdo->query("SELECT value FROM settings WHERE name='BTC_EUR_RATE' LIMIT 1");
        $v = $q ? $q->fetchColumn() : null;
        if ($v !== false && $v !== null) return (float)$v;
      }
    } catch (Throwable $e) {}
    return 60000.0;
  }
}

// Conversions pour 1er rendu
$balance_btc = $balance_sats / 1e8;
$eur_per_btc = mlz_btc_eur_rate();
$balance_eur = $balance_btc * $eur_per_btc;

$fmt_btc = function(float $btc): string {
  $s = number_format($btc, 8, '.', '');
  return rtrim(rtrim($s, '0'), '.') ?: '0';
};

// Expose boot devise pour le JS
?>
<script>window.MLZ_CURRENCY_BOOT = <?= mlz_currency_boot_json() ?>;</script>

<div class="glass-overlay" id="btc-modal" role="dialog" aria-modal="true" aria-labelledby="btc-title" style="display:none;">
  <div class="glass-panel" id="btc-panel">
    <div class="panel-head">
      <div class="panel-title" id="btc-title"><?= t('btc.title','💳 Dépôt BTC') ?></div>
      <button class="panel-close" data-close="btc-modal" aria-label="<?= t('generic.close','Fermer') ?>">✕</button>
    </div>

    <div class="panel-body">

      <!-- ÉTAT : en attente -->
      <div id="btc-wait" style="display:none;">
        <p><?= t('btc.wait_connect','Connexion à Telegram…') ?></p>
      </div>

      <!-- Styles internes (scopés modal) -->
      <style>
        #btc-modal .btc-card{background:rgba(255,255,255,.55);border:1px solid rgba(0,0,0,.08);box-shadow:0 8px 24px rgba(0,0,0,.12),inset 0 1px 0 rgba(255,255,255,.35);border-radius:16px;padding:14px;}
        #btc-modal .btc-row{display:flex;align-items:center;gap:10px;flex-wrap:wrap}
        #btc-modal .btc-kpi{display:flex;align-items:center;gap:8px;padding:8px 12px;border-radius:12px;background:linear-gradient(180deg,rgba(255,255,255,.7),rgba(255,255,255,.35));border:1px solid rgba(0,0,0,.06);box-shadow:inset 0 1px 0 rgba(255,255,255,.4)}
        #btc-modal .btc-caption{opacity:.6;font-size:.92em}
        #btc-modal .btc-note{background:rgba(255,188,3,.12);border:1px dashed rgba(255,188,3,.55);color:#7a5600;padding:10px 12px;border-radius:12px;margin-bottom:12px}
        .mlx-mini-badge{display:inline-flex;align-items:center;gap:6px;padding:6px 10px;margin:6px 8px 0 8px;font-size:12px;font-weight:700;line-height:1.1;white-space:nowrap;color:#0c1b2a;text-decoration:none;background:linear-gradient(180deg,rgba(255,255,255,.9),rgba(255,255,255,.72));border:1px solid rgba(0,0,0,.08);border-radius:999px;box-shadow:inset 0 1px 0 rgba(255,255,255,.45),0 2px 6px rgba(0,0,0,.16)}
        .mlx-howto-row{display:flex;justify-content:center;margin:6px 0 10px}
      </style>

      <!-- ÉTAT : EMPTY -->
      <div id="btc-empty" class="btc-card" style="display:none;">
        <div class="btc-row" style="justify-content:space-between;margin-bottom:8px">
          <div class="btc-row" style="gap:6px">
            <span style="display:inline-flex;width:24px;height:24px;align-items:center;justify-content:center;border-radius:8px;background:#f7931a;color:white;box-shadow:0 2px 8px rgba(247,147,26,.35)">₿</span>
            <strong><?= t('btc.wallet_status','Statut du portefeuille') ?></strong>
          </div>
          <span class="btc-caption"><?= t('btc.pending','En attente d’activation') ?></span>
        </div>

        <div class="mlx-howto-row">
          <!-- pas de data-close ; nav soft gérée en JS -->
          <a href="crypto.php?lang=<?= htmlspecialchars($_GET['lang'] ?? ($_COOKIE['lang'] ?? '')) ?>"
             class="mlx-mini-badge"
             data-spa-crypto
             data-soft-nav>
            <?= t('crypto.cta.howto','❓ Comment acheter des BTC ?') ?>
          </a>
        </div>

        <div class="btc-row" style="margin-bottom:10px">
              <div class="btc-kpi">
      <strong class="btc-balance-btc">0.00000000</strong>
      <span class="unit">BTC</span>
    </div>
          <div class="btc-kpi">
            <strong class="btc-balance-eur js-price"
                    data-price-eur="<?= number_format($balance_eur, 2, '.', '') ?>">
              <?= mlz_format_price($balance_eur) ?>
            </strong>
          </div>
        </div>

        <div class="btc-note"><?= t('btc.empty_html','Aucune adresse n’est encore assignée à ton compte. </br>Génère ton adresse pour effectuer tes dépôts en <strong>Bitcoin</strong>.') ?></div>

        <div class="btc-row" style="justify-content:center;gap:10px">
          <button class="btn btn-primary btn-xs" id="btc-gen">✨ <?= t('btc.generate','Générer mon adresse') ?></button>
          <button class="btn btn-amber btn-xs" id="btc-refresh">↻ <?= t('btc.refresh','Rafraîchir') ?></button>
        </div>

        <div class="btc-caption" style="text-align:center;margin-top:8px">
          <?= t('btc.tip','Astuce : une adresse = un paiement. Un QR apparaîtra après génération.') ?>
        </div>
      </div>

      <!-- ÉTAT : INFO -->
      <div id="btc-info" class="btc-card" style="display:none;">
        <div class="btc-row" style="justify-content:space-between;margin-bottom:8px">
          <div class="btc-row" style="gap:6px">
            <span style="display:inline-flex;width:24px;height:24px;align-items:center;justify-content:center;border-radius:8px;background:#f7931a;color:white;box-shadow:0 2px 8px rgba(247,147,26,.35)">₿</span>
            <strong><?= t('btc.deposit','Dépôt BTC') ?></strong>
          </div>
          <span class="btc-caption"><?= t('btc.active_address','Adresse active') ?></span>
        </div>

        <div class="mlx-howto-row">
          <a href="crypto.php?lang=<?= htmlspecialchars($_GET['lang'] ?? ($_COOKIE['lang'] ?? '')) ?>"
             class="mlx-mini-badge"
             data-spa-crypto
             data-soft-nav>
            <?= t('crypto.cta.howto','❓ Comment acheter des BTC ?') ?>
          </a>
        </div>

        <div style="display:flex;align-items:center;gap:8px;justify-content:center;background:rgba(255,255,255,.35);border:1px solid rgba(0,0,0,.08);padding:10px 12px;border-radius:12px;margin:8px auto;overflow:auto;max-width:100%;">
          <code id="btc-address" style="word-break:break-all"><?= htmlspecialchars($btc_address ?: '—') ?></code>
          <button class="btn btn-ghost btn-xxs" id="btc-copy"><?= t('btc.copy','Copier') ?></button>
        </div>

        <div style="display:flex;justify-content:center;padding:10px 0">
          <canvas id="btc-qr" width="220" height="220" aria-label="<?= t('btc.qr_aria','QR dépôt BTC') ?>"></canvas>
        </div>
<div class="btc-row" style="justify-content:center;">
            <div class="btc-kpi">
      <strong class="btc-balance-btc">0.00000000</strong>
      <span class="unit">BTC</span>
    </div>

        
          <div class="btc-kpi">
            <strong class="btc-balance-eur js-price"
                    data-price-eur="<?= number_format($balance_eur, 2, '.', '') ?>">
              <?= mlz_format_price($balance_eur) ?>
            </strong>
          </div>
        </div>

        <div style="display:flex;gap:8px;justify-content:center;flex-wrap:wrap;margin-top:12px">
          <button class="btn btn-amber btn-xs" id="btc-refresh2">↻ <?= t('btc.refresh','Rafraîchir') ?></button>
        </div>

        <div class="btc-caption" style="text-align:center;margin-top:10px">
          <?= t('btc.credit_after','Crédit après') ?> <strong id="btc-conf">1</strong> <?= t('btc.confirmations','confirmation(s).') ?></br>
        </div>
      </div>

    </div>
  </div>
</div>

<script>
(function(){
  const API_BASE = '/api';
  const CONF_TARGET = 1;

  function getTid(){
    if (window.__MLZ_TID) return Number(window.__MLZ_TID);
    try { const id = window?.Telegram?.WebApp?.initDataUnsafe?.user?.id; if (id) return Number(id); } catch(_){}
    return null;
  }

  async function apiGet(path, params){
    const u = new URL(API_BASE + path, location.origin);
    if (params) Object.entries(params).forEach(([k,v]) => u.searchParams.set(k,v));
    const r = await fetch(u.toString(), { credentials:'include' });
    if (!r.ok) throw new Error('API '+r.status);
    return r.json();
  }
  async function apiPost(path, data){
    const r = await fetch(API_BASE + path, {
      method:'POST',
      headers:{ 'Content-Type':'application/json' },
      body: JSON.stringify(data || {}),
      credentials: 'include'
    });
    if (!r.ok) throw new Error('API '+r.status);
    return r.json();
  }

  // --- UI refs
  let $modal,$wait,$empty,$info,$addr,$qr,$copy,$conf,$gen,$ref1,$ref2;
  let $balBTCs = [], $balEURs = [];
  function grab(){
    $modal = document.getElementById('btc-modal');
    if (!$modal) return false;
    $wait  = document.getElementById('btc-wait');
    $empty = document.getElementById('btc-empty');
    $info  = document.getElementById('btc-info');
    $addr  = document.getElementById('btc-address');
    $qr    = document.getElementById('btc-qr');
    $copy  = document.getElementById('btc-copy');
    $conf  = document.getElementById('btc-conf');
    $gen   = document.getElementById('btc-gen');
    $ref1  = document.getElementById('btc-refresh');
    $ref2  = document.getElementById('btc-refresh2');
    $balBTCs = Array.from($modal.querySelectorAll('.btc-balance-btc'));
    $balEURs = Array.from($modal.querySelectorAll('.btc-balance-eur'));
    return true;
  }
  if (document.readyState === 'loading') document.addEventListener('DOMContentLoaded', grab); else grab();

  function show(which){
    if (!$wait||!$empty||!$info) return;
    $wait.style.display  = (which==='wait') ? 'block':'none';
    $empty.style.display = (which==='empty')? 'block':'none';
    $info.style.display  = (which==='info') ? 'block':'none';
  }

  function drawQR(value){
    if (!window.QRious || !$qr) return;
    new QRious({ element:$qr, value, size:220 });
  }

  // FIAT live : data-price-eur + js-price (+ format immédiat)
  function setBalances(btc, eurInEUR){
    const btcTxt = (Number(btc)||0).toFixed(8);
    $balBTCs.forEach(el => el.textContent = btcTxt);

    const eurBase = Number(eurInEUR || 0);
    $balEURs.forEach(el => {
      el.classList.add('js-price');
      el.setAttribute('data-price-eur', eurBase.toFixed(2));

      const C = window.MLZ_CURRENCY_BOOT;
      if (C) {
        const amount = eurBase * Number(C.rate||1);
        const dec = Math.max(0, C.dec|0);
        const fixed = amount.toFixed(dec);
        let [i,d] = fixed.split('.');
        i = i.replace(/\B(?=(\d{3})+(?!\d))/g, C.thousand);
        const core = dec ? (i + C.decsep + d) : i;
        el.textContent = C.pos==='prefix' ? (C.symbol + core) : (core + ' ' + C.symbol);
      }
    });

    try { document.dispatchEvent(new Event('mlz:prices:set')); } catch(_){}
  }

  async function eurFromRate(btc){
    try { const r = await apiGet('/rates.php'); if (!r.ok) return 0; return (Number(btc)||0) * (r.btc_eur || 0); }
    catch(_) { return 0; }
  }

  function render(address, sats, preset = {}){
    if ($addr) $addr.textContent = address || '—';
    drawQR('bitcoin:' + (address || ''));
    let btc = (preset.btc != null) ? Number(preset.btc) : (Number(sats)||0)/1e8;
    setBalances(btc, null);
    if (preset.eur != null) {
      setBalances(btc, Number(preset.eur));
    } else {
      eurFromRate(btc).then(eur => setBalances(btc, eur));
    }
    if ($conf) $conf.textContent = String(CONF_TARGET);
    show(address ? 'info' : 'empty');
  }

  async function loadState(tid){
    try {
      const res = await apiGet('/get_balance.php', { telegram_id: tid });
      if (!res.ok) { show('empty'); return; }
      const sats = (res.balance_sats != null)
        ? Number(res.balance_sats)
        : Math.round((Number(res.balance_btc)||0)*1e8);
      render(res.btc_address || '', sats, {
        btc: (res.balance_btc != null) ? Number(res.balance_btc) : null,
        eur: (res.balance_eur != null) ? Number(res.balance_eur) : null
      });
    } catch(_) { show('empty'); }
  }

  async function onGenerate(){
    const tid = getTid(); if (!tid) return;
    try{
      const r = await apiPost('/assign_next_address.php', { telegram_id: tid });
      if (!r.ok || !r.address) throw 0;
      render(r.address, 0);
    }catch(_){ alert("Impossible de générer l'adresse pour le moment."); }
  }

  // Open depuis le dock
  document.getElementById('dock-btc')?.addEventListener('click', ()=>{
    setTimeout(()=>{  // laisse l’overlay s’ouvrir
      if (!grab()) return;
      show('wait');
      const tid = getTid();
      if (!tid) {
        const onReady = () => { document.removeEventListener('mlz:telegramReady', onReady); const now=getTid(); if(now) loadState(now); else show('empty'); };
        document.addEventListener('mlz:telegramReady', onReady, { once:true });
        setTimeout(()=>{ const now=getTid(); if(now) loadState(now); else show('empty'); }, 4000);
        return;
      }
      loadState(tid);
    }, 50);
  });
  document.getElementById('btc-gen')?.addEventListener('click', onGenerate);
  document.getElementById('btc-refresh')?.addEventListener('click', ()=>{ const tid=getTid(); if (tid) loadState(tid); });
  document.getElementById('btc-refresh2')?.addEventListener('click', ()=>{ const tid=getTid(); if (tid) loadState(tid); });
  document.getElementById('btc-copy')?.addEventListener('click', async ()=>{
    try { await navigator.clipboard.writeText(($addr?.textContent)||''); const b=document.getElementById('btc-copy'); if(b){ b.textContent='Copié !'; setTimeout(()=> b.textContent='Copier',1200);} } catch(_){}
  });

  // Lien “Comment acheter des BTC ?” → fermeture + PJAX soft
  document.addEventListener('click', function(e){
    const a = e.target.closest('#btc-modal a[data-spa-crypto]');
    if (!a) return;
    e.preventDefault();
    const href = a.getAttribute('href') || a.href;

    try { // ferme la modale tout de suite
      (window.closeOverlay ? closeOverlay('btc-modal') : document.getElementById('btc-modal')?.classList.remove('open'));
    } catch(_){}

    if (window.mlzPjaxGo) {
      window.mlzPjaxGo(href, { soft:true });
    } else {
      // event global si un routeur externe écoute
      const ev = new CustomEvent('mlz:navigate', { detail:{ href }, cancelable:true });
      const canceled = !document.dispatchEvent(ev);
      if (!canceled) window.location.href = href; // fallback
    }
  }, true);

})();
</script>