<?php /* modal_address.php — i18n, même structure/classes */ ?>
<div class="glass-overlay" id="address-modal" role="dialog" aria-modal="true" aria-labelledby="address-title">
  <div class="glass-panel" id="address-panel">
    <div class="panel-head">
      <div class="panel-title" id="address-title">📦 <?= t('address.title') ?></div>
      <button class="panel-close" data-close="address-modal" aria-label="<?= t('generic.close') ?>">✕</button>
    </div>

    <div class="panel-body">
      <div class="field">
        <label class="label" for="a-nom"><?= t('address.label.lastname') ?></label>
        <input id="a-nom" class="input" type="text" placeholder="<?= t('address.placeholder.lastname') ?>" />
      </div>

      <div class="field">
        <label class="label" for="a-prenom"><?= t('address.label.firstname') ?></label>
        <input id="a-prenom" class="input" type="text" placeholder="<?= t('address.placeholder.firstname') ?>" />
      </div>

      <div class="field">
        <label class="label" for="a-tel"><?= t('address.label.phone') ?></label>
        <input id="a-tel" class="input" type="tel" placeholder="<?= t('address.placeholder.phone') ?>" />
      </div>

      <div class="field">
        <label class="label" for="a-adr"><?= t('address.label.address') ?></label>
        <textarea id="a-adr" class="textarea" placeholder="<?= t('address.placeholder.address') ?>"></textarea>
      </div>

      <div class="field">
        <label class="label" for="a-cp"><?= t('address.label.postal') ?></label>
        <input id="a-cp" class="input" type="text" placeholder="<?= t('address.placeholder.postal') ?>" />
      </div>

      <div class="field">
  <label class="label"  for="a-country"><?= t('address.country','Country') ?></label>
  <input id="a-country" class="input" type="text" placeholder="<?= t('address.country_ph','Country') ?>">
</div>

      <div class="field">
        <label class="label" for="a-ville"><?= t('address.label.city') ?></label>
        <input id="a-ville" class="input" type="text" placeholder="<?= t('address.placeholder.city') ?>" />
      </div>
    </div>

    

    <div class="panel-foot">
      <!-- Même style que chez toi -->
      <button class="btn btn-amber btn-xs" data-close="address-modal">✖️ <?= t('generic.close') ?></button>
      <button class="btn btn-primary btn-xs" id="address-save"><?= t('address.save') ?></button>
    </div>
  </div>
</div>

<!-- Confirmation "adresse enregistrée" -->
<div class="glass-overlay" id="address-saved-modal" role="dialog" aria-modal="true" aria-labelledby="addr-saved-title">
  <div class="glass-panel" id="addr-saved-panel">
    <div class="panel-head">
      <div class="panel-title" id="addr-saved-title"><?= t('address.saved.title') ?></div>
      <button class="panel-close" data-close="address-saved-modal" aria-label="<?= t('generic.close') ?>">✕</button>
    </div>
    <div class="panel-body">
      <div class="order-result">
        <p class="order-msg"><?= t('address.saved.message') ?></p>
        <div class="order-meta" id="addr-saved-meta" style="display:none;"></div>
      </div>
    </div>
    <div class="panel-foot">
      <button class="btn btn-amber btn-xs" data-close="address-saved-modal"><?= t('generic.ok') ?></button>
    </div>
  </div>
</div>
