<?php
/**
 * MeltLabz — Loader (sexy compact)
 * - One-time per version with smart re-show (cold cache, TTL, URL override)
 * - No big white card; minimal, centered stack; animated logo & glossy progress pill
 */

if (!function_exists('t')) {
  function t($k, $default = '') { return $default; }
}
if (!defined('MLZ_LOADER_VERSION')) define('MLZ_LOADER_VERSION', '1');
if (!defined('MLZ_LOADER_TTL_HOURS')) define('MLZ_LOADER_TTL_HOURS', 48);

// Host page can set $MLZ_PRELOAD_ASSETS before include
if (!isset($MLZ_PRELOAD_ASSETS) || !is_array($MLZ_PRELOAD_ASSETS)) {
  $MLZ_PRELOAD_ASSETS = [
    'assets/css/main.css',
    'assets/js/script.js',
    'assets/img/honey-bg.webp',
  ];
}

$L = [
  'welcome'  => t('loader.welcome',  'Bienvenue dans l’univers de MeltLabz !'),
  'list'     => t('loader.list',     'Chargement de la liste de nos Hash…'),
  'env'      => t('loader.env',      'Chargement de l’environnement du Laboratoire…'),
  'ready'    => t('loader.ready',    'Le laboratoire est prêt !'),
  'prepping' => t('loader.prepping', 'Préparation du laboratoire…'),
  'aria'     => t('loader.aria',     'Chargement'),
];

$__mlz_loader_key = 'mlz_loader_seen_v' . MLZ_LOADER_VERSION;
$__mlz_i18n_json  = json_encode($L, JSON_UNESCAPED_UNICODE);
$__mlz_assets     = array_values(array_unique($MLZ_PRELOAD_ASSETS));
$__mlz_assets_json= json_encode($__mlz_assets, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
$__mlz_core = array_values(array_filter($__mlz_assets, function($u){
  return preg_match('~\\.(css|js)(\\?|$)~i', $u);
}));
$__mlz_core_json = json_encode($__mlz_core, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
?>

<!-- === MeltLabz Loader — anti-flicker & smart show === -->
<script>
(function(){
  try{
    var key  = <?php echo json_encode($__mlz_loader_key); ?>;
    var now  = Date.now();
    var ttl  = <?php echo (int)MLZ_LOADER_TTL_HOURS; ?> * 3600 * 1000;
    var urlp = new URLSearchParams(location.search);
    var forceFresh = urlp.has('fresh') || urlp.has('boot');

    var raw = localStorage.getItem(key);
    var seen = false;
    if (raw) {
      try {
        var rec = JSON.parse(raw);
        if (rec && typeof rec.ts === 'number') {
          if ((now - rec.ts) < ttl) seen = true;
          else localStorage.removeItem(key);
        } else localStorage.removeItem(key);
      } catch (e) { localStorage.removeItem(key); }
    }
    if (seen && !forceFresh) document.documentElement.classList.add('mlz-loader-skip');
  }catch(e){}
})();
</script>

<style>
  .mlz-loader-skip #mlz-loader{ display:none !important; }

  #mlz-loader{
    position:fixed; inset:0; z-index:99999; display:flex;
    align-items:center; justify-content:center; flex-direction:column;
    overflow:hidden; user-select:none;
    font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;
  }
  /* Honey gradient background */
  #mlz-loader::before{
    content:""; position:absolute; inset:0;
    background:
      radial-gradient(circle at 15% 15%, rgba(255,255,255,.35), rgba(255,255,255,0) 40%),
      radial-gradient(circle at 85% 25%, rgba(255,255,255,.22), rgba(255,255,255,0) 42%),
      linear-gradient(180deg, #ffd86b 0%, #f3a400 55%, #e08a00 100%);
  }
  /* subtle honeycomb overlay */
  #mlz-loader::after{
    content:""; position:absolute; inset:0; opacity:.12; pointer-events:none;
    background:
      linear-gradient(30deg, rgba(0,0,0,.08) 12%, transparent 12.5%, transparent 87%, rgba(0,0,0,.08) 87.5%, rgba(0,0,0,.08)),
      linear-gradient(150deg, rgba(0,0,0,.08) 12%, transparent 12.5%, transparent 87%, rgba(0,0,0,.08) 87.5%, rgba(0,0,0,.08)),
      linear-gradient(90deg, rgba(0,0,0,.08) 12%, transparent 12.5%, transparent 87%, rgba(0,0,0,.08) 87.5%, rgba(0,0,0,.08));
    background-size: 40px 70px;
    background-position: 0 0, 0 0, 20px 35px;
    mix-blend-mode:multiply;
    animation: mlz-sway 7s ease-in-out infinite;
  }
  @keyframes mlz-sway { 0%,100%{ transform:translateY(0) } 50%{ transform:translateY(6px) } }

  /* Stack (no white card) */
  .mlz-stack{ position:relative; z-index:2; display:flex; flex-direction:column; align-items:center; gap:14px; }

  /* Floating logo */
  .mlz-logo{ width:130px; height:auto; filter: drop-shadow(0 8px 20px rgba(0,0,0,.28)); animation:mlz-float 3.2s ease-in-out infinite; }
  @keyframes mlz-float { 0%,100% { transform:translateY(0) } 50% { transform:translateY(-8px) } }

  /* Headline with honey gradient and soft glow */
  .mlz-msg{
    font-size: clamp(18px, 2.4vw, 22px);
    font-weight: 900; letter-spacing:.2px; text-align:center; margin-top:2px;
    background: linear-gradient(90deg,#5a3200,#8a5500,#5a3200);
    -webkit-background-clip: text; background-clip: text; color: transparent;
    text-shadow: 0 0 12px rgba(255, 197, 66, .35);
    animation: mlz-shimmer 3s linear infinite;
    white-space: pre-line;
  }
  @keyframes mlz-shimmer {
    0% { background-position: 0% 50% }
    100% { background-position: 200% 50% }
  }

  .mlz-sub{
    font-size:13px; color:#2f2f2f; opacity:.9; text-align:center;
  }

  /* Compact glossy progress pill */
  .mlz-progress{
    width: clamp(220px, 60vw, 420px);
    height: 14px; border-radius: 999px; position: relative; overflow: hidden;
    background: rgba(255,255,255,.28);
    box-shadow: inset 0 2px 6px rgba(0,0,0,.15), 0 6px 16px rgba(0,0,0,.12);
    backdrop-filter: blur(2px);
  }
  .mlz-progress::before{
    content:""; position:absolute; inset:0;
    background: linear-gradient(180deg, rgba(255,255,255,.6), rgba(255,255,255,0));
    opacity:.45; pointer-events:none;
  }

  .mlz-bar{
    height:100%; width:0%;
    background: linear-gradient(90deg,#ffcc33,#ffb300,#ffa000,#ffcc33);
    background-size: 200% 100%;
    animation: mlz-barflow 2.2s linear infinite;
    box-shadow: 0 0 22px rgba(255,191,0,.6), inset 0 0 8px rgba(255,255,255,.3);
    position:relative;
    transition: width .28s ease;
  }
  @keyframes mlz-barflow { 0%{ background-position:0% 0 } 100%{ background-position:200% 0 } }

  /* Nectar bead traveling at the edge */
  .mlz-bar::after{
    content:""; position:absolute; top:50%; right: -7px; transform: translateY(-50%);
    width: 18px; height: 18px; border-radius: 50%;
    background: radial-gradient(circle at 30% 30%, #fff, #ffd15a 38%, #ffb300 70%, #ff9a00 100%);
    box-shadow: 0 0 18px rgba(255,191,0,.75), 0 0 40px rgba(255,191,0,.45);
  }

  /* Fade-out */
  #mlz-loader.mlz-done{ animation:mlz-fade .38s ease both }
  @keyframes mlz-fade{ to{ opacity:0; visibility:hidden } }

  @media (prefers-reduced-motion: reduce){
    #mlz-loader::after, .mlz-logo, .mlz-msg, .mlz-bar{ animation:none }
  }
</style>

<div id="mlz-loader" role="dialog" aria-live="polite" aria-label="<?php echo htmlspecialchars($L['aria'], ENT_QUOTES, 'UTF-8'); ?>">
  <div class="mlz-stack">
    <img class="mlz-logo" src="assets/img/loader_fresh.webp" alt="MeltLabz">
    <div class="mlz-msg" id="mlz-msg"><?php echo htmlspecialchars($L['welcome'], ENT_QUOTES, 'UTF-8'); ?></div>
    <div class="mlz-progress" aria-hidden="true">
      <div class="mlz-bar" id="mlz-bar"></div>
    </div>
    <div class="mlz-sub" id="mlz-sub"><?php echo htmlspecialchars($L['prepping'], ENT_QUOTES, 'UTF-8'); ?></div>
  </div>
</div>

<script>
(function(){
  const KEY   = <?php echo json_encode($__mlz_loader_key); ?>;
  const L     = <?php echo $__mlz_i18n_json; ?>;
  const ASSETS= <?php echo $__mlz_assets_json; ?>;
  const CORE  = <?php echo $__mlz_core_json; ?>;
  const TTLMS = <?php echo (int)MLZ_LOADER_TTL_HOURS; ?> * 3600 * 1000;

  const $loader = document.getElementById('mlz-loader');
  const $bar = document.getElementById('mlz-bar');
  const $msg = document.getElementById('mlz-msg');
  const $sub = document.getElementById('mlz-sub');

  function sleep(ms){ return new Promise(r=>setTimeout(r, ms)); }
  function updateProgress(pct){
    const p = Math.max(0, Math.min(100, Math.floor(pct)));
    $bar.style.width = p + "%";
    if (p < 25) { $msg.textContent = L.welcome; $sub.textContent = L.prepping; }
    else if (p < 60) { $msg.textContent = L.list; $sub.textContent = ""; }
    else if (p < 95) { $msg.textContent = L.env;  $sub.textContent = ""; }
    else { $msg.textContent = L.ready; $sub.textContent = ""; }
  }
  async function warm(url){
    try{
      const isImg = /\.(png|jpe?g|webp|gif|svg)$/i.test(url);
      if (isImg) {
        await new Promise((res)=>{
          const img = new Image();
          img.onload = ()=>res(); img.onerror = ()=>res();
          img.src = url + (url.includes('?') ? '&' : '?') + 'mlz=' + Date.now();
        });
      } else {
        const res = await fetch(url, { cache: "force-cache", mode: "same-origin" });
        if (!res.ok) throw new Error(res.status);
      }
    }catch(e){}
  }
  async function preloadAll(urls){
    let done = 0;
    const total = urls.length || 1;
    const bumps = urls.map(async (u)=>{
      await warm(u); done++; updateProgress(10 + (done/total)*85);
    });
    await Promise.race([ Promise.allSettled(bumps), sleep(6000) ]);
  }
  function likelyColdStart(coreList){
    if (!performance || !performance.getEntriesByType) return false;
    const ents = performance.getEntriesByType('resource') || [];
    let checked=0, networkHits=0;
    for (const u of coreList) {
      const e = ents.find(x => typeof x.name === 'string' && x.name.indexOf(u) !== -1);
      if (!e) continue;
      checked++;
      if (typeof e.transferSize === 'number' && e.transferSize > 0) networkHits++;
    }
    if (checked === 0) return false;
    return networkHits >= Math.max(1, Math.ceil(checked * 0.5));
  }
  async function run(){
    try{
      updateProgress(8);
      const MIN_SHOW_MS = 1200;
      const t0 = performance.now();
      const extra = Array.from(document.querySelectorAll('[data-preload-src]')).map(el=>el.getAttribute('data-preload-src')).filter(Boolean);
      const all = Array.from(new Set(ASSETS.concat(extra)));
      await preloadAll(all);
      if (document.fonts && document.fonts.ready) { try { await Promise.race([document.fonts.ready, sleep(800)]); } catch(e){} }
      updateProgress(100);
      const elapsed = performance.now() - t0;
      if (elapsed < MIN_SHOW_MS) await sleep(MIN_SHOW_MS - elapsed);
    } finally {
      try { localStorage.setItem(KEY, JSON.stringify({ ts: Date.now() })); } catch(e){}
      $loader.classList.add('mlz-done');
      setTimeout(()=>{ $loader.remove(); }, 400);
    }
  }
  (function decide(){
    const htmlHasSkip = document.documentElement.classList.contains('mlz-loader-skip');
    if (!htmlHasSkip) { run(); return; }
    setTimeout(()=>{
      if (likelyColdStart(CORE)) {
        document.documentElement.classList.remove('mlz-loader-skip'); run();
      } else {
        try {
          const raw = localStorage.getItem(KEY); let rec = null; try { rec = raw ? JSON.parse(raw) : null; } catch(e){}
          if (!rec || typeof rec.ts !== 'number') rec = { ts: Date.now() };
          localStorage.setItem(KEY, JSON.stringify(rec));
        } catch(e){}
      }
    }, 0);
  })();
})();
</script>
