<?php
$isAjax = isset($_GET['ajax']) || (strtolower($_SERVER['HTTP_X_REQUESTED_WITH'] ?? '') === 'xmlhttprequest');

require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/lang.php';
require_once __DIR__.'/includes/currency.php'; // << indispensable pour mlz_format_price()
/** Helper i18n compatible avec plusieurs implémentations possibles (t, __, lang, tableaux globaux) */
if (!function_exists('mlz_t')) {
  function mlz_t($k, $fallback = '') {
    if (function_exists('t'))   { $v = t($k);   if ($v !== null && $v !== $k) return $v; }
    if (function_exists('__'))  { $v = __($k);  if ($v !== null && $v !== $k) return $v; }
    if (function_exists('lang')){ $v = lang($k);if ($v !== null && $v !== $k) return $v; }
    foreach (['LANG','I18N','MLZ_LANG','mlz_lang','TRANSLATIONS'] as $name) {
      if (isset($GLOBALS[$name]) && is_array($GLOBALS[$name]) && isset($GLOBALS[$name][$k])) {
        return $GLOBALS[$name][$k];
      }
    }
    return $fallback !== '' ? $fallback : $k; // en dernier recours on renvoie la clé (ou un fallback fourni)
  }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>MeltLabz — Home</title>

  <link rel="stylesheet" href="assets/css/main.css">
  <?php
  $cat_css_ver = @filemtime(__DIR__.'/assets/css/category.css') ?: time();
  $det_css_ver = @filemtime(__DIR__.'/assets/css/detail.css') ?: time();
  $cat_js_ver  = @filemtime(__DIR__.'/assets/js/category.js') ?: time();
  $det_js_ver  = @filemtime(__DIR__.'/assets/js/detail.js') ?: time();
  ?>
  <link rel="stylesheet" href="assets/css/category.css?v=<?= $cat_css_ver ?>">
  <link rel="stylesheet" href="assets/css/detail.css?v=<?= $det_css_ver ?>">

  <!-- Styles locaux namespacés -->
  <style>
    :root{
      --mlx-bottom-nav-h: 96px;                     /* ajusté dynamiquement en JS */
      --mlx-safe-bottom: env(safe-area-inset-bottom, 0px);
      --mlx-card-gap: 12px;                         /* petit espace au-dessus du bottom menu */
    }

    .mlx-wrap{
      max-width:1200px;
      margin:0 auto;
      padding:clamp(14px,4vw,40px) 12px 12px;
    }
    .mlx-wrap.mlx-wrap-grid{
      display:grid;
      grid-template-rows:auto minmax(0,1fr); /* hero auto + card prend le reste */
      height: calc(var(--vh, 1vh) * 100 - var(--mlx-bottom-nav-h) - var(--mlx-safe-bottom) - var(--mlx-card-gap));
    }

    .mlx-card{
      width:min(980px, calc(100% - 48px));
      margin:6px auto 0;                            /* card légèrement remontée */
      padding: clamp(16px, 2.2vw, 28px);
      background:linear-gradient(180deg, rgba(16,21,27,.62), rgba(16,21,27,.46));
      border:1px solid rgba(255,255,255,.10);
      border-radius:22px;
      box-shadow:0 18px 40px rgba(0,0,0,.35), inset 0 1px 0 rgba(255,255,255,.06);
      backdrop-filter:blur(12px);
      -webkit-backdrop-filter:blur(12px);
      color:#e9f0f6;
      overflow:hidden;                               /* coins arrondis conservés au scroll */
      display:grid; grid-template-rows:auto minmax(0,1fr);
      max-height:100%; position:relative;
    }
    .mlx-card::before,
    .mlx-card::after{
      content:""; position:absolute; left:0; right:0; height:18px; pointer-events:none;
    }
    .mlx-card::before{ top:0;  background:linear-gradient(to bottom, rgba(11,15,20,.55), rgba(11,15,20,0)); border-top-left-radius:22px; border-top-right-radius:22px; }
    .mlx-card::after { bottom:0; background:linear-gradient(to top,    rgba(11,15,20,.55), rgba(11,15,20,0)); border-bottom-left-radius:22px; border-bottom-right-radius:22px; }

    /* Badge compact */
    .mlx-badge{
      display:inline-block;
      margin:0 auto 8px;
      padding:6px 10px;
      font-size:12px; line-height:1.1;
      color:#f4f8fe;
      background:rgba(255,255,255,.08);
      border:1px solid rgba(255,255,255,.14);
      border-radius:9999px;
      box-shadow: inset 0 1px 0 rgba(255,255,255,.06), 0 2px 6px rgba(0,0,0,.16);
      text-align:center;
    }
    .mlx-card .mlx-badge{ margin-left:auto; margin-right:auto; }

    /* Zone scroll interne */
    .mlx-scroll{
      overflow-y:auto;
      overscroll-behavior:contain;
      -webkit-overflow-scrolling:touch;
      padding-right:2px;
      padding-bottom: calc(12px + var(--mlx-safe-bottom));
      scrollbar-width:none; -ms-overflow-style:none; touch-action: pan-y;
    }
    .mlx-scroll::-webkit-scrollbar{ width:0; height:0 }

    /* Accordéons */
    .mlx-card .qa{ margin:10px 0 14px; border:1px solid rgba(255,255,255,.10); border-radius:14px; background:rgba(255,255,255,.03); overflow:hidden; }
    .mlx-card .qa summary{
      list-style:none; cursor:pointer; padding:14px 16px;
      font-weight:700; color:#f4f8fe;
      display:flex; align-items:center; justify-content:space-between; user-select:none;
    }
    .mlx-card .qa summary::-webkit-details-marker{ display:none; }
    .mlx-card .qa .qa-title{ display:flex; gap:10px; align-items:center }
    .mlx-card .qa .chev{ transition:transform .2s ease; display:inline-block; font-size:18px; opacity:.85 }
    .mlx-card .qa[open] .chev{ transform:rotate(180deg) }
    .mlx-card .qa .qa-body{ padding:0 16px 14px 16px; animation:mlx-open .25s ease }
    .mlx-card .qa .qa-body ul{ margin:6px 0 6px 16px }
    .mlx-card .qa .qa-body li{ margin:3px 0 }
    .mlx-card a{ color:#9ddaff; text-decoration:none } .mlx-card a:hover{ text-decoration:underline }

    @keyframes mlx-open{ from{opacity:0; transform:translateY(-3px)} to{opacity:1; transform:none} }

    @media (max-width:480px){
      .mlx-card{ width:calc(100% - 24px); padding:14px; border-radius:16px; }
    }
  </style>
</head>
<body>
<?php
$MLZ_PRELOAD_ASSETS = [
  'assets/css/main.css',
  'assets/js/script.js',
  'assets/img/honey-bg.webp',
];
include __DIR__ . '/mlz_loader_once.php';
?>

  <?php include __DIR__ . '/header.php'; ?>

  <!-- WRAP GRID : hero + card -->
  <div class="mlx-wrap mlx-wrap-grid">
    <div class="tiles">
      <a class="tile hero" href="product.php?categorie=all">
        <span class="pic"><img src="assets/img/loader_fresh.webp" alt="MeltLabz"></span>
      </a>
    </div>

    <section class="mlx-card">
      <!-- Badge i18n -->
      <div class="mlx-badge"><?= mlz_t('info.badge.hint') ?></div>

      <div class="mlx-scroll">
        <!-- 1. Type de livraison -->
        <details class="qa">
          <summary><span class="qa-title"><?= mlz_t('info.section.delivery.title') ?></span><span class="chev">▾</span></summary>
          <div class="qa-body">
            <ul>
              <li><?= mlz_t('info.delivery.li.1') ?></li>
              <li><?= mlz_t('info.delivery.li.2') ?></li>
              <li><?= mlz_t('info.delivery.li.3') ?></li>
            </ul>
          </div>
        </details>

        <!-- 2. Paiements -->
        <details class="qa">
          <summary><span class="qa-title"><?= mlz_t('info.section.payments.title') ?></span><span class="chev">▾</span></summary>
          <div class="qa-body">
            <ul>
              <li><?= mlz_t('info.payments.li.1') ?></li>
              <li><?= mlz_t('info.payments.li.2') ?></li>
              <li><?= mlz_t('info.payments.li.3') ?></li>
            </ul>
          </div>
        </details>

        <!-- 3. Bloc info MeltLabz -->
        <details class="qa">
          <summary><span class="qa-title"><?= mlz_t('info.section.about.title') ?></span><span class="chev">▾</span></summary>
          <div class="qa-body">
            <ul>
              <li><?= mlz_t('info.about.li.1') ?></li>
              <li><?= mlz_t('info.about.li.2') ?></li>
            </ul>
          </div>
        </details>

        <!-- 4. Discrétion & Stealth -->
        <details class="qa">
          <summary><span class="qa-title"><?= mlz_t('info.section.stealth.title') ?></span><span class="chev">▾</span></summary>
          <div class="qa-body">
            <ul>
              <li><?= mlz_t('info.stealth.li.1') ?></li>
              <li><?= mlz_t('info.stealth.li.2') ?></li>
              <li><?= mlz_t('info.stealth.li.3') ?></li>
            </ul>
          </div>
        </details>

        <!-- 5. Responsabilités -->
        <details class="qa">
          <summary><span class="qa-title"><?= mlz_t('info.section.liability.title') ?></span><span class="chev">▾</span></summary>
          <div class="qa-body">
            <ul>
              <li><?= mlz_t('info.liability.li.1') ?></li>
              <li><?= mlz_t('info.liability.li.2') ?></li>
              <li><?= mlz_t('info.liability.li.3') ?></li>
            </ul>
          </div>
        </details>

        <!-- 6. Politique de renvoi -->
        <details class="qa">
          <summary><span class="qa-title"><?= mlz_t('info.section.returns.title') ?></span><span class="chev">▾</span></summary>
          <div class="qa-body">
            <ul>
              <li><?= mlz_t('info.returns.li.1') ?></li>
              <li><?= mlz_t('info.returns.li.2') ?></li>
            </ul>
          </div>
        </details>

        <!-- 7. Détails utiles -->
        <details class="qa">
          <summary><span class="qa-title"><?= mlz_t('info.section.details.title') ?></span><span class="chev">▾</span></summary>
          <div class="qa-body">
            <ul>
              <li><?= mlz_t('info.details.li.1') ?></li>
              <li><?= mlz_t('info.details.li.2') ?></li>
            </ul>
          </div>
        </details>

        <!-- 8. Tutoriel BOT -->
        <details class="qa">
          <summary><span class="qa-title"><?= mlz_t('info.section.bot.title') ?></span><span class="chev">▾</span></summary>
          <div class="qa-body">
            <ul>
              <li><?= mlz_t('info.bot.li.1') ?></li>
              <li><?= mlz_t('info.bot.li.2') ?></li>
              <li><?= mlz_t('info.bot.li.3') ?></li>
            </ul>
          </div>
        </details>
      </div><!-- /.mlx-scroll -->
    </section>
  </div><!-- /.mlx-wrap.mlx-wrap-grid -->

  <?php include __DIR__ . '/bottom_menu.php'; ?>

  <!-- Pop-ups globaux -->
  <?php include __DIR__ . '/modal_cart.php'; ?>
  <?php include __DIR__ . '/modal_verify.php'; ?>
  <?php include __DIR__ . '/modal_address.php'; ?>
  <?php include __DIR__ . '/modal_verify_result.php'; ?>
  <?php include __DIR__ . '/modal_btc_deposit.php'; ?>

  <!-- SDK Telegram puis scripts -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>
  <script src="https://telegram.org/js/telegram-web-app.js"></script>
  <script src="/i18n.js.php"></script>
  <script src="assets/js/script.js?v=3"></script>
  <script src="assets/js/tg_autologin_no_token.js"></script>
  <script src="assets/js/category.js?v=<?= $cat_js_ver ?>"></script>
  <script src="assets/js/detail.js?v=<?= $det_js_ver ?>"></script>

  <!-- Mesure viewport & hauteur réelle du bottom menu -->
  <script>
    (function(){
      function setVh(){ var vh = window.innerHeight * 0.01; document.documentElement.style.setProperty('--vh', vh + 'px'); }
      function setBottomNavHeight(){
        var sel = '.bottom-menu, .bottom_nav, #bottom_menu, #bottomNav, .bottom-nav';
        var el = document.querySelector(sel);
        var h = 96;
        if (el){
          var cs = getComputedStyle(el);
          var mt = parseFloat(cs.marginTop)||0, mb = parseFloat(cs.marginBottom)||0;
          var r = el.getBoundingClientRect(); h = Math.ceil(r.height + mt + mb);
        }
        document.documentElement.style.setProperty('--mlx-bottom-nav-h', h + 'px');
      }
      function tick(){ setVh(); setBottomNavHeight(); }
      window.addEventListener('resize', tick);
      window.addEventListener('orientationchange', tick);
      document.addEventListener('DOMContentLoaded', tick);
      setTimeout(tick, 300); setTimeout(tick, 800); setTimeout(tick, 1400);
    })();
  </script>
</body>
</html>
