<?php
$cat_css_ver = @filemtime(__DIR__.'/assets/css/category.css') ?: time();
$det_css_ver = @filemtime(__DIR__.'/assets/css/detail.css') ?: time();
$cat_js_ver  = @filemtime(__DIR__.'/assets/js/category.js') ?: time();
$det_js_ver  = @filemtime(__DIR__.'/assets/js/detail.js') ?: time();

require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/tg_boot_soft.php';
require_once __DIR__.'/includes/lang.php';
define('MLZ_LOADER_VERSION', '1');
// === Tracker visiteurs (drop-in) ==========================================
// Place ce bloc juste APRES ton require_once '../includes/db.php';

(function ($pdo) {
    // Récup IP fiable (CF, proxies…)
    $getClientIp = function (): string {
        $keys = [
            'HTTP_CF_CONNECTING_IP',   // Cloudflare
            'HTTP_X_FORWARDED_FOR',
            'HTTP_CLIENT_IP',
            'HTTP_X_REAL_IP',
            'REMOTE_ADDR',
        ];
        foreach ($keys as $k) {
            if (!empty($_SERVER[$k])) {
                // X-Forwarded-For peut contenir plusieurs IP
                $ipList = explode(',', $_SERVER[$k]);
                $ip = trim($ipList[0]);
                if (filter_var($ip, FILTER_VALIDATE_IP)) {
                    return $ip;
                }
            }
        }
        return '0.0.0.0';
    };

    // Données à enregistrer
    $ip = $getClientIp();
    $ua = substr((string)($_SERVER['HTTP_USER_AGENT'] ?? 'unknown'), 0, 255);

    // (Option) Ignorer certains bots — laisse commenté si tu veux tout logguer
    /*
    $uaLower = strtolower($ua);
    $bots = ['bot', 'spider', 'crawler', 'headless', 'monitoring', 'uptime'];
    foreach ($bots as $b) {
        if (strpos($uaLower, $b) !== false) return; // n’enregistre pas
    }
    */

    // Anti-doublon: 1 trace par (IP, UA) toutes les 15 minutes
    $sql = "
        INSERT INTO visiteurs (ip, user_agent, visite_date)
        SELECT :ip, :ua, NOW()
        WHERE NOT EXISTS (
            SELECT 1 FROM visiteurs
            WHERE ip = :ip2
              AND user_agent = :ua2
              AND visite_date > (NOW() - INTERVAL 15 MINUTE)
        )
    ";
    $st = $pdo->prepare($sql);
    $st->execute([
        ':ip'  => $ip,
        ':ua'  => $ua,
        ':ip2' => $ip,
        ':ua2' => $ua,
    ]);
})(/* $pdo */ $pdo);
// ==========================================================================

?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>MeltLabz — Home</title>
<?php
$ico_ver = @filemtime(__DIR__.'/assets/favicons/site.webmanifest') ?: time();
?>
<link rel="apple-touch-icon" sizes="180x180" href="/assets/favicons/apple-touch-icon.png?v=<?= $ico_ver ?>">
<link rel="icon" type="image/png" sizes="32x32" href="/assets/favicons/favicon-32x32.png?v=<?= $ico_ver ?>">
<link rel="icon" type="image/png" sizes="16x16" href="/assets/favicons/favicon-16x16.png?v=<?= $ico_ver ?>">
<link rel="manifest" href="/assets/favicons/site.webmanifest?v=<?= $ico_ver ?>">
<link rel="shortcut icon" href="/assets/favicons/favicon-32x32.png?v=<?= $ico_ver ?>"> <!-- fallback -->
<meta name="theme-color" content="#000000">
  <link rel="stylesheet" href="assets/css/main.css">
  <?php
$cat_css_ver = @filemtime(__DIR__.'/assets/css/category.css') ?: time();
$det_css_ver = @filemtime(__DIR__.'/assets/css/detail.css') ?: time();
$cat_js_ver  = @filemtime(__DIR__.'/assets/js/category.js') ?: time();
$det_js_ver  = @filemtime(__DIR__.'/assets/js/detail.js') ?: time();
?>
<link rel="stylesheet" href="assets/css/category.css?v=<?= $cat_css_ver ?>">
<link rel="stylesheet" href="assets/css/detail.css?v=<?= $det_css_ver ?>">
<style>
  /* Desktop only: BG flouté via pseudo-élément */
  @media (pointer:fine) and (min-width:1024px){
    body{
      background: none !important;   /* évite le double fond */
      position: relative;
      isolation: isolate;            /* garantit un empilement propre pour ::before */
    }
    body::before{
      content:"";
      position: fixed;
      inset:-8px;                    /* léger overscan pour masquer les bords du blur */
      background-image: url('/assets/img/Labz.webp');
      background-repeat: no-repeat;
      background-size: cover;
      background-position: 50% 46%;  /* ton cadrage (ajuste 42–50% si besoin) */
      filter: blur(6px);
      -webkit-filter: blur(6px);      /* Safari */
      transform: scale(1.04);         /* évite l’effet “bords flous” */
      z-index: -1;
      pointer-events: none;
      will-change: transform;
    }
  }
</style>
</head>
<body>
<?php
$MLZ_PRELOAD_ASSETS = [
  'assets/css/main.css',
  'assets/js/script.js',
  'assets/img/honey-bg.webp',
  // ajoute d’autres gros fichiers ici si besoin
];
include __DIR__ . '/mlz_loader_once.php';
?>

  <?php include __DIR__ . '/header.php'; ?>
<?php require_once __DIR__.'/includes/currency.php'; ?>
<script>
  window.MLZ_CURRENCY_BOOT = <?= mlz_currency_boot_json(); ?>;
  window.MLZ_SET_CURRENCY_URL = "/api/set_currency.php"; // ou "currency_set.php" si tu l'as mis à la racine
</script>
  <!-- Zone centrale -->
  <main class="stage">
    <div class="tiles">
      <a class="tile hero" href="product.php?categorie=all">
        <span class="pic"><img src="assets/img/loader_fresh.webp" alt="MeltLabz"></span>
      </a>
      <a class="tile" href="product.php?categorie=piatella"><span class="pic"><img src="assets/img/PIATELLA.webp" alt="Piatella"></span></a>
      <a class="tile" href="product.php?categorie=wpff"><span class="pic"><img src="assets/img/WPFF.webp" alt="WPFF"></span></a>
      <a class="tile" href="product.php?categorie=iceolator"><span class="pic"><img src="assets/img/ICEO.webp" alt="Iceolator"></span></a>
      <a class="tile" href="product.php?categorie=lamousse"><span class="pic"><img src="assets/img/LAMOUSSE.webp" alt="La Mousse"></span></a>
    </div>
  </main>

  <?php include __DIR__ . '/bottom_menu.php'; ?>

  <!-- Pop-ups globaux -->
  <?php include __DIR__ . '/modal_cart.php'; ?>
  <?php include __DIR__ . '/modal_verify.php'; ?>
  <?php include __DIR__ . '/modal_address.php'; ?>
  <?php include __DIR__ . '/modal_verify_result.php'; ?>
  <?php include __DIR__ . '/modal_btc_deposit.php'; ?>

<script>
// ---- Auto-open your existing verify modal if ?verify=... ----
(function(){
  // CONFIG: adapte si besoin aux IDs/Selectors de TA modale
  const VERIFY_MODAL_ID       = 'verify-modal';            // l'id de ta modale existante
  const VERIFY_INPUT_SELECTOR = '#verify-code';            // input du code (si tu en as un)
  const VERIFY_SUBMIT_SELECTOR= '#verify-submit,[data-verify-submit]'; // bouton pour lancer la vérif (si nécessaire)

  function getParam(name){ try{ return new URL(location.href).searchParams.get(name); }catch(_){ return null; } }

  function openModal(id){
    const el=document.getElementById(id); if(!el) return;
    try{ if(window.openOverlay) return openOverlay(id); }catch(_){}
    el.style.display='block'; el.classList.add('open'); document.body.classList.add('no-scroll');
  }

  function passCodeToYourModal(code){
    // 1) Si tu exposes une API custom
    if (typeof window.MLZ_openVerifyModal === 'function') { window.MLZ_openVerifyModal(code); return true; }
    if (typeof window.setVerifyCode     === 'function') { window.setVerifyCode(code); return true; }

    // 2) Event que ta modale peut écouter
    document.dispatchEvent(new CustomEvent('mlz:verify-open', {detail:{code}}));

    // 3) Fallback ultra simple: remplir l'input et cliquer sur submit
    const input = document.querySelector(VERIFY_INPUT_SELECTOR);
    if (input){ input.value = code; }
    const submit = document.querySelector(VERIFY_SUBMIT_SELECTOR);
    if (submit){ submit.click(); }
    return true;
  }

  const code = getParam('verify');
  if (!code) return;

  // Ouvre TA modale
  openModal(VERIFY_MODAL_ID);
  // Et lui passe le code
  passCodeToYourModal(code);
})();
</script>

  <!-- SDK Telegram puis script -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>
  <script src="https://telegram.org/js/telegram-web-app.js"></script>
  <script src="/i18n.js.php"></script>
<script src="assets/js/script.js?v=3"></script>
<script src="assets/js/tg_autologin_no_token.js"></script>
<script src="assets/js/category.js?v=<?= $cat_js_ver ?>"></script>
<script src="assets/js/detail.js?v=<?= $det_js_ver ?>"></script>
<!-- MLX CRYPTO SPA v2 (AJAX vers crypto.php?partial=1 avec import CSS/JS du fragment) -->
<!-- MLX CRYPTO SPA v3 — sans reload, sans replace. Drop-in pour index.php -->
<script>
(function(){
  if (window.__MLX_CRYPTO_SPA_V3) return; window.__MLX_CRYPTO_SPA_V3 = true;

  const STYLE_ID_MAIN   = 'crypto-inline-style';
  const STYLE_ID_FALLBK = 'crypto-spa-fallback';

  // Conteneur à remplacer (ne touche pas header / bottom)
  function pickContainer(root){
    return root.querySelector('.mlx-wrap')
        || root.querySelector('main')
        || root.querySelector('.wrap')
        || document.getElementById('mlx-home-root')
        || root.body || root;
  }

  // Injecte le style provenant du fragment, sinon un petit fallback
  function ensureCryptoStylesFrom(fragment){
    document.querySelectorAll(
      'style#'+STYLE_ID_MAIN+', style#'+STYLE_ID_FALLBK+', link[data-crypto-style]'
    ).forEach(n=>n.remove());

    const fromFrag = fragment.querySelector('style#'+STYLE_ID_MAIN+', style[data-crypto-style]');
    if (fromFrag){
      const s = document.createElement('style');
      s.id = STYLE_ID_MAIN;
      s.textContent = fromFrag.textContent;
      document.head.appendChild(s);
      return true;
    }

    const css = `
    :root{ --mlx-bottom-nav-h:96px; --mlx-safe-bottom:env(safe-area-inset-bottom,0px); --mlx-card-gap:12px; }
    .mlx-wrap{ max-width:1200px; margin:0 auto; padding:clamp(14px,4vw,40px) 12px 12px; }
    .mlx-wrap.mlx-wrap-grid{ display:grid; grid-template-rows:auto minmax(0,1fr);
      height: calc(var(--vh,1vh) * 100 - var(--mlx-bottom-nav-h) - var(--mlx-safe-bottom) - var(--mlx-card-gap)); }
    .mlx-card{
      width:min(980px, calc(100% - 48px)); margin:6px auto 0;
      padding:clamp(18px,2.2vw,28px);
      background:linear-gradient(180deg, rgba(16,21,27,.62), rgba(16,21,27,.46));
      border:1px solid rgba(255,255,255,.10); border-radius:22px;
      box-shadow:0 18px 40px rgba(0,0,0,.35), inset 0 1px 0 rgba(255,255,255,.06);
      backdrop-filter:blur(12px); -webkit-backdrop-filter:blur(12px); color:#e9f0f6;
      overflow:hidden; display:grid; grid-template-rows:auto minmax(0,1fr); max-height:100%; position:relative;
    }
    .mlx-card::before,.mlx-card::after{ content:""; position:absolute; left:0; right:0; height:18px; pointer-events:none; }
    .mlx-card::before{ top:0; background:linear-gradient(to bottom, rgba(11,15,20,.55), rgba(11,15,20,0)); border-top-left-radius:22px; border-top-right-radius:22px; }
    .mlx-card::after { bottom:0; background:linear-gradient(to top, rgba(11,15,20,.55), rgba(11,15,20,0)); border-bottom-left-radius:22px; border-bottom-right-radius:22px; }
    .mlx-badge{ display:inline-block; margin:0 auto 8px; padding:6px 10px; font-size:12px; line-height:1.1;
      color:#f4f8fe; background:rgba(255,255,255,.08); border:1px solid rgba(255,255,255,.14);
      border-radius:9999px; box-shadow:inset 0 1px 0 rgba(255,255,255,.06), 0 2px 6px rgba(0,0,0,.16); text-align:center; }
    .mlx-scroll{ overflow-y:auto; overscroll-behavior:contain; -webkit-overflow-scrolling:touch; padding-right:2px;
      padding-bottom:calc(12px + var(--mlx-safe-bottom)); scrollbar-width:none; -ms-overflow-style:none; touch-action:pan-y; }
    .mlx-scroll::-webkit-scrollbar{ width:0; height:0 }
    .mlx-card .qa{ margin:10px 0 14px; border:1px solid rgba(255,255,255,.10); border-radius:14px; background:rgba(255,255,255,.03); overflow:hidden; }
    .mlx-card .qa summary{ list-style:none; cursor:pointer; padding:14px 16px; font-weight:700; color:#f4f8fe;
      display:flex; align-items:center; justify-content:space-between; user-select:none; }
    .mlx-card .qa summary::-webkit-details-marker{ display:none; }
    .mlx-card .qa .qa-title{ display:flex; gap:10px; align-items:center }
    .mlx-card .qa .chev{ transition:transform .2s ease; display:inline-block; font-size:18px; opacity:.85 }
    .mlx-card .qa[open] .chev{ transform:rotate(180deg) }
    .mlx-card .qa .qa-body{ padding:0 16px 14px 16px; animation:mlx-open .25s ease }
    .mlx-card .qa .qa-body ul{ margin:6px 0 6px 16px }
    .mlx-card .qa .qa-body li{ margin:4px 0 }
    @keyframes mlx-open{ from{opacity:0; transform:translateY(-3px)} to{opacity:1; transform:none} }
    .mlx-card a{ color:#9ddaff; text-decoration:none } .mlx-card a:hover{ text-decoration:underline }
    @media (max-width:480px){ .mlx-card{ width:calc(100% - 24px); padding:14px; border-radius:16px; } }
    `;
    const s = document.createElement('style');
    s.id = STYLE_ID_FALLBK; s.textContent = css;
    document.head.appendChild(s);
    return false;
  }

  function runCryptoInits(fragment){
    fragment.querySelectorAll('script[data-mlx-init="crypto"]').forEach(scr=>{
      const s = document.createElement('script');
      if (scr.src) { s.src = scr.src; s.defer = true; }
      else { s.textContent = scr.textContent; }
      document.body.appendChild(s);
    });
  }

  async function loadCryptoPartial(url){
    var target = url || 'crypto.php';
    var hasQ   = target.indexOf('?') > -1;
    var res    = await fetch(target + (hasQ ? '&' : '?') + 'partial=1', {
      headers:{ 'X-Requested-With':'XMLHttpRequest' }
    });
    if (!res.ok) throw new Error('HTTP '+res.status);
    var html   = await res.text();

    var tmp = document.createElement('div'); tmp.innerHTML = html;

    // 1) Styles du fragment (ou fallback)
    ensureCryptoStylesFrom(tmp);

    // 2) Remplacement du conteneur (garde header / bottom)
    var src = tmp.querySelector('.mlx-wrap') || tmp.firstElementChild || tmp;
    var dst = pickContainer(document);
    if (!src || !dst) throw new Error('container-missing');
    dst.replaceWith(src);

    // 3) Scripts éventuels du fragment
    runCryptoInits(tmp);

    // 4) Titre + historique + recalculs layout
    document.title = (typeof t==='function')
      ? t('crypto.page.title','MeltLabz — Tutoriel BTC (Débutant)')
      : 'MeltLabz — Tutoriel BTC (Débutant)';
    history.pushState({mlxCrypto:1}, '', 'crypto.php');
    try{ window.dispatchEvent(new Event('resize')); }catch(_){}
    try{ window.dispatchEvent(new Event('mlz:pagechange')); }catch(_){}
  }

  // Expose pour pouvoir relancer au popstate sans reload
  window.MLX_loadCryptoPartial = loadCryptoPartial;

  // Interception SAFE des liens taggés data-spa-crypto (pas le reste du site)
  document.addEventListener('click', function(ev){
    var a = ev.target.closest('a[data-spa-crypto]');
    if (!a) return;
    if (ev.metaKey || ev.ctrlKey || ev.shiftKey || ev.altKey) return;
    if (a.target && a.target !== '') return;
    ev.preventDefault();
    loadCryptoPartial(a.getAttribute('href')||'crypto.php').catch(()=>{ location.href = 'crypto.php'; });
  }, true);

  // Popstate SANS reload : si l’URL est /crypto.php, on recharge juste le fragment
  window.addEventListener('popstate', function(){
    if (/\/crypto\.php\b/i.test(location.pathname)) {
      loadCryptoPartial('crypto.php').catch(()=>{ /* on laisse au navigateur si erreur */ });
    }
    // sinon: on ne fait rien. Pas de reload sauvage.
  });
})();
</script>
<!-- MLX INFO SPA — mini loader (même principe que crypto) -->
<script>
(function(){
  if (window.__MLX_INFO_SPA) return; window.__MLX_INFO_SPA = true;

  function swapInfo(html, href){
    var host = document.getElementById('mlx-home-root') || document.querySelector('#app') || document.body;
    if (!host){ window.location.href = href; return; }
    host.innerHTML = html;
    try{ history.pushState({view:'info', href:href}, '', href); }catch(_){}
    try{ document.dispatchEvent(new Event('mlz:tiles-ready')); }catch(_){}
  }

  function openInfo(){
    var href = 'info.php';
    var url  = href + (href.indexOf('?')>-1 ? '&' : '?') + 'partial=1';
    fetch(url, { headers:{'X-Requested-With':'XMLHttpRequest'}, credentials:'include' })
      .then(r => r.text())
      .then(html => swapInfo(html, href))
      .catch(() => { window.location.href = href; });
  }

  // Bouton dédié (si présent)
  document.getElementById('open-info')?.addEventListener('click', function(e){
    e.preventDefault(); e.stopPropagation(); openInfo();
  }, { capture:true });

  // Tous les liens <a class="js-route" href="info.php">
  document.addEventListener('click', function(e){
    var a = e.target.closest('a.js-route[href$="info.php"]');
    if (!a) return;
    e.preventDefault(); e.stopPropagation(); openInfo();
  }, true);
})();
</script>

</body>
</html>
