<?php
// includes/lang.php — FR/EN/ES via session + cookie + OPcache-safe + JS exposure
if (session_status() === PHP_SESSION_NONE) { session_start(); }

// Langues autorisées
$ALLOWED_LANGS = ['fr','en','es'];

// 1) Force via ?lang=fr|en|es → session + cookie (pour les requêtes AJAX)
if (isset($_GET['lang'])) {
  $req = strtolower($_GET['lang']);
  if (in_array($req, $ALLOWED_LANGS, true)) {
    $_SESSION['lang'] = $req;
    setcookie('lang', $req, time()+31536000, '/', '', false, true);
  }
}

// 2) Sinon cookie, sinon auto (fr → es → en), avec fallback si valeur non autorisée
$lang = $_SESSION['lang'] ?? ($_COOKIE['lang'] ?? null);
if (!$lang || !in_array($lang, $ALLOWED_LANGS, true)) {
  $accept = strtolower($_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? '');
  if (strpos($accept, 'fr') === 0)      { $lang = 'fr'; }
  elseif (strpos($accept, 'es') === 0)  { $lang = 'es'; }
  else                                  { $lang = 'en'; }
  $_SESSION['lang'] = $lang;
  setcookie('lang', $lang, time()+31536000, '/', '', false, true);
}

// 3) Charger le dico (et forcer reload si OPcache)
$baseDir  = __DIR__ . '/../lang';
$langFile = $baseDir . '/' . $lang . '.php';
if (!file_exists($langFile)) { $lang='en'; $langFile = $baseDir . '/en.php'; }
if (function_exists('opcache_invalidate')) { @opcache_invalidate($langFile, true); }
$lang_array = require $langFile;

// 4) Helper
if (!function_exists('t')) {
  function t($key, $fallback = ''){
    global $lang_array;
    return $lang_array[$key] ?? ($fallback !== '' ? $fallback : $key);
  }
}

// 5) Exposer au JS
if (!function_exists('expose_i18n_to_js')) {
  function expose_i18n_to_js(){
    global $lang_array, $lang;
    echo '<script>window.I18N_LANG=' . json_encode($lang) . ';window.I18N=' . json_encode($lang_array, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES) . ';</script>';
  }
}
