<?php
// /i18n.js.php — exposes the dictionary synchronously as JavaScript
require_once __DIR__.'/includes/lang.php';
header('Content-Type: application/javascript; charset=utf-8');
echo 'window.I18N_LANG='.json_encode($lang).';';
echo 'window.I18N='.json_encode($lang_array, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES).';';
?>
// Minimal helper after the dict is set
window.T = window.T || function(key, fallback){
  try { return (window.I18N && window.I18N[key]) || fallback || key; }
  catch(_) { return fallback || key; }
};
window.dispatchEvent(new Event('i18n:ready'));
