<?php
// header.php — Réseaux uniquement sur l’accueil (index), bouton Retour ailleurs.
// Gère l’état initial côté PHP, puis se met à jour côté JS pour la navigation AJAX.
$script = strtolower(basename($_SERVER['SCRIPT_NAME'] ?? $_SERVER['PHP_SELF'] ?? ''));
$isHome = ($script === '' || $script === 'index.php');

// Liens réseaux (modifie si besoin)
$instagramUrl = 'https://instagram.com/meltlabz.us';
$telegramUrl  = 'https://t.me/MeltLabz';
?>
<style>
  .topbar{display:flex;justify-content:space-between;align-items:center;padding:8px 12px}
  .topbar-left{display:flex;align-items:center;gap:8px}
  .social-wrap{display:flex;gap:8px}
  .social-btn,.back-btn{width:36px;height:36px;border-radius:12px;border:1px solid rgba(255,255,255,.25);
    background:rgba(255,255,255,.15);backdrop-filter:blur(8px);box-shadow:0 4px 14px rgba(0,0,0,.22);
    display:flex;align-items:center;justify-content:center;transition:transform .12s ease, box-shadow .18s ease}
  .social-btn:hover,.back-btn:hover{transform:translateY(-1px);box-shadow:0 6px 18px rgba(0,0,0,.28)}
  .social-btn img{width:22px;height:22px;display:block}
  .topbar .back-btn[hidden], .topbar #social-home[hidden]{display:none !important;visibility:hidden !important}
  @media (max-width:380px){
    .social-btn,.back-btn{width:32px;height:32px;border-radius:10px}
    .social-btn img{width:20px;height:20px}
  }
</style>

<div class="topbar">
  <div class="topbar-left">
    <!-- Réseaux (accueil uniquement) -->
    <div id="social-home" class="social-wrap" <?= $isHome ? '' : 'hidden' ?>>
      <a class="social-btn" href="<?= htmlspecialchars($instagramUrl) ?>" target="_blank" rel="noopener">
        <img src="assets/img/icons/instagram.svg" alt="Instagram">
      </a>
      <a class="social-btn" href="<?= htmlspecialchars($telegramUrl) ?>" target="_blank" rel="noopener">
        <img src="assets/img/icons/telegram.svg" alt="Telegram">
      </a>
    </div>
    <!-- Bouton Retour (pages internes) -->
    <button class="back-btn" id="back-btn" <?= $isHome ? 'hidden' : '' ?> title="Retour" aria-label="Retour" type="button">🔙</button>
  </div>

  <div class="langbar" role="navigation" aria-label="Sélecteur de langue">
    <a href="?lang=en" class="lang-link" hreflang="en"><img src="assets/img/icons/en.svg" alt="English" class="lang-flag"></a>
    <a href="?lang=es" class="lang-link" hreflang="es"><img src="assets/img/icons/es.svg" alt="Español" class="lang-flag"></a>
    <a href="?lang=fr" class="lang-link" hreflang="fr"><img src="assets/img/icons/fr.svg" alt="Français" class="lang-flag"></a>
  </div>
</div>

<script>
// Header SPA toggle — affiche réseaux sur l’accueil, retour ailleurs
(function(){
  function isHomeUrl(u){
    try{
      var url = u ? new URL(u, location.href) : window.location;
      var p = (url.pathname || '/').replace(/\/+$/, '');
      return p === '' || p === '/' || /\/index\.php$/i.test(p);
    }catch(e){ return false; }
  }
  function updateHeader(u){
    var home = isHomeUrl(u);
    var socials = document.getElementById('social-home');
    var back = document.getElementById('back-btn');
    if (socials) socials.hidden = !home;
    if (back)    back.hidden    = home;
  }
  // Initial
  updateHeader();

  // Patch pushState pour capter les navigations AJAX
  var _ps = history.pushState;
  history.pushState = function(state, title, url){
    var r = _ps.apply(this, arguments);
    try{ updateHeader(url); }catch(_){}
    return r;
  };
  // Back/forward
  window.addEventListener('popstate', function(){ updateHeader(); });
})();
</script>

<script>
(function(){
  function isHomeUrl(u){
    try{
      var url = u ? new URL(u, location.href) : window.location;
      var p = (url.pathname || '/').replace(/\/+$/, '');
      return p === '' || p === '/' || /\/index\.php$/i.test(p);
    }catch(e){ return false; }
  }

  // Crée (une fois) un bloc réseaux à droite en clonant #social-home
  function ensureSocialRight(){
    var sr = document.getElementById('social-right');
    if (!sr) {
      var src = document.getElementById('social-home');
      var langbar = document.querySelector('.langbar');
      if (src && langbar && langbar.parentNode) {
        sr = src.cloneNode(true);
        sr.id = 'social-right';
        sr.removeAttribute('hidden'); // au cas où
        // place juste après la langbar (même parent, même styles)
        langbar.parentNode.insertBefore(sr, langbar.nextSibling);
      }
    }
    return sr;
  }

  function updateHeader(){
    var home = isHomeUrl();
    var langbar     = document.querySelector('.langbar');
    var socialHome  = document.getElementById('social-home');
    var backBtn     = document.getElementById('back-btn');
    var socialRight = ensureSocialRight();

    if (langbar)     langbar.style.display    = home ? ''    : 'none'; // drapeaux à droite
    if (socialRight) socialRight.style.display= home ? 'none': '';     // réseaux à droite (pages internes)
    if (socialHome)  socialHome.style.display = home ? ''    : 'none'; // réseaux à gauche (index uniquement)
    if (backBtn)     backBtn.style.display    = home ? 'none': '';     // bouton retour (pages internes)
  }

  // Init + support navigation AJAX
  updateHeader();
  var _ps = history.pushState;
  history.pushState = function(s, t, u){ var r = _ps.apply(this, arguments); try{ updateHeader(); }catch(_){} return r; };
  window.addEventListener('popstate', updateHeader);
})();
</script>
<script>
(function () {
  // === Détection page produit ===
  var p = location.pathname || "";
  var s = new URLSearchParams(location.search);
  var isProduct = /(?:^|\/)product(?:\.php)?(?:\/|$)/i.test(p) || s.get("page") === "product";
  if (!isProduct) return;

  var DEST = "/index.php";

  // === 0) Surveille si le header est injecté plus tard (SPA, includes async) ===
  var tried = false;
  var mo = new MutationObserver(function(){ if (!tried) tried = !!hijackBackButton(); });
  mo.observe(document.documentElement, {subtree:true, childList:true, attributes:false});
  // tentatives immédiates et différées
  setTimeout(function(){ if (!tried) tried = !!hijackBackButton(); }, 0);
  setTimeout(function(){ if (!tried) tried = !!hijackBackButton(); }, 200);
  setTimeout(function(){ if (!tried) tried = !!hijackBackButton(); }, 800);

  // === 1) Neutralise tous les "retours" (back, go(-1), bouton navigateur) ===
  try {
    var _go = history.go.bind(history);
    history.back = function(){ location.replace(DEST); };
    history.go   = function(n){ if (n == -1 || n === "-1") { location.replace(DEST); } else { _go(n); } };
    history.pushState({prod:1}, "");
    addEventListener("popstate", function(){ location.replace(DEST); }, {passive:true});
  } catch(e){}

  // === 2) Intercepte *globalement* tout clic "retour" avant vos handlers (capture) ===
  document.addEventListener("click", function (ev) {
    var el = ev.target.closest("a,button,[role='button'],[onclick]");
    if (!el) return;
    if (looksLikeBack(el)) {
      ev.preventDefault();
      ev.stopImmediatePropagation();
      location.replace(DEST);
    }
  }, true); // capture pour passer avant d'autres listeners

  // === 3) Remplacement ciblé du bouton visuel (clone -> supprime tous les anciens listeners) ===
  function hijackBackButton(){
    var header = document.querySelector("header, .main-header, .navbar, .site-header") || document;
    var candidates = Array.from(header.querySelectorAll("a,button,[role='button'],[onclick]"))
      .filter(looksLikeBack);
    if (!candidates.length) return false;

    // on prend celui le plus à gauche (souvent le vrai bouton retour)
    candidates.sort(function(a,b){ return a.getBoundingClientRect().left - b.getBoundingClientRect().left; });
    var el = candidates[0];
    if (!el || el.__forcedBack) return !!el;

    var clone = el.cloneNode(true);
    clone.__forcedBack = true;
    clone.removeAttribute("onclick");
    if (clone.tagName.toLowerCase() === "a") {
      clone.setAttribute("href", DEST);
    } else {
      clone.setAttribute("data-href", DEST);
    }
    clone.addEventListener("click", function(e){
      e.preventDefault();
      e.stopImmediatePropagation();
      location.replace(DEST);
    });

    try { el.parentNode.replaceChild(clone, el); } catch(e){}
    return true;
  }

  // Heuristique robuste pour reconnaître un bouton "retour" sans connaître ton HTML
  function looksLikeBack(el){
    if (!el) return false;
    var txt = (el.textContent || "").trim().toLowerCase();
    var cls = (el.className || "").toLowerCase();
    var tit = (el.getAttribute("title") || "").toLowerCase();
    var aria= (el.getAttribute("aria-label") || "").toLowerCase();
    var href= (el.getAttribute("href") || "").toLowerCase();
    var oncl= (el.getAttribute("onclick") || "").toLowerCase();
    return (
      /\bretour\b|\bback\b/.test(txt) ||
      /\bretour\b|\bback\b/.test(cls) ||
      /\bretour\b|\bback\b/.test(tit) ||
      /\bretour\b|\bback\b/.test(aria) ||
      href === "javascript:history.back()" ||
      href === "#" ||
      oncl.indexOf("history.back") !== -1 ||
      oncl.indexOf("history.go(-1)") !== -1
    );
  }
})();
</script>
