<?php
require_once __DIR__.'/includes/lang.php';

// Page asset versions (auto-added)
$page_css_ver = @filemtime(__DIR__ . '/assets/css/detail.css') ?: time();
$page_js_ver  = @filemtime(__DIR__ . '/assets/js/detail.js') ?: time();

// detail_product.php — Style Apple vertical, centré, ajout panier (fallback auto) sans reload
try {
$isAjax = isset($_GET['ajax']) || (strtolower($_SERVER['HTTP_X_REQUESTED_WITH'] ?? '') === 'xmlhttprequest');
ob_start();
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/tg_boot_soft.php';


  $id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
  if ($id <= 0) { http_response_code(400); exit(''); }

  // Produit
  $stmt = $pdo->prepare("SELECT id, nom, image, categorie, farm, description FROM produits WHERE id=:id LIMIT 1");
  $stmt->execute(['id'=>$id]);
  $p = $stmt->fetch(PDO::FETCH_ASSOC);
  if (!$p) { http_response_code(404); exit(''); }

  // Prix
  $st = $pdo->prepare("SELECT quantite, prix FROM produit_prix WHERE produit_id=:id ORDER BY quantite ASC");
  $st->execute(['id'=>$id]);
  $prices = $st->fetchAll(PDO::FETCH_ASSOC);

  // === Médias depuis produit_medias (vidéo en premier) ===
  $ms = $pdo->prepare("
    SELECT id, produit_id, media_path, type
    FROM produit_medias
    WHERE produit_id = :id
    ORDER BY CASE WHEN type='video' THEN 0 ELSE 1 END, id ASC
  ");
  $ms->execute(['id'=>$id]);
  $medias = $ms->fetchAll(PDO::FETCH_ASSOC);

  // Fallback visuel si aucun média
  if (!$medias && !empty($p['image'])) {
    $medias = [[ 'id'=>0, 'produit_id'=>$id, 'media_path'=>$p['image'], 'type'=>'image' ]];
  }

  // Index initial : vidéo d’abord
  $initialIndex = 0;
  foreach ($medias as $i=>$m) {
    if (strtolower($m['type'] ?? '') === 'video' || preg_match('~\.(mp4|webm|mov)$~i', (string)$m['media_path'])) {
      $initialIndex = $i; break;
    }
  }
?>
<?php
require_once __DIR__ . '/includes/currency.php'; // mlz_format_price(), boot JSON
?>
<script>
  // Boot pour currency.js (code, rate, symbol, etc.)
  window.MLZ_CURRENCY_BOOT = <?= mlz_currency_boot_json() ?>;
</script>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= htmlspecialchars($p['nom']) ?> — MeltLabz</title>
  <link rel="stylesheet" href="assets/css/main.css">

  <!-- Tu peux changer le nom de ta fonction panier ici si tu veux forcer un nom précis -->
  <meta name="mlz-cart-fn" content="addToCart" />

  <link rel="stylesheet" href="assets/css/detail.css?v=<?= $page_css_ver ?>">
  <style>
/* --- Patch galerie détail : rétablit une grande zone média responsive --- */
.mlz-apple.mlz-detail .product-card .product-image{
  aspect-ratio: auto !important;           /* on libère le ratio */
  height: clamp(320px, 58vh, 520px) !important;  /* ← ajuste ici si tu veux plus/moins grand */
  max-height: none !important;
}

/* le viewer interne peut alors occuper toute la hauteur */
.mlz-apple.mlz-detail .product-card .product-image .mlz-view{
  height: 100% !important;
}

/* neutralise les règles qui mettaient width:auto sur les médias */
.mlz-apple.mlz-detail .product-card .product-image .mlz-slide img,
.mlz-apple.mlz-detail .product-card .product-image .mlz-slide video{
  width: 100% !important;
  height: 100% !important;
  max-width: none !important;
  max-height: none !important;
  object-fit: contain !important;   /* mets 'cover' si tu préfères plein cadre */
  object-position: center !important;
}
</style>


  <style>
    :root{ --mlz-dock-h:100px; --mlz-dock-gap:14px; }
    /* product-card scroll has bottom space so content never goes under dock */
    .mlz-apple.mlz-detail .product-card{
      padding-bottom: calc(var(--mlz-dock-h) + var(--mlz-dock-gap)) !important;
    }
    .mlz-apple.mlz-detail .product-card .mlz-dock-spacer{
      height: calc(var(--mlz-dock-h) + var(--mlz-dock-gap));
      flex: 0 0 auto;
    }
  </style>
</head>
<body>

  <?php if(!$isAjax) include __DIR__ . '/header.php'; ?>

  <div class="mlz-apple mlz-detail">
    <div class="mlz-products">
      <div class="mlz-scroll">
        <div class="mlz-wrap">
          <div class="row">
            <div class="col-12">
              <div class="product-card">

                <!-- ========== PATCH CSS: grand viewer + centrage + override global ========== -->
                <style>
                  /* Card: scroll discret uniquement dans la carte (évite le débordement bas) */
                  .product-card{
                    max-height: calc(100svh - 110px - env(safe-area-inset-top,0) - env(safe-area-inset-bottom,0));
                    overflow: auto; overscroll-behavior: contain;
                    scrollbar-width: none;
                  }
                  .product-card::-webkit-scrollbar{ width:0; height:0; }

                  /* Zone image centrée */
                  .product-card .product-image{
                    display:flex !important; flex-direction:column !important; align-items:center !important;
                    width:100% !important; margin:0 auto 12px !important; box-sizing:border-box !important;
                  }

                  /* >>> GRAND VIEWER, vraiment responsive et prioritaire sur les CSS globaux <<< */
                  .product-card .product-image .mlz-view{
                    position:relative !important; width:100% !important;
                    height: clamp(340px, 60vh, 520px) !important;      /* ← augmente/descend ici */
                    border-radius:20px 20px 0 0 !important;
                    overflow:hidden !important; background:#000 !important;
                  }
                  /* Slides */
                  .product-card .product-image .mlz-slide{
                    position:absolute !important; inset:0 !important;
                    display:none !important; align-items:center !important; justify-content:center !important;
                  }
                  .product-card .product-image .mlz-slide.is-active{ display:flex !important; }

                  /* Neutralise TOUT style global gênant sur les médias */
                  .product-card .product-image .mlz-slide img,
                  .product-card .product-image .mlz-slide video{
                    width:100% !important; height:100% !important;
                    max-width:none !important; max-height:none !important;
                    object-fit: cover !important;   /* plein cadre (mets contain si tu préfères) */
                    object-position:center !important;
                    display:block !important; background:#000 !important; border-radius:inherit !important;
                  }

                  /* Flèches au-dessus des contrôles vidéo */
                  .product-card .product-image .mlz-arrow{
                    position:absolute !important; top:50% !important; transform:translateY(-50%) !important;
                    width:46px !important; height:46px !important; border-radius:50% !important;
                    background:rgba(10,14,23,.95) !important; border:1px solid rgba(255,255,255,.14) !important;
                    display:grid !important; place-items:center !important; cursor:pointer !important;
                    z-index:50 !important; pointer-events:auto !important;
                  }
                  .product-card .product-image .mlz-arrow svg{ width:22px !important; height:22px !important; fill:#fff; }
                  .product-card .product-image .mlz-arrow.prev{ left:12px !important; }
                  .product-card .product-image .mlz-arrow.next{ right:12px !important; }

                  /* Barre des bulles */
                  .product-card .product-image .mlz-thumbs-bar{
                    width:100% !important; background:rgba(10,14,23,.88) !important;
                    border:1px solid rgba(255,255,255,.12) !important; border-top:0 !important;
                    border-radius:0 0 20px 20px !important; padding:10px 8px !important; margin:0 !important;
                    box-sizing:border-box !important;
                  }
                  .product-card .product-image .mlz-thumbs{
                    display:flex !important; gap:12px !important; flex-wrap:nowrap !important; justify-content:center !important;
                    overflow-x:auto !important; overflow-y:hidden !important; -webkit-overflow-scrolling:touch !important; scrollbar-width:none !important;
                  }
                  .product-card .product-image .mlz-thumbs::-webkit-scrollbar{ display:none !important; }
                  .product-card .product-image .mlz-thumb{
                    position:relative !important; width:56px !important; height:56px !important;
                    border-radius:999px !important; overflow:hidden !important; flex:0 0 auto !important;
                    outline:1px solid rgba(255,255,255,.12) !important; border:2px solid transparent !important; background:#0d1117 !important;
                  }
                  .product-card .product-image .mlz-thumb.is-active{ border-color:#f3a400 !important; box-shadow:0 10px 26px rgba(243,164,0,.25) !important; }
                  .product-card .product-image .mlz-thumb img,
                  .product-card .product-image .mlz-thumb video{ width:100% !important; height:100% !important; object-fit:cover !important; display:block !important; }
                  .product-card .product-image .mlz-thumb .video-badge{
                    position:absolute !important; right:6px !important; bottom:6px !important;
                    background:rgba(0,0,0,.6) !important; color:#fff !important; font-size:11px !important; padding:2px 6px !important; border-radius:999px !important;
                  }
                  /* === Description pliable (2 lignes) === */
.mlz-desc{ position:relative; margin-top:8px; }

/* Fermé : clamp à 2 lignes + petit fondu bas */
.mlz-desc-content .product-meta{
  display:-webkit-box !important;
  -webkit-box-orient: vertical !important;
  -webkit-line-clamp: 2 !important;
  overflow:hidden !important;
  margin:0;
}
.mlz-desc-content{
  max-height: 4.2em; /* ~2 lignes selon ta font/line-height */
  transition:max-height .35s cubic-bezier(.2,.8,.2,1);
  -webkit-mask-image: linear-gradient(180deg,#000 72%, transparent 100%);
          mask-image: linear-gradient(180deg,#000 72%, transparent 100%);
}

/* Bouton plus PETIT — caché par défaut, affiché seulement si .has-more */
.mlz-desc-btn{
  display:none; /* visible seulement si .has-more (JS) */
  align-items:center; gap:6px; margin-top:6px; padding:6px 10px;
  border-radius:999px; font-size:12px; line-height:1; cursor:pointer;
  border:1px solid rgba(255,255,255,.14);
  background:rgba(10,14,23,.55); backdrop-filter:blur(6px);
  transition:transform .18s ease, background .18s ease, border-color .18s ease;
}
.mlz-desc.has-more .mlz-desc-btn{ display:inline-flex; }
.mlz-desc-btn:hover{ transform:translateY(-1px); background:rgba(10,14,23,.7); }
.mlz-desc-btn .chev{ width:14px; height:14px; fill:currentColor; opacity:.9; transition:transform .3s ease; }
.mlz-desc-btn .less{ display:none; }

/* Ouvert : on enlève le clamp et le masque -> on voit TOUT le texte */
.mlz-desc-toggle:checked ~ .mlz-desc-content{
  max-height: 2000px;
  -webkit-mask-image:none; mask-image:none;
}
.mlz-desc-toggle:checked ~ .mlz-desc-content .product-meta{
  -webkit-line-clamp:unset !important; display:block !important;
}
.mlz-desc-toggle:checked ~ .mlz-desc-btn .chev{ transform:rotate(180deg); }
.mlz-desc-toggle:checked ~ .mlz-desc-btn .more{ display:none; }
.mlz-desc-toggle:checked ~ .mlz-desc-btn .less{ display:inline; }
/* === Bouton "Afficher plus" couleur miel (compact & lisible) === */
.mlz-desc.has-more .mlz-desc-btn{ display:inline-flex; } /* si tu le caches par défaut */

/* palette miel */
.mlz-apple.mlz-detail{
  --miel-1: #f9b200;
  --miel-2: #f3a400;
  --miel-text: #1a1300;
}

.mlz-desc-btn{
  display:inline-flex; align-items:center; gap:6px;
  padding:5px 9px;                 /* compact */
  font-size:11.5px; line-height:1;
  border-radius:999px; border:0;
  color:var(--miel-text);
  background:linear-gradient(180deg,var(--miel-1),var(--miel-2));
  box-shadow:
    inset 0 1px 0 rgba(255,255,255,.25),
    0 6px 18px rgba(243,164,0,.25);
  cursor:pointer; user-select:none;
  transition:transform .15s ease, filter .15s ease, box-shadow .15s ease;
}
.mlz-desc-btn .chev{ width:14px; height:14px; fill:currentColor; opacity:.95; }

/* Hover/focus/active */
.mlz-desc-btn:hover{ filter:brightness(1.06); transform:translateY(-1px); }
.mlz-desc-btn:active{ transform:none; }
.mlz-desc-btn:focus-visible{
  outline:2px solid rgba(243,164,0,.8);
  outline-offset:2px;
  box-shadow:
    inset 0 1px 0 rgba(255,255,255,.25),
    0 0 0 4px rgba(243,164,0,.18),
    0 6px 18px rgba(243,164,0,.28);
}

/* état ouvert (texte du bouton & chevron) */
.mlz-desc-btn .less{ display:none; }
.mlz-desc-toggle:checked ~ .mlz-desc-btn .chev{ transform:rotate(180deg); }
.mlz-desc-toggle:checked ~ .mlz-desc-btn .more{ display:none; }
.mlz-desc-toggle:checked ~ .mlz-desc-btn .less{ display:inline; }

                </style>

                <!-- ===== Galerie médias (produit_medias) ===== -->
                <div class="product-image">
                  <div class="mlz-view" id="mlz-viewer">
                    <?php foreach ($medias as $i=>$m):
                      $path = htmlspecialchars((string)($m['media_path'] ?? ''), ENT_QUOTES);
                      $isVid = (strtolower($m['type'] ?? '') === 'video') || preg_match('~\.(mp4|webm|mov)$~i', $path);
                    ?>
                      <div class="mlz-slide<?= ($i===$initialIndex?' is-active':'') ?>" data-index="<?= $i ?>">
                        <?php if ($isVid): ?>
                          <video preload="metadata" playsinline muted controls controlsList="nodownload noplaybackrate">
                            <source src="<?= $path ?>" type="video/mp4">
                          </video>
                        <?php else: ?>
                          <img src="<?= $path ?>" alt="media <?= $i+1 ?>" draggable="false">
                        <?php endif; ?>
                      </div>
                    <?php endforeach; ?>

                    <?php if (count($medias) > 1): ?>
                      <button class="mlz-arrow prev" type="button" aria-label="Précédent">
                        <svg viewBox="0 0 24 24"><path d="M15.41 7.41 14 6l-6 6 6 6 1.41-1.41L10.83 12z"/></svg>
                      </button>
                      <button class="mlz-arrow next" type="button" aria-label="Suivant">
                        <svg viewBox="0 0 24 24"><path d="M8.59 16.59 13.17 12 8.59 7.41 10 6l6 6-6 6z"/></svg>
                      </button>
                    <?php endif; ?>
                  </div>

                  <!-- Bulles -->
                  <div class="mlz-thumbs-bar">
                    <div class="mlz-thumbs" id="mlz-thumbs" role="tablist" aria-label="Miniatures">
                      <?php foreach ($medias as $i=>$m):
                        $path = htmlspecialchars((string)($m['media_path'] ?? ''), ENT_QUOTES);
                        $isVid = (strtolower($m['type'] ?? '') === 'video') || preg_match('~\.(mp4|webm|mov)$~i', $path);
                      ?>
                        <button class="mlz-thumb<?= ($i===$initialIndex?' is-active':'') ?>"
                                type="button" data-index="<?= $i ?>" role="tab"
                                aria-selected="<?= $i===$initialIndex ? 'true':'false' ?>">
                          <?php if ($isVid): ?>
                            <video preload="metadata" muted playsinline>
                              <source src="<?= $path ?>#t=0.1" type="video/mp4">
                            </video>
                            <span class="video-badge">▶︎</span>
                          <?php else: ?>
                            <img src="<?= $path ?>" alt="thumb <?= $i+1 ?>" draggable="false">
                          <?php endif; ?>
                        </button>
                      <?php endforeach; ?>
                    </div>
                  </div>
                </div>

                <!-- Contenu -->
                <div class="product-content">
                  <div class="badges-row">
  <?php $strain = $p['categorie'] ?? null; if ($strain): ?>
    <span class="badge-strain">🌿 <?= htmlspecialchars($strain) ?></span>
  <?php endif; ?>

  <?php if (!empty($p['farm'])): ?>
    <span class="badge-farm"><?= htmlspecialchars($p['farm']) ?></span>
  <?php endif; ?>
</div>


                  <div class="product-title"><strong><?= htmlspecialchars($p['nom']) ?></strong></div>

                  
  <div class="mlz-desc">
    <input type="checkbox" id="desc-more-<?= (int)$p['id'] ?>" class="mlz-desc-toggle" hidden>
    <div class="mlz-desc-content">
      <p class="product-meta"><?= nl2br(htmlspecialchars($p['description'])) ?></p>
    </div><?php if (!empty($p['description'])): ?>
    <label for="desc-more-<?= (int)$p['id'] ?>" class="mlz-desc-btn" aria-controls="mlz-desc-content">
  <svg class="chev" viewBox="0 0 24 24" aria-hidden="true"><path d="M7.41 8.59 12 13.17l4.59-4.58L18 10l-6 6-6-6z"/></svg>
  <span class="more"><?= t('detail.show_more') ?></span>
<span class="less" style="display:none;"><?= t('detail.show_less') ?></span>
</label>

  </div>
<?php endif; ?>


                  
                  <!-- 👇 séparateur "Sélectionner une quantité :" -->
                 <div class="mlz-section-title"><?= t('detail.select_qty') ?></div>

                  
                  <?php if (!empty($prices)): ?>
                    <div class="prices-row">
                      <?php foreach ($prices as $row):
                        $qRaw = $row['quantite'];
                        if (is_numeric($qRaw) && floor((float)$qRaw) == (float)$qRaw) {
                          $qNum = (int)$qRaw; // keep integers like 100/1000 intact
                        } else {
                          $qNum = (float) rtrim(rtrim(number_format((float)$qRaw, 3, '.', ''), '0'), '.');
                        }
                        $pNum = (float)$row['prix'];
                        $pDisp = number_format($pNum, 2, ',', ' ');
                      ?>
                        <button type="button"
        class="badge-price js-qty"
        data-pid="<?= (int)$p['id'] ?>"
        data-qty="<?= htmlspecialchars($qNum) ?>"
        data-price="<?= htmlspecialchars($pNum) ?>">
  <?= htmlspecialchars($qNum) ?>G |  
  <span class="js-price"
        data-price-eur="<?= number_format((float)$pNum, 2, '.', '') ?>">
    <?= mlz_format_price((float)$pNum) ?>
  </span>
</button>

                      <?php endforeach; ?>
                    </div>

                    <div class="mt-2">
                      <button id="mlz-add-btn" class="mlz-btn-add" disabled><?= t('detail.add_to_cart') ?></button>

                    </div>
                  <?php endif; ?>
                </div>

                <!-- ===== JS du slider (inline pour fonctionner aussi en AJAX) ===== -->
                <script>
                (function(){
                  const viewer = document.getElementById('mlz-viewer');
                  if(!viewer) return;

                  const slides = Array.from(viewer.querySelectorAll('.mlz-slide'));
                  const thumbs = Array.from(document.querySelectorAll('#mlz-thumbs .mlz-thumb'));
                  const prev = viewer.querySelector('.mlz-arrow.prev');
                  const next = viewer.querySelector('.mlz-arrow.next');
                  let idx = <?= (int)$initialIndex ?>;

                  function setActive(i){
                    slides.forEach((s,k)=>{
                      if(k===i){ s.classList.add('is-active'); }
                      else{
                        const v=s.querySelector('video'); if(v){ v.pause(); v.currentTime=0; }
                        s.classList.remove('is-active');
                      }
                    });
                    thumbs.forEach((t,k)=> t.classList.toggle('is-active', k===i));
                  }

                  function show(i){
                    if (!slides.length) return;
                    if (i<0) i = slides.length-1;
                    if (i>=slides.length) i = 0;
                    idx = i;
                    setActive(idx);
                    const v = slides[idx].querySelector('video');
                    if (v){ v.play().catch(()=>{}); }
                  }

                  // Events (stop propagation pour éviter que la vidéo avale les clics)
                  thumbs.forEach(t=>{
                    t.addEventListener('click', (e)=>{ e.preventDefault(); e.stopPropagation();
                      const to = +t.dataset.index; if(!Number.isNaN(to)) show(to);
                    }, {passive:false});
                  });
                  if (prev) prev.addEventListener('click', (e)=>{ e.preventDefault(); e.stopPropagation(); show(idx-1); }, {passive:false});
                  if (next) next.addEventListener('click', (e)=>{ e.preventDefault(); e.stopPropagation(); show(idx+1); }, {passive:false});

                  // Swipe
                  let startX=null, dragging=false;
                  viewer.addEventListener('pointerdown', e=>{ startX=e.clientX; dragging=true; viewer.style.cursor='grabbing'; });
                  window.addEventListener('pointerup', ()=>{ dragging=false; startX=null; viewer.style.cursor=''; });
                  viewer.addEventListener('pointermove', e=>{
                    if(!dragging || startX===null) return;
                    const dx = e.clientX - startX;
                    if(Math.abs(dx)>60){ show(idx + (dx<0?1:-1)); dragging=false; startX=null; viewer.style.cursor=''; }
                  });

                  // init
                  show(idx);
                })();
                </script>

              
                <div class="mlz-dock-spacer" aria-hidden="true"></div>
</div><!-- /product-card -->
            </div>
          </div>
        </div>
        <div class="mlz-dock-spacer" aria-hidden="true"></div>
      </div>
    </div>
  </div>
<style>
/* --- Forcer la cliquabilité & la superposition --- */
#mlz-viewer, #mlz-thumbs { pointer-events: auto !important; }
#mlz-viewer .mlz-arrow,
#mlz-thumbs .mlz-thumb { pointer-events: auto !important; }

#mlz-viewer .mlz-arrow{
  z-index: 9999 !important;                  /* au-dessus des contrôles vidéo */
}
#mlz-viewer .mlz-slide img,
#mlz-viewer .mlz-slide video{
  pointer-events: auto !important;           /* on garde les contrôles, mais nos boutons passent au-dessus */
}
</style>

<script>
/* --- Rebinding robuste des flèches/bulles + swipe --- */
(function(){
  const viewer = document.getElementById('mlz-viewer');
  if(!viewer) return;

  // On scope TOUT au viewer / à la card pour éviter les conflits
  const slides = Array.from(viewer.querySelectorAll('.mlz-slide'));
  const thumbs = Array.from(document.querySelectorAll('#mlz-thumbs .mlz-thumb'));
  const prev   = viewer.querySelector('.mlz-arrow.prev');
  const next   = viewer.querySelector('.mlz-arrow.next');

  if (!slides.length) return;

  let idx = slides.findIndex(s => s.classList.contains('is-active'));
  if (idx < 0) idx = 0;

  function activate(n){
    n = (n + slides.length) % slides.length;

    slides.forEach((s, k) => {
      if (k === n) {
        s.classList.add('is-active');
      } else {
        const v = s.querySelector('video');
        if (v){ v.pause(); v.currentTime = 0; }
        s.classList.remove('is-active');
      }
    });

    thumbs.forEach((t, k) => t.classList.toggle('is-active', k === n));

    const v2 = slides[n].querySelector('video');
    if (v2){ v2.play().catch(()=>{}); }

    idx = n;
  }

  function goPrev(e){ if(e){ e.preventDefault(); e.stopPropagation(); } activate(idx - 1); }
  function goNext(e){ if(e){ e.preventDefault(); e.stopPropagation(); } activate(idx + 1); }

  // Flèches (click + pointerdown pour certains webviews un peu capricieux)
  if (prev){ prev.addEventListener('click', goPrev, {passive:false}); prev.addEventListener('pointerdown', goPrev, {passive:false}); }
  if (next){ next.addEventListener('click', goNext, {passive:false}); next.addEventListener('pointerdown', goNext, {passive:false}); }

  // Bulles
  thumbs.forEach((t, k) => {
    t.addEventListener('click', (e)=>{ e.preventDefault(); e.stopPropagation(); activate(k); }, {passive:false});
  });

  // Swipe gauche/droite sur le viewer
  let startX = null, dragging = false;
  viewer.addEventListener('pointerdown', (e)=>{ startX = e.clientX; dragging = true; viewer.style.cursor='grabbing'; }, {passive:true});
  window.addEventListener('pointerup', ()=>{ dragging = false; startX = null; viewer.style.cursor=''; }, {passive:true});
  viewer.addEventListener('pointermove', (e)=>{
    if (!dragging || startX === null) return;
    const dx = e.clientX - startX;
    if (Math.abs(dx) > 60){ activate(idx + (dx < 0 ? 1 : -1)); dragging = false; startX = null; viewer.style.cursor=''; }
  }, {passive:true});

  // Init
  activate(idx);
})();
</script>
<!-- ===== PATCH CLIQUABLE (flèches + bulles) — À COLLER JUSTE AVANT </body> ===== -->
<style>
  /* 1) Les mini-vidéos des bulles ne doivent pas intercepter le clic */
  #mlz-thumbs .mlz-thumb video { pointer-events: none !important; }

  /* 2) Désactive les overlays transparents qui masquent les clics */
  .product-card .product-image::before,
  .product-card .product-image::after,
  #mlz-viewer::before,
  #mlz-viewer::after { pointer-events: none !important; }

  /* 3) Empilement au-dessus de la vidéo (iOS/Telegram) */
  #mlz-viewer{
    position: relative !important;
    z-index: 2147483646 !important;   /* très haut */
    touch-action: pan-y;              /* swipe horizontal autorisé */
  }
  #mlz-viewer .mlz-arrow{
    position:absolute; top:50%; transform:translateY(-50%) translateZ(0);
    width:44px; height:44px; border-radius:50%;
    z-index:2147483647 !important;    /* plus haut que tout */
    pointer-events:auto !important;
  }
  #mlz-viewer .mlz-arrow.prev{ left:12px; }
  #mlz-viewer .mlz-arrow.next{ right:12px; }

  /* Les bulles doivent rester au-dessus de tout également */
  .mlz-thumbs-bar, #mlz-thumbs{ position:relative; z-index:2147483647 !important; }
  #mlz-thumbs .mlz-thumb{ pointer-events:auto !important; }

  /* === FIX galerie détail : taille & clics === */

/* 1) Reprendre la main sur la taille (annule le bloc "Compactage V3.1") */
.mlz-apple.mlz-detail .product-card .product-image{
  aspect-ratio: auto !important;
  height: clamp(230px, 46vh, 420px) !important; /* ajuste à ton goût */
  max-height: 62vh !important;
  width: 100% !important;
  min-width: 0 !important; /* contre la règle globale 112px */
}

/* médias plein cadre (ou contain si tu préfères) */
.mlz-apple.mlz-detail .product-card .product-image img,
.mlz-apple.mlz-detail .product-card .product-image video{
  width: 100% !important;
  height: 100% !important;
  object-fit: contain !important;  /* mets 'cover' si tu veux remplir */
  object-position: center !important;
}

/* 2) Neutralise l’effet des styles globaux des cartes horizontales */
.product-card .product-image{ width:auto; min-width:0; } /* sur cette page, c’est vertical */

/* 3) Clics : mets la couche des flèches/bulles au-dessus de la vidéo */
#mlz-viewer{ position:relative; z-index: 10; touch-action: pan-y; }
#mlz-viewer .mlz-arrow{
  position:absolute; top:50%; transform:translateY(-50%);
  width:44px; height:44px; border-radius:50%;
  z-index: 9999 !important; pointer-events:auto !important;
}
#mlz-viewer .mlz-arrow.prev{ left:12px; }
#mlz-viewer .mlz-arrow.next{ right:12px; }

/* bulles toujours cliquables (les mini-vidéos ne captent plus le clic) */
.mlz-thumbs-bar, #mlz-thumbs{ position:relative; z-index: 9999 !important; }
#mlz-thumbs .mlz-thumb video{ pointer-events:none !important; }
/* Couleur miel foncée pour la barre des bulles + fond interne */
.mlz-apple.mlz-detail .product-card .product-image .mlz-thumbs-bar{
  background: rgb(56 44 26) !important;
  border: 0 !important;
}

.mlz-apple.mlz-detail .product-card .product-image .mlz-thumbs{
  background: rgb(56 44 26) !important;   /* au cas où le conteneur interne couvre la barre */
}

/* s’il existe des overlays décoratifs, on les neutralise */
.mlz-apple.mlz-detail .product-card .product-image .mlz-thumbs-bar::before,
.mlz-apple.mlz-detail .product-card .product-image .mlz-thumbs-bar::after{
  background: none !important;
}

/* coins coordonnés avec le viewer (optionnel) */
.mlz-apple.mlz-detail .product-image .mlz-view{ border-radius:16px 16px 0 0 !important; }
.mlz-apple.mlz-detail .product-image .mlz-thumbs-bar{ border-radius:0 0 16px 16px !important; }
/* --- Lueur des bulles non coupée (au-dessus du viewer) --- */
.mlz-apple.mlz-detail .product-card .product-image .mlz-thumbs-bar,
.mlz-apple.mlz-detail .product-card .product-image .mlz-thumbs{
  position: relative !important;
  z-index: 5 !important;          /* > viewer */
  overflow: visible !important;    /* laisse la lueur dépasser */
  padding-top: 8px !important;     /* espace pour la lueur */
  padding-bottom: 8px !important;
}

/* garder le viewer en dessous */
.mlz-apple.mlz-detail #mlz-viewer{
  position: relative !important;
  z-index: 1 !important;
}

/* (optionnel) lueur un poil plus douce */
.mlz-apple.mlz-detail .product-image .mlz-thumb.is-active{
  box-shadow: 0 0 0 2px #f3a400, 0 0 22px rgba(243,164,0,.45) !important;
}

</style>

<script>
(function(){
  const viewer = document.getElementById('mlz-viewer');
  if (!viewer) return;

  /* Empêche toute double initialisation si un autre script existe */
  if (viewer.dataset.mlzNavFixed === '1') return;
  viewer.dataset.mlzNavFixed = '1';

  const slides = Array.from(viewer.querySelectorAll('.mlz-slide'));
  const prevBtn = viewer.querySelector('.mlz-arrow.prev');
  const nextBtn = viewer.querySelector('.mlz-arrow.next');
  const thumbsWrap = document.getElementById('mlz-thumbs');
  const thumbs = thumbsWrap ? Array.from(thumbsWrap.querySelectorAll('.mlz-thumb')) : [];
  if (!slides.length) return;

  let idx = Math.max(0, slides.findIndex(s => s.classList.contains('is-active')));

  function activate(n){
    n = (n + slides.length) % slides.length;
    slides.forEach((s,i)=>{
      if(i===n){ s.classList.add('is-active'); }
      else{
        const v=s.querySelector('video'); if(v){ v.pause(); v.currentTime=0; }
        s.classList.remove('is-active');
      }
    });
    thumbs.forEach((t,i)=> t.classList.toggle('is-active', i===n));
    const v2 = slides[n].querySelector('video'); if(v2){ v2.play().catch(()=>{}); }
    idx = n;
  }

  function goPrev(e){ if(e){ e.preventDefault(); e.stopPropagation(); e.stopImmediatePropagation(); } activate(idx-1); }
  function goNext(e){ if(e){ e.preventDefault(); e.stopPropagation(); e.stopImmediatePropagation(); } activate(idx+1); }

  /* 4) Hotzones invisibles au-dessus de TOUT (gauche/droite) */
  const hzL = document.createElement('div');
  const hzR = document.createElement('div');
  Object.assign(hzL.style, {position:'absolute', inset:'0 auto 0 0', width:'28%', zIndex:'2147483647', cursor:'pointer'});
  Object.assign(hzR.style, {position:'absolute', inset:'0 0 0 auto', width:'28%', zIndex:'2147483647', cursor:'pointer'});
  hzL.addEventListener('click', goPrev, true);
  hzR.addEventListener('click', goNext, true);
  viewer.appendChild(hzL); viewer.appendChild(hzR);

  /* Flèches (capture true pour passer avant d'éventuels stopPropagation) */
  if (prevBtn){ prevBtn.addEventListener('click', goPrev, true); prevBtn.addEventListener('pointerdown', goPrev, true); }
  if (nextBtn){ nextBtn.addEventListener('click', goNext, true); nextBtn.addEventListener('pointerdown', goNext, true); }

  /* Bulles : délégation en capture + les mini-vidéos sont déjà pointer-events:none */
  if (thumbsWrap){
    thumbsWrap.addEventListener('click', function(e){
      const btn = e.target.closest('.mlz-thumb');
      if(!btn) return;
      e.preventDefault(); e.stopPropagation(); e.stopImmediatePropagation();
      const i = parseInt(btn.dataset.index,10);
      if(!Number.isNaN(i)) activate(i);
    }, true);
  }

  /* Swipe horizontal */
  let startX=null, dragging=false;
  viewer.addEventListener('pointerdown', e=>{ startX=e.clientX; dragging=true; }, {passive:true});
  window.addEventListener('pointerup', ()=>{ dragging=false; startX=null; }, {passive:true});
  viewer.addEventListener('pointermove', e=>{
    if(!dragging || startX===null) return;
    const dx = e.clientX - startX;
    if(Math.abs(dx)>60){ dx<0 ? goNext(e) : goPrev(e); dragging=false; startX=null; }
  }, {passive:true});

  /* Init */
  activate(idx);
})();
</script>
<!-- ===== FIN PATCH ===== -->

  <?php if(!$isAjax) include __DIR__ . '/bottom_menu.php'; ?>

  <!-- Pop-ups globaux -->
  <?php if(!$isAjax) include __DIR__ . '/modal_cart.php'; ?>
  <?php if(!$isAjax) include __DIR__ . '/modal_verify.php'; ?>
  <?php if(!$isAjax) include __DIR__ . '/modal_address.php'; ?>
  <?php if(!$isAjax) include __DIR__ . '/modal_verify_result.php'; ?>

  <!-- SDK Telegram puis script -->
 <script src="https://telegram.org/js/telegram-web-app.js"></script>
<script src="assets/js/script.js?v=3"></script>
<script src="assets/js/tg_autologin_no_token.js"></script>

  <!-- Toast container -->
  <div id="mlz-toast" class="mlz-toast" role="status" aria-live="polite"></div>

  <!-- Sélection quantité + Ajout panier (fallback auto si ta fonction n'est pas exposée) -->
  

  <script src="assets/js/detail.js?v=<?= $page_js_ver ?>"></script>
<script src="assets/js/detail-init-hook.js?v=1"></script>
</body>
</html>
<?php /*__AJAX_OUTPUT__*/ $html = ob_get_clean(); if ($isAjax) { if (preg_match('/<div class=\"mlz-apple\"[\\s\\S]*<\\/div>\\s*$/m', $html, $mm)) { echo $mm[0]; } else { echo $html; } exit; } echo $html; ?>
<?php
} catch (Throwable $e) { http_response_code(500); exit(''); }
