<?php
/* === FORCE LANGUE pour AJAX/partiel === */
$__mlx_lang = $_GET['lang'] ?? null;
if (!$__mlx_lang && !empty($_COOKIE['lang'])) {
  $__mlx_lang = $_COOKIE['lang'];
}
if (!$__mlx_lang && !empty($_SERVER['HTTP_REFERER'])) {
  $refQs = parse_url($_SERVER['HTTP_REFERER'], PHP_URL_QUERY);
  if ($refQs) { parse_str($refQs, $ref); if (!empty($ref['lang'])) $__mlx_lang = $ref['lang']; }
}
if ($__mlx_lang) {
  $_GET['lang'] = $__mlx_lang;
  $_REQUEST['lang'] = $__mlx_lang;
  setcookie('lang', $__mlx_lang, time()+31536000, '/', '', false, true);
}

/**
 * crypto.php — Guide débutant BTC (Revolut / Blofin / LocalCoinSwap)
 * - Même front que info.php (card scrollable).
 * - Emphase BTC (USDT via support).
 * - Schémas SVG inline (textes -> t()).
 * - Mode partiel (?partial=1) pour l’AJAX : renvoie <style id="crypto-inline-style"> + .mlx-wrap.
 */
session_start();
require_once __DIR__.'/includes/db.php';
require_once __DIR__.'/includes/tg_boot_soft.php';
require_once __DIR__.'/includes/lang.php';

$isPartial = (isset($_GET['partial']) && $_GET['partial']=='1') ||
             (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH'])==='xmlhttprequest');

$cat_css_ver = @filemtime(__DIR__.'/assets/css/category.css') ?: time();
$det_css_ver = @filemtime(__DIR__.'/assets/css/detail.css') ?: time();
$cat_js_ver  = @filemtime(__DIR__.'/assets/js/category.js') ?: time();
$det_js_ver  = @filemtime(__DIR__.'/assets/js/detail.js') ?: time();

$pageLangAttr = htmlspecialchars($_GET['lang'] ?? ($_COOKIE['lang'] ?? 'fr'), ENT_QUOTES, 'UTF-8');

/* === CSS de la page (servi dans <head> en full, et juste avant .mlx-wrap en partiel) === */
$CRYPTO_INLINE_CSS = <<<CSS
:root{
  --mlx-bottom-nav-h: 96px;
  --mlx-safe-bottom: env(safe-area-inset-bottom, 0px);
  --mlx-card-gap: 12px;
}
.mlx-wrap{ max-width:1200px; margin:0 auto; padding:clamp(14px,4vw,40px) 12px 12px; }
.mlx-wrap.mlx-wrap-grid{
  display:grid; grid-template-rows:auto minmax(0,1fr);
  height: calc(var(--vh, 1vh) * 100 - var(--mlx-bottom-nav-h) - var(--mlx-safe-bottom) - var(--mlx-card-gap));
}
.mlx-card{
  width:min(980px, calc(100% - 48px));
  margin:6px auto 0;
  padding: clamp(18px, 2.2vw, 28px);
  background:linear-gradient(180deg, rgba(16,21,27,.62), rgba(16,21,27,.46));
  border:1px solid rgba(255,255,255,.10);
  border-radius:22px;
  box-shadow:0 18px 40px rgba(0,0,0,.35), inset 0 1px 0 rgba(255,255,255,.06);
  backdrop-filter:blur(12px); -webkit-backdrop-filter:blur(12px);
  color:#e9f0f6;
  overflow:hidden;
  display:grid; grid-template-rows:auto minmax(0,1fr);
  max-height:100%; position:relative;
}
.mlx-card::before,.mlx-card::after{ content:""; position:absolute; left:0; right:0; height:18px; pointer-events:none; }
.mlx-card::before{ top:0; background:linear-gradient(to bottom, rgba(11,15,20,.55), rgba(11,15,20,0)); border-top-left-radius:22px; border-top-right-radius:22px; }
.mlx-card::after { bottom:0; background:linear-gradient(to top,    rgba(11,15,20,.55), rgba(11,15,20,0)); border-bottom-left-radius:22px; border-bottom-right-radius:22px; }
.mlx-badge{
  display:inline-block; margin:0 auto 8px; padding:6px 10px; font-size:12px; line-height:1.1;
  color:#f4f8fe; background:rgba(255,255,255,.08); border:1px solid rgba(255,255,255,.14);
  border-radius:9999px; box-shadow: inset 0 1px 0 rgba(255,255,255,.06), 0 2px 6px rgba(0,0,0,.16); text-align:center;
}
.mlx-card .mlx-badge{ margin-left:auto; margin-right:auto; }
.mlx-scroll{ overflow-y:auto; overscroll-behavior:contain; -webkit-overflow-scrolling:touch; padding-right:2px;
  padding-bottom: calc(12px + var(--mlx-safe-bottom)); scrollbar-width:none; -ms-overflow-style:none; touch-action: pan-y; }
.mlx-scroll::-webkit-scrollbar{ width:0; height:0 }
.mlx-card .qa{ margin:10px 0 14px; border:1px solid rgba(255,255,255,.10); border-radius:14px; background:rgba(255,255,255,.03); overflow:hidden; }
.mlx-card .qa summary{ list-style:none; cursor:pointer; padding:14px 16px; font-weight:700; color:#f4f8fe;
  display:flex; align-items:center; justify-content:space-between; user-select:none; }
.mlx-card .qa summary::-webkit-details-marker{ display:none; }
.mlx-card .qa .qa-title{ display:flex; gap:10px; align-items:center }
.mlx-card .qa .chev{ transition:transform .2s ease; display:inline-block; font-size:18px; opacity:.85 }
.mlx-card .qa[open] .chev{ transform:rotate(180deg) }
.mlx-card .qa .qa-body{ padding:0 16px 14px 16px; animation:mlx-open .25s ease }
.mlx-card .qa .qa-body ul{ margin:6px 0 6px 16px }
.mlx-card .qa .qa-body li{ margin:4px 0 }
.mlx-card a{ color:#f19201; text-decoration:none } .mlx-card a:hover{ text-decoration:underline }
@keyframes mlx-open{ from{opacity:0; transform:translateY(-3px)} to{opacity:1; transform:none} }
@media (max-width:480px){ .mlx-card{ width:calc(100% - 24px); padding:14px; border-radius:16px; } }
.step-fig{ display:flex; justify-content:center; margin:12px 0 4px; }
.step-fig svg{ width:100%; max-width:720px; height:auto; }
.hint{ font-size:12px; opacity:.9 }
.warn{ color:#ffd277 }
CSS;

/* === Rendu du contenu principal (.mlx-wrap) === */
ob_start();
?>
<?php if ($isPartial): ?>
  <style id="crypto-inline-style"><?= $CRYPTO_INLINE_CSS ?></style>
<?php endif; ?>

<div class="mlx-wrap mlx-wrap-grid">
  <div class="tiles">
    <a class="tile hero" href="product.php?categorie=all">
      <span class="pic"><img src="assets/img/loader_fresh.webp" alt="MeltLabz"></span>
    </a>
  </div>

  <section class="mlx-card">
    <div class="mlx-badge">
      <?= t('crypto.badge.title', "Guide débutant d'achat de <strong>BTC</strong>") ?>
    </div>

    <div class="mlx-scroll">

      <details class="qa" open>
  <summary><span class="qa-title"><?= t('crypto.btcd.warn.title') ?></span><span class="chev">▾</span></summary>
  <div class="qa-body">
    <ul>
      <li><?= t('crypto.btcd.warn.i1') ?></li>
      <li><?= t('crypto.btcd.warn.i2') ?></li>
      <li><?= t('crypto.btcd.warn.i3') ?></li>
    </ul>
    <p class="hint"><?= t('crypto.btcd.warn.hint') ?></p>
    <p style="margin-top:8px">
      <a class="mlx-mini-badge"
         href="info.php<?= isset($_GET['lang']) ? '?lang='.urlencode($_GET['lang']) : '' ?>">
        <?= t('crypto.btcd.warn.cta') ?>
      </a>
    </p>
  </div>
</details>


      <!-- 1) Intro & prérequis -->
      <details class="qa">
        <summary><span class="qa-title">👶 <?= t('crypto.prereq.title','Pré-requis & sécurité') ?></span><span class="chev">▾</span></summary>
        <div class="qa-body">
          <ul>
            <li><?= t('crypto.prereq.i1', "<strong>Vérification d'identité (KYC)</strong> : demandée par de nombreux services (Revolut, certains exchanges). D’autres plateformes offrent des limites sans KYC complet.") ?></li>
            <li><?= t('crypto.prereq.i2', "<strong>Adresse & réseau</strong> : pour nos paiements, privilégie <strong>BTC (Bitcoin mainnet)</strong>. L’<strong>USDT</strong> est accepté <em>uniquement via le support</em> (réseau communiqué par l’équipe).") ?></li>
          </ul>
          <div class="step-fig">
            <!-- Schéma 1 -->
            <svg viewBox="0 0 760 160" xmlns="http://www.w3.org/2000/svg" aria-label="<?= t('crypto.svg.flow.aria','Flux général') ?>">
              <rect x="12" y="28" rx="12" ry="12" width="180" height="110" fill="rgba(255,255,255,0.08)" stroke="rgba(255,255,255,0.2)"/>
              <text x="102" y="80" fill="#e9f0f6" font-size="16" text-anchor="middle"><?= t('crypto.svg.flow.card_wire','Carte / Virement') ?></text>
              <path d="M192 83 L292 83" stroke="#e9f0f6" stroke-width="2.5" marker-end="url(#m1)"/>
              <rect x="292" y="28" rx="12" ry="12" width="180" height="110" fill="rgba(255,255,255,0.08)" stroke="rgba(255,255,255,0.2)"/>
              <text x="382" y="74" fill="#e9f0f6" font-size="16" text-anchor="middle"><?= t('crypto.svg.flow.buy_app','App d’achat') ?></text>
              <text x="382" y="96" fill="#9ddaff" font-size="15" text-anchor="middle"><?= t('crypto.svg.flow.buy_app_note','(Revolut / Exchange / P2P)') ?></text>
              <path d="M472 83 L572 83" stroke="#e9f0f6" stroke-width="2.5" marker-end="url(#m1)"/>
              <rect x="572" y="28" rx="12" ry="12" width="176" height="110" fill="rgba(255,255,255,0.08)" stroke="rgba(255,255,255,0.2)"/>
              <text x="660" y="72" fill="#e9f0f6" font-size="16" text-anchor="middle"><?= t('crypto.svg.flow.send_btc','Envoi BTC') ?></text>
              <text x="660" y="96" fill="#9ddaff" font-size="15" text-anchor="middle"><?= t('crypto.svg.flow.to_addr','vers l’adresse fournie') ?></text>
              <defs>
                <marker id="m1" markerWidth="12" markerHeight="12" refX="6" refY="6" orient="auto">
                  <path d="M0,0 L12,6 L0,12 z" fill="#e9f0f6"/>
                </marker>
              </defs>
            </svg>
          </div>
          <p class="hint"><?= t('crypto.prereq.hint','Astuce : commence par un <strong>petit test</strong> (ex : 5–10€) pour valider l’adresse BTC, puis envoie le solde.') ?></p>
        </div>
      </details>

      <!-- 2) Revolut -->
      <details class="qa">
        <summary><span class="qa-title">💳 <?= t('crypto.revolut.title','Revolut') ?></span><span class="chev">▾</span></summary>
        <div class="qa-body">
          <ol>
            <li><?= t('crypto.revolut.step1','<strong>Créer & vérifier</strong> ton compte Revolut, puis <strong>approvisionner</strong> (CB ou virement/IBAN).') ?></li>
            <li><?= t('crypto.revolut.step2','Dans l’app, ouvre <strong>Crypto</strong> → choisis <strong>BTC</strong> → <strong>Acheter</strong>.') ?></li>
            <li><?= t('crypto.revolut.step3','Pour <strong>envoyer du BTC</strong> : <em>Crypto</em> → <em>Envoyer</em> → colle l’<strong>adresse BTC</strong> fournie → confirme.') ?></li>
          </ol>
          <div class="step-fig">
            <!-- Schéma 2 -->
            <svg viewBox="0 0 760 170" xmlns="http://www.w3.org/2000/svg" aria-label="<?= t('crypto.svg.revolut.aria','Étapes Revolut') ?>">
              <rect x="10" y="36" rx="12" ry="12" width="220" height="100" fill="rgba(255,255,255,0.08)" stroke="rgba(255,255,255,0.2)"/>
              <text x="120" y="80" fill="#e9f0f6" font-size="16" text-anchor="middle"><?= t('crypto.svg.revolut.s1','1) Approvisionne') ?></text>
              <text x="120" y="102" fill="#9ddaff" font-size="15" text-anchor="middle"><?= t('crypto.svg.revolut.s1_note','CB / Virement') ?></text>
              <path d="M230 86 L330 86" stroke="#e9f0f6" stroke-width="2.5" marker-end="url(#m2)"/>
              <rect x="330" y="36" rx="12" ry="12" width="220" height="100" fill="rgba(255,255,255,0.08)" stroke="rgba(255,255,255,0.2)"/>
              <text x="440" y="78" fill="#e9f0f6" font-size="16" text-anchor="middle"><?= t('crypto.svg.revolut.s2','2) Acheter BTC') ?></text>
              <text x="440" y="100" fill="#9ddaff" font-size="15" text-anchor="middle"><?= t('crypto.svg.revolut.s2_note','Crypto → BTC') ?></text>
              <path d="M550 86 L650 86" stroke="#e9f0f6" stroke-width="2.5" marker-end="url(#m2)"/>
              <rect x="650" y="36" rx="12" ry="12" width="100" height="100" fill="rgba(255,255,255,0.08)" stroke="rgba(255,255,255,0.2)"/>
              <text x="700" y="80" fill="#e9f0f6" font-size="16" text-anchor="middle"><?= t('crypto.svg.revolut.s3','3) Send') ?></text>
              <text x="700" y="102" fill="#9ddaff" font-size="15" text-anchor="middle"><?= t('crypto.svg.revolut.s3_note','Adresse BTC') ?></text>
              <defs>
                <marker id="m2" markerWidth="12" markerHeight="12" refX="6" refY="6" orient="auto">
                  <path d="M0,0 L12,6 L0,12 z" fill="#e9f0f6"/>
                </marker>
              </defs>
            </svg>
          </div>
          <ul>
            <li><span class="warn"><?= t('crypto.revolut.warn_label','Important :') ?></span> <?= t('crypto.revolut.warn_send_availability',"la <strong>disponibilité d’envoi de BTC</strong> dépend de ta région/compte. Dans l’app : <em>Crypto → Send</em> pour vérifier.") ?></li>
            <li><?= t('crypto.revolut.check_address','Vérifie toujours l’<strong>adresse collée</strong> avant de confirmer.') ?></li>
          </ul>
        </div>
      </details>

      <!-- 3) Blofin -->
      <details class="qa">
        <summary><span class="qa-title">🟠 <?= t('crypto.blofin.title','Blofin') ?></span><span class="chev">▾</span></summary>
        <div class="qa-body">
          <p><?= t('crypto.blofin.p1', "<strong>Blofin</strong> est un exchange centralisé. L’inscription est rapide (e-mail), et des limites peuvent être disponibles <em>sans KYC complet</em>. Selon pays/méthode, une vérif peut être requise.") ?></p>
          <ol>
            <li><?= t('crypto.blofin.ol1','<strong>Créer un compte</strong> (e-mail/mot de passe) et activer la 2FA.') ?></li>
            <li><?= t('crypto.blofin.ol2','<strong>Approvisionner</strong> : carte/fiat via on-ramp (si dispo) ou dépôt depuis une autre app.') ?></li>
            <li><?= t('crypto.blofin.ol3','<strong>Acheter BTC</strong> via l’onglet d’achat.') ?></li>
            <li><?= t('crypto.blofin.ol4','<strong>Retirer en BTC</strong> : <em>Wallet</em> → <em>Withdraw</em> → BTC → colle l’adresse fournie → confirme.') ?></li>
          </ol>
        </div>
      </details>

      <!-- 4) LocalCoinSwap -->
      <details class="qa">
        <summary><span class="qa-title">🤝 <?= t('crypto.lcs.title','LocalCoinSwap [P2P : Cash, SEPA, PayPal, Wise…]') ?></span><span class="chev">▾</span></summary>
        <div class="qa-body">
          <p><?= t('crypto.lcs.p1','<strong>LocalCoinSwap</strong> est une place de marché <em>P2P</em> pour acheter du BTC auprès d’autres utilisateurs, avec énormément de moyens de paiement, dont <strong>espèces</strong> dans certaines villes.') ?></p>
          <ol>
            <li><?= t('crypto.lcs.ol1','<strong>Créer un compte</strong> et activer la 2FA.') ?></li>
            <li><?= t('crypto.lcs.ol2','<strong>Rechercher une offre</strong> : filtre <em>Bitcoin (BTC)</em>, sélectionne <em>ton pays/ville</em> et le <em>moyen de paiement</em> (Cash, SEPA, PayPal, Wise…).') ?></li>
            <li><?= t('crypto.lcs.ol3','<strong>Vérifier la réputation</strong> du vendeur (volume, avis, ancienneté).') ?></li>
            <li><?= t('crypto.lcs.ol4','<strong>Ouvrir l’échange (escrow)</strong> : suis les instructions. Pour le cash, privilégie un <em>endroit public</em> et viens accompagné si possible.') ?></li>
            <li><?= t('crypto.lcs.ol5','Une fois le paiement confirmé, tes <strong>BTC sont libérés</strong> dans ton wallet LocalCoinSwap.') ?></li>
            <li><?= t('crypto.lcs.ol6','<strong>Retirer</strong> vers l’adresse BTC fournie (on-chain).') ?></li>
          </ol>
          <p class="hint"><?= t('crypto.lcs.hint',"Comme pour tout P2P, reste prudent : communique dans le chat de la plateforme et n’envoie jamais d’argent en dehors de l’escrow.") ?></p>
        </div>
      </details>

      <!-- 5) Envoi & réseau -->
      <details class="qa">
        <summary><span class="qa-title">🔗 <?= t('crypto.sendnet.title','Envoi correct : adresse BTC & mémos') ?></span><span class="chev">▾</span></summary>
        <div class="qa-body">
          <ul>
            <li><?= t('crypto.sendnet.i1','<strong>BTC</strong> : envoie sur l’<strong>adresse Bitcoin</strong> fournie (format <code>bc1…</code> / <code>3…</code> / <code>1…</code>). Pas de choix de réseau côté BTC.') ?></li>
            <li><?= t('crypto.sendnet.i2','<strong>USDT</strong> : accepté via <strong>support</strong> uniquement (réseau communiqué par l’équipe).') ?></li>
            <li><?= t('crypto.sendnet.i3','<strong>Test</strong> : commence par un petit montant avant l’envoi final.') ?></li>
          </ul>
        </div>
      </details>

      <!-- 6) Dépannage -->
      <details class="qa">
        <summary><span class="qa-title">🛠️ <?= t('crypto.troubleshoot.title','Dépannage courant') ?></span><span class="chev">▾</span></summary>
        <div class="qa-body">
          <ul>
            <li><?= t('crypto.troubleshoot.i1','<strong>Adresse invalide</strong> : vérifie que c’est bien une <em>adresse BTC</em>.') ?></li>
            <li><?= t('crypto.troubleshoot.i2','<strong>Montant net insuffisant</strong> : prends en compte les frais de service + frais miniers.') ?></li>
            <li><?= t('crypto.troubleshoot.i3','<strong>P2P</strong> : utilise toujours l’escrow ; en cash, privilégie un lieu public.') ?></li>
          </ul>
        </div>
      </details>

      <!-- 7) Check-list -->
      <details class="qa">
        <summary><span class="qa-title">✅ <?= t('crypto.checklist.title','Check-list avant envoi') ?></span><span class="chev">▾</span></summary>
        <div class="qa-body">
          <ul>
            <li><?= t('crypto.checklist.i1','Adresse = <strong>BTC</strong> (exactement celle affichée).') ?></li>
            <li><?= t('crypto.checklist.i2','Petit <strong>test</strong> réalisé avec succès.') ?></li>
            <li><?= t('crypto.checklist.i3','Capture d’écran / <strong>preuve</strong> conservée (réf. de transaction).') ?></li>
          </ul>
        </div>
      </details>
    </div><!-- /.mlx-scroll -->
  </section>
</div><!-- /.mlx-wrap -->
<?php
$MAIN = ob_get_clean();

/* === Sortie === */
if ($isPartial) {
  // Fragment pour l’AJAX
  echo $MAIN;
  exit;
}
?>
<!DOCTYPE html>
<html lang="<?= $pageLangAttr ?>">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= t('crypto.page.title','MeltLabz — Tutoriel BTC (Débutant)') ?></title>

  <link rel="stylesheet" href="assets/css/main.css">
  <link rel="stylesheet" href="assets/css/category.css?v=<?= $cat_css_ver ?>">
  <link rel="stylesheet" href="assets/css/detail.css?v=<?= $det_css_ver ?>">

  <!-- Styles de la page -->
  <style id="crypto-inline-style"><?= $CRYPTO_INLINE_CSS ?></style>
</head>
<body>
<?php
$MLZ_PRELOAD_ASSETS = [
  'assets/css/main.css',
  'assets/js/script.js',
  'assets/img/honey-bg.webp',
];
include __DIR__ . '/mlz_loader_once.php';
?>

<?php include __DIR__ . '/header.php'; ?>

<?= $MAIN ?>

<?php include __DIR__ . '/bottom_menu.php'; ?>

<?php include __DIR__ . '/modal_cart.php'; ?>
<?php include __DIR__ . '/modal_verify.php'; ?>
<?php include __DIR__ . '/modal_address.php'; ?>
<?php include __DIR__ . '/modal_verify_result.php'; ?>
<?php include __DIR__ . '/modal_btc_deposit.php'; ?>

<!-- SDK + scripts globaux -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>
<script src="https://telegram.org/js/telegram-web-app.js"></script>
<script src="/i18n.js.php"></script>
<script src="assets/js/script.js?v=3"></script>
<script src="assets/js/tg_autologin_no_token.js"></script>
<script src="assets/js/category.js?v=<?= $cat_js_ver ?>"></script>
<script src="assets/js/detail.js?v=<?= $det_js_ver ?>"></script>

<!-- Mesure viewport & bottom menu -->
<script>
(function(){
  function setVh(){ var vh = window.innerHeight * 0.01; document.documentElement.style.setProperty('--vh', vh + 'px'); }
  function setBottomNavHeight(){
    var sel = '.bottom-menu, .bottom_nav, #bottom_menu, #bottomNav, .bottom-nav';
    var el = document.querySelector(sel); var h = 96;
    if (el){ var cs = getComputedStyle(el); var mt = parseFloat(cs.marginTop)||0, mb = parseFloat(cs.marginBottom)||0;
      var r = el.getBoundingClientRect(); h = Math.ceil(r.height + mt + mb); }
    document.documentElement.style.setProperty('--mlx-bottom-nav-h', h + 'px');
  }
  function tick(){ setVh(); setBottomNavHeight(); }
  window.addEventListener('resize', tick);
  window.addEventListener('orientationchange', tick);
  document.addEventListener('DOMContentLoaded', tick);
  setTimeout(tick, 300); setTimeout(tick, 800); setTimeout(tick, 1400);
})();
</script>
</body>
</html>
