<?php
// category_list.php — Clean DOM-only (aucun fetch/PJAX ici)
// La navigation AJAX est laissée à ton routeur qui intercepte a.js-route

try {
  $isAjax = isset($_GET['ajax']) || (strtolower($_SERVER['HTTP_X_REQUESTED_WITH'] ?? '') === 'xmlhttprequest');
  ob_start();
  require_once __DIR__.'/includes/db.php';
  require_once __DIR__.'/includes/tg_boot_soft.php';
  require_once __DIR__.'/includes/lang.php';

  $categorie = isset($_GET['categorie']) ? strtolower(trim($_GET['categorie'])) : '';
  $valid = ['piatella','wpff','iceolator','lamousse','all'];
  if (!in_array($categorie, $valid, true)) {
    http_response_code(400); header('Content-Type: text/html; charset=utf-8');
    echo '<div class="container mt-4"><div class="alert alert-warning">Catégorie invalide.</div></div>'; exit;
  }

  $baseSql = "SELECT id, nom, image, categorie, farm, description FROM produits";
  if ($categorie === 'all') {
    $stmt = $pdo->prepare("$baseSql ORDER BY id DESC");
    $stmt->execute();
  } else {
    $stmt = $pdo->prepare("$baseSql WHERE LOWER(categorie)=:c ORDER BY id DESC");
    $stmt->execute(['c'=>$categorie]);
  }
  $catalogue = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Prix par produit (stockés en EUR "brut")
$pricesByProduct = [];
if (!empty($catalogue)) {
  $ids = array_column($catalogue, 'id');
  $in  = implode(',', array_fill(0, count($ids), '?'));
  $st  = $pdo->prepare("SELECT produit_id, quantite, prix FROM produit_prix WHERE produit_id IN ($in) ORDER BY quantite ASC");
  $st->execute($ids);
  foreach ($st->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $pid = (int)$row['produit_id'];
    // Quantité "propre"
    $qRaw = $row['quantite'];
    if (is_numeric($qRaw) && floor((float)$qRaw) == (float)$qRaw) {
      $q = (string)(int)$qRaw;
    } else {
      $q = rtrim(rtrim(number_format((float)$qRaw, 3, '.', ''), '0'), '.');
    }
    // IMPORTANT: on garde le prix EUR en float (AUCUN formatage ici)
    $price_eur = (float)$row['prix'];

    $pricesByProduct[$pid][] = [
      'q'         => $q,
      'price_eur' => $price_eur
    ];
  }
}


  // Image src / fallback encodé (espaces, virgules…)
  function mlz_img_variants($path){
    $path = (string)$path;
    if ($path === '') return ['',''];
    if (preg_match('~^https?://~i', $path)) return [$path, $path];
    $path = ltrim($path, '/');
    $segments = explode('/', $path);
    foreach ($segments as &$seg) {
      $seg = preg_replace_callback('/[^\x20-\x7E]|\s/u', function($m){
        return $m[0] === ' ' ? '%20' : rawurlencode($m[0]);
      }, $seg);
    }
    unset($seg);
    $root = '/'.implode('/', $segments);
    $with_plain_comma   = str_replace('%2C', ',', $root);
    $with_encoded_comma = str_replace(',', '%2C', $root);
    return [$with_plain_comma, $with_encoded_comma];
  }

  header('Content-Type: text/html; charset=utf-8');
?>
<?php $cat_ver = @filemtime(__DIR__.'/assets/css/category.css') ?: time(); ?>
<link rel="stylesheet" href="assets/css/category.css?v=<?= $cat_ver ?>">

<!-- Mini CSS overlay (utile si Bootstrap n'applique pas stretched-link) -->
<style>
  .position-relative { position: relative; }
  .stretched-link { position: absolute; inset: 0; z-index: 10; text-indent: -9999px; overflow: hidden; }
  .product-card .stretched-link { cursor: pointer; }
.mlz-filterbar { position: relative; z-index: 50; }
.mlz-dd-menu[data-dd="currency"] { position: absolute; z-index: 2000; }

</style>

<div class="mlz-apple">
  <?php
    $__cat   = strtolower($_GET['categorie'] ?? '');
    $__sort  = $_GET['sort'] ?? '';
    $__farm  = trim((string)($_GET['farm'] ?? ''));

    // Farms présentes sur la page
    $__farms = [];
    foreach (($catalogue ?? []) as $__row) {
      $f = trim((string)($__row['farm'] ?? $__row['farm_name'] ?? $__row['farmsname'] ?? $__row['farms_name'] ?? ''));
      if ($f !== '') { $__farms[$f] = ($__farms[$f] ?? 0) + 1; }
    }
    ksort($__farms, SORT_NATURAL | SORT_FLAG_CASE);
  ?>
  <div class="mlz-filterbar">
    <!-- TRIÉ PAR PRIX (tri DOM-only assuré par tes scripts globaux) -->
    <div class="mlz-dd" data-dd="sort" tabindex="0">
      <button class="mlz-dd-btn" type="button" data-dd="sort" tabindex="0">
        <?= $__sort==='price_desc' ? 'TRIÉ PAR : PRIX (↑)' : ($__sort==='price_asc' ? 'TRIÉ PAR : PRIX (↓)' : 'TRIÉ PAR : PRIX') ?>
      </button>
      <div class="mlz-dd-menu" data-dd="sort" tabindex="0">
        <a href="#" data-sort="price-asc"  class="<?= ($__sort==='price_asc')  ? 'is-active':'' ?>">Du – cher au + cher</a>
        <a href="#" data-sort="price-desc" class="<?= ($__sort==='price_desc') ? 'is-active':'' ?>">Du + cher au – cher</a>
        <a href="#" data-sort="default"    class="<?= ($__sort==='') ? 'is-active':'' ?>">Par défaut</a>
      </div>
    </div>

 <!-- AU MILIEU : DEVISE -->
<!-- ====== CURRENCY DROPDOWN (i18n + live label, côté client) ====== -->
<?php require_once __DIR__.'/includes/currency.php'; ?>
<script>
  // Boot devises (inchangé)
  window.MLZ_CURRENCY_BOOT = <?= mlz_currency_boot_json(); ?>;
  window.MLZ_SET_CURRENCY_URL = "/api/set_currency.php";
  window.MLZ_CURRENCIES = <?= json_encode($GLOBALS['MLZ_CURRENCIES'], JSON_UNESCAPED_UNICODE) ?>;
</script>

<?php
  // On rend un label neutre côté PHP (évite de “figer” en FR si la page est en EN/ES)
  $cur   = mlz_current_currency();
  $label = ($cur === 'EUR' ? 'Euro (€)' : ($cur === 'USD' ? 'Dollar ($)' : 'THB (฿)'));
?>
<div class="mlz-dd" data-dd="currency" tabindex="0">
  <button class="mlz-dd-btn" type="button" data-dd="currency" tabindex="0"
          data-i18n-currency-btn="">
    <!-- Le JS mettra "CURRENCY / MONEDA / DEVISE : <Nom>" -->
    <?= htmlspecialchars($label) ?>
  </button>
  <div class="mlz-dd-menu" data-dd="currency" tabindex="0">
    <a href="#" data-currency="EUR" class="<?= ($cur==='EUR'?'is-active':'') ?>">Euro (€)</a>
    <a href="#" data-currency="USD" class="<?= ($cur==='USD'?'is-active':'') ?>">Dollar ($)</a>
    <a href="#" data-currency="THB" class="<?= ($cur==='THB'?'is-active':'') ?>">THB (฿)</a>
  </div>
</div>

<script>
/* -------- Label “CURRENCY/MONEDA/DEVISE : …” 100% piloté par le dico JS -------- */
(function(){
  function getCookie(name){
    const m = document.cookie.match(new RegExp('(?:^|;\\s*)'+name.replace(/[.*+?^${}()|[\]\\]/g,'\\$&')+'=([^;]*)'));
    return m ? decodeURIComponent(m[1]) : '';
  }
  function detectLang(){
    try { const k = (window.I18N && (window.I18N.__lang || window.I18N.lang)); if (k) return String(k).slice(0,2).toLowerCase(); } catch(_){}
    const url = new URLSearchParams(location.search).get('lang') || '';
    const cookie = getCookie('lang') || '';
    const html = document.documentElement.getAttribute('lang') || '';
    const nav = (navigator.language || '').slice(0,2);
    return (url || cookie || html || nav || 'fr').slice(0,2).toLowerCase();
  }
  function currencyPrefix(){
    try { if (window.I18N && window.I18N['currency.button']) return String(window.I18N['currency.button']); } catch(_){}
    const m = { en:'CURRENCY', es:'MONEDA', fr:'DEVISE' };
    return m[detectLang()] || 'CURRENCY';
  }
  function currencyName(code){
    const map = { EUR:'Euro (€)', USD:'Dollar ($)', THB:'THB (฿)' };
    return map[code] || code;
  }
  function refreshCurrencyButton(){
    const btn = document.querySelector('.mlz-dd-btn[data-dd="currency"]');
    if (!btn) return;
    const code = (window.MLZ_CURRENCY_BOOT && window.MLZ_CURRENCY_BOOT.code) || 'EUR';
    const prefix = currencyPrefix();
    btn.setAttribute('data-i18n-currency-btn', prefix);
    btn.textContent = prefix + ' : ' + currencyName(code);
  }

  // 1) Initial
  if (document.readyState === 'loading') document.addEventListener('DOMContentLoaded', refreshCurrencyButton);
  else refreshCurrencyButton();

  // 2) Quand la devise change (depuis ton module de devise)
  document.addEventListener('mlz:currency-changed', function(){ setTimeout(refreshCurrencyButton, 0); });

  // 3) Si ton dico I18N se charge après coup
  document.addEventListener('mlz:i18n-ready', refreshCurrencyButton);

  // 4) Re-injection PJAX
  document.addEventListener('mlz:tiles-ready', refreshCurrencyButton);

  // 5) Sécurité : si aucun event n’est émis par le switch, on force après clic menu
  document.addEventListener('click', function(e){
    const a = e.target.closest('.mlz-dd-menu [data-currency]');
    if (!a) return;
    setTimeout(refreshCurrencyButton, 0);
  }, true);
})();
</script>


    <!-- FARMS (promote/filter DOM-only par tes scripts) -->
    <div class="mlz-dd" data-dd="farm" tabindex="0">
      <button class="mlz-dd-btn" type="button" data-dd="farm" tabindex="0">
        <?= $__farm!=='' ? 'FARMS : '.htmlspecialchars($__farm) : 'FARMS' ?>
      </button>
      <div class="mlz-dd-menu">
        <a href="#" data-farm="all" class="<?= ($__farm==='')?'is-active':'' ?>">Toutes les farms</a>
        <?php foreach ($__farms as $name=>$count): ?>
          <a href="#" data-farm="<?= htmlspecialchars($name) ?>" class="<?= (strcasecmp($__farm,$name)===0)?'is-active':'' ?>">
            <?= htmlspecialchars($name) ?> <span class="count">(<?= (int)$count ?>)</span>
          </a>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
  <div class="mlz-products">
    <div class="mlz-scroll"
      onscroll="(function(el){var atTop=el.scrollTop<=6;el.classList.toggle('fade-top',!atTop);el.classList.remove('fade-bottom');})(this)"
      onwheel="(function(el){var atTop=el.scrollTop<=6;el.classList.toggle('fade-top',!atTop);el.classList.remove('fade-bottom');})(this)"
      ontouchmove="(function(el){var atTop=el.scrollTop<=6;el.classList.toggle('fade-top',!atTop);el.classList.remove('fade-bottom');})(this)"
      onmouseenter="(function(el){var atTop=el.scrollTop<=6;el.classList.toggle('fade-top',!atTop);el.classList.remove('fade-bottom');})(this)">

      <div class="mlz-wrap" id="category-list" data-categorie="<?= htmlspecialchars($categorie, ENT_QUOTES, 'UTF-8') ?>">
        <div class="row">
          <?php if (empty($catalogue)): ?>
            <div class="col-12">
              <div class="product-card is-empty">
                <div class="product-image">
                  <div class="mlz-empty-illu"><span class="mlz-empty-emoji">🧺</span></div>
                </div>
                <div class="product-content">
                  <div class="badges-row"><span class="badge-strain">😶 <?= t('category.empty','Catégorie vide') ?></span></div>
                  <div class="product-title"><strong><?= t('category.no_products_title', 'Aucun produit pour l’instant') ?></strong></div>
                  <p class="product-meta"><?= t('category.no_products_meta', 'Reviens plus tard ou découvre nos autres catégories.') ?></p>
                  <div class="prices-row"><a href="index.php" class="mlz-btn-ghost" data-go-home>← <?= t('category.back_home','Retour à l’accueil') ?></a></div>
                </div>
              </div>
            </div>
          <?php else: ?>
            <?php foreach ($catalogue as $p): $pid=(int)$p['id']; list($src1,$src2)=mlz_img_variants($p['image'] ?? ''); ?>
              <div class="col-12">
                <div class="product-card position-relative"
                     data-farm="<?= htmlspecialchars(strtolower(trim($p['farm'] ?? $p['farm_name'] ?? $p['farmsname'] ?? $p['farms_name'] ?? '')), ENT_QUOTES, 'UTF-8') ?>">

                  <div class="product-image">
                    <img src="<?= htmlspecialchars($src1) ?>" data-alt="<?= htmlspecialchars($src2) ?>"
                         alt="<?= htmlspecialchars($p['nom']) ?>" loading="lazy"
                         onerror="if(!this.dataset.swapped){this.dataset.swapped=1; this.src=this.dataset.alt;}">
                    <span class="badge-seller"><?= htmlspecialchars($p['farm'] ?? 'MeltLabz') ?></span>
                  </div>

                  <div class="product-content">
                    <div class="badges-row">
                      <?php $strain = $p['categorie'] ?? null; if ($strain): ?>
                        <span class="badge-strain">🌿 <?= htmlspecialchars($strain) ?></span>
                      <?php endif; ?>
                    </div>

                    <div class="product-title"><strong><?= htmlspecialchars($p['nom']) ?></strong></div>

                    <?php if (!empty($p['description'])): ?>
                      <p class="product-meta">
                        <?= nl2br(htmlspecialchars($p['description'], ENT_QUOTES, 'UTF-8')) ?>
                      </p>
                    <?php endif; ?>


                    <?php foreach ($pricesByProduct[$pid] as $pr): ?>
                      <div class="prices-row">
  <?php $price_eur = (float)$pr['price_eur']; ?>
  <span class="badge-price">
    <?= htmlspecialchars($pr['q']) ?>G |&nbsp;<span class="js-price"
          data-price-eur="<?= htmlspecialchars($price_eur, ENT_QUOTES) ?>">
       <?= mlz_format_price($price_eur) ?>
    </span>
  </span>
  </div>
<?php endforeach; ?>


                  <!-- Lien overlay pour le routeur (AJAX sans reload) -->
                  <a class="stretched-link js-route" href="detail_product.php?id=<?= (int)$p['id'] ?>"></a>
                </div>
              </div>
            <?php endforeach; ?>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>

<?php
} catch (Throwable $e) {
  http_response_code(500); header('Content-Type: text/html; charset=utf-8');
  echo '<div class="container mt-4"><div class="alert alert-danger">Erreur serveur: ' . htmlspecialchars($e->getMessage()) . '</div></div>';
}