<link href="https://emoji-css.afeld.me/emoji.css" rel="stylesheet">

<div class="dock-wrap">
  <div class="dock" id="dock">
    <a class="dock-item emoji" href="index.php" title="Accueil" aria-label="Accueil" id="dock-home">🏡</a>

    <button class="dock-item avatar" id="dock-avatar" title="Profil" aria-label="Profil">
      <img id="tg-avatar" alt="" style="display:none;">
      <span class="fallback">🧔‍</span>
    </button>
    
<style>
  /* taille + centrage du QR dans le carré */
  #dock-verify{
    display:grid; place-items:center; padding:0; background:#fff;
  }
  #dock-verify .dock-icon-qr{
    display:block; width:78%; height:78%;
    object-fit:contain; pointer-events:none; /* le clic reste sur le bouton */
  }
</style>

<button class="dock-item" id="dock-verify"
        title="<?= t('verify.title','Vérification du produit') ?>"
        aria-label="<?= t('verify.title','Vérification du produit') ?>">
  <img src="/assets/img/qr-MeltLabz-us.svg" alt="" class="dock-icon-qr">
</button>

<style>
  /* icône BTC centrée dans le carré, sans surcouche CSS */
  #dock-btc{ display:grid; place-items:center; padding:0; }
  #dock-btc::before{ content:none !important; display:none !important; } /* neutralise une éventuelle icône CSS */
  #dock-btc .dock-icon-btc{
    display:block; width:78%; height:78%;
    object-fit:contain; pointer-events:none; /* le clic reste sur le bouton */
  }
  @media (min-width:480px){
    #dock-btc .dock-icon-btc{ width:82%; height:82%; }
  }
</style>

<button class="dock-item" id="dock-btc"
        title="<?= t('btc.deposit','Dépôt BTC') ?>"
        aria-label="<?= t('btc.deposit','Dépôt BTC') ?>">
  <img src="/assets/img/bitcoin.svg" alt="" class="dock-icon-btc">
</button>



    <button class="dock-item emoji" id="dock-cart" title="Panier" aria-label="Panier">
      🛒
      <span class="badge" id="cart-badge"></span>
    </button>
  </div>
</div>

<!-- Desktop-only Telegram popup -->
<div class="glass-overlay" id="desktop-lock-modal" role="dialog" aria-modal="true" aria-labelledby="desktop-lock-title" style="display:none">
  <div class="glass-panel" style="max-width: 460px">
    <div class="panel-head">
      <div class="panel-title" id="desktop-lock-title">🔒 <?= t('desk.lock.title', 'Commande via Telegram uniquement') ?></div>
      <button class="panel-close" data-close="desktop-lock-modal" aria-label="<?= t('generic.close','Fermer') ?>">✕</button>
    </div>
    <div class="panel-body">
      <p id="desktop-lock-msg" style="line-height:1.4; color:#7b8793; white-space:pre-line;">
        <?= t('desk.lock.msg', "Cette action n’est disponible que via notre bot Telegram.\nOuvrez Telegram pour commander.") ?>
      </p>
      <a href="https://t.me/MeltLabz" target="_blank" rel="noopener noreferrer" class="btn btn-primary btn-xs" id="desktop-lock-cta">
        <?= t('desk.lock.cta', 'Ouvrir le groupe Telegram') ?>
      </a>
    </div>
    <div class="panel-foot">
      <button class="btn btn-amber btn-xs" data-close="desktop-lock-modal"><?= t('generic.ok','OK') ?></button>
    </div>
  </div>
</div>

<style>
  /* Telegram CTA – version compacte, scoped à cette modale uniquement */
  #desktop-lock-modal #desktop-lock-cta{
    display:inline-flex;               /* pas pleine largeur */
    align-items:center;
    gap:8px;
    font-size:13px !important;         /* taille texte réduite */
    line-height:1.1;
    padding:8px 12px !important;       /* moins de padding */
    border-radius:10px !important;     /* angles un peu moins “pill” */
    min-width:0;                       /* évite la largeur mini de certains thèmes */
    height:auto;
    box-shadow:0 4px 10px rgba(0,0,0,.15); /* plus léger */
  }

  /* Si ton thème force une taille XL pour tous .panel-body .btn,
     dégonfle tout dans CE popup uniquement : */
  #desktop-lock-modal .panel-body .btn{
    font-size:13px;
    padding:8px 12px;
  }
</style>
<style>
  /* Assure que la modale Telegram est toujours au-dessus */
  #desktop-lock-modal { z-index: 99999 !important; }
</style>

<script>
(function(){
  // IDs de modales à bloquer sur Desktop (ajoute/enlève selon ton projet)
  const BLOCKED_MODAL_IDS = ['cart-modal','btc-modal','profile-modal','avatar-modal','user-modal'];

  // Boutons/trigger à intercepter
  const TRIGGERS = [
    '#dock-cart',
    '#dock-btc',
    '#dock-avatar',
    '[data-open="cart-modal"]',  '[href="#cart-modal"]',
    '[data-open="btc-modal"]',   '[href="#btc-modal"]',
    '[data-open="profile-modal"]','[href="#profile-modal"]',
    '[data-open="avatar-modal"]','[href="#avatar-modal"]',
    '[data-open="user-modal"]',  '[href="#user-modal"]'
  ];

  function isDesktop(){
    try { return matchMedia('(pointer:fine)').matches && window.innerWidth >= 1024; }
    catch(_) { return (window.innerWidth || 1200) >= 1024; }
  }

  function openModal(id){
    const el=document.getElementById(id); if(!el) return;
    try{ if(window.openOverlay) return openOverlay(id); }catch(_){}
    el.style.display='block'; el.classList.add('open'); document.body.classList.add('no-scroll');
  }
  function closeModal(id){
    const el=document.getElementById(id); if(!el) return;
    try{ if(window.closeOverlay) return closeOverlay(id); }catch(_){}
    el.style.display='none'; el.classList.remove('open');
    // retire no-scroll si rien d’autre n’est ouvert
    const anyOpen = Array.from(document.querySelectorAll('.glass-overlay')).some(x=>{
      const s=getComputedStyle(x); return x.classList.contains('open') || s.display!=='none';
    });
    if (!anyOpen) document.body.classList.remove('no-scroll');
  }

  function hardCloseBlocked(){
    BLOCKED_MODAL_IDS.forEach(id=> closeModal(id));
  }

  function showTelegramLock(){
    if (!isDesktop()) return false;
    hardCloseBlocked();
    openModal('desktop-lock-modal');
    return true;
  }

  // 1) Clics → on intercepte en capture et on bloque toute propagation immédiatement
  window.addEventListener('click', function onClick(e){
    if (!isDesktop()) return;
    const t = e.target.closest && e.target.closest(TRIGGERS.join(','));
    if (!t) return;
    e.preventDefault();
    if (typeof e.stopImmediatePropagation === 'function') e.stopImmediatePropagation();
    e.stopPropagation();
    showTelegramLock();
  }, true);

  // 2) Monkey-patch des ouvertures programmatiques
  if (window.openOverlay && !window.__DESK_LOCK_PATCHED_2__){
    const _open = window.openOverlay;
    window.openOverlay = function(id){
      if (isDesktop() && id && BLOCKED_MODAL_IDS.includes(String(id))) {
        return showTelegramLock();
      }
      return _open.apply(this, arguments);
    };
    window.__DESK_LOCK_PATCHED_2__ = 1;
  }

  // Patch aussi les helpers éventuels que tu utilises
  ['MLZ_openCartModal','MLZ_openBtcModal','MLZ_openProfileModal','MLZ_openAvatarModal','MLZ_openUserModal']
    .forEach(name=>{
      if (typeof window[name] === 'function'){
        const orig = window[name];
        window[name] = function(){
          if (isDesktop()) return showTelegramLock();
          return orig.apply(this, arguments);
        };
      }
    });

  // 3) Garde-fou : si une modale bloquée devient visible, on referme et on montre Telegram
  const observer = new MutationObserver(() => {
    if (!isDesktop()) return;
    for (const id of BLOCKED_MODAL_IDS){
      const el = document.getElementById(id);
      if (!el) continue;
      const s = getComputedStyle(el);
      const visible = el.classList.contains('open') || s.display!=='none';
      if (visible){
        showTelegramLock();
        break;
      }
    }
  });
  observer.observe(document.documentElement, {subtree:true, attributes:true, attributeFilter:['class','style']});

  // 4) Fermer le popup Telegram
  document.addEventListener('click', function(e){
    const c = e.target.closest && e.target.closest('[data-close="desktop-lock-modal"]');
    if (c){ e.preventDefault(); closeModal('desktop-lock-modal'); }
  }, true);
})();
</script>