<?php
// /ban_gate.js.php — renvoie du JS.
// Si banni => alert + redirect, sinon un no-op.
header('Content-Type: application/javascript; charset=utf-8');
@session_start();

require_once __DIR__.'/includes/db.php';
if (file_exists(__DIR__.'/includes/tg_boot_soft.php')) {
  require_once __DIR__.'/includes/tg_boot_soft.php';
}

// 1) Récup ID (PRIORITÉ au paramètre GET !)
function cur_tg_id(): ?string {
  if (!empty($_GET['tg_id']))                             return preg_replace('/\D/', '', (string)$_GET['tg_id']);
  if (!empty($_COOKIE['tg_id']))                          return preg_replace('/\D/', '', (string)$_COOKIE['tg_id']);
  if (!empty($GLOBALS['tg']['id']))                       return preg_replace('/\D/', '', (string)$GLOBALS['tg']['id']);
  if (!empty($GLOBALS['tg_user']['telegram_id']))         return preg_replace('/\D/', '', (string)$GLOBALS['tg_user']['telegram_id']);
  if (!empty($_SESSION['telegram_user']['id']))           return preg_replace('/\D/', '', (string)$_SESSION['telegram_user']['id']);
  if (!empty($_SESSION['tg_user']['id']))                 return preg_replace('/\D/', '', (string)$_SESSION['tg_user']['id']);
  if (!empty($_SESSION['telegram_id']))                   return preg_replace('/\D/', '', (string)$_SESSION['telegram_id']);
  return null;
}

// 2) Test BDD (supporte $pdo ou $db (PDO/mysqli))
function db_is_banned(string $tgId): bool {
  if (isset($GLOBALS['pdo']) && $GLOBALS['pdo'] instanceof PDO) {
    $st = $GLOBALS['pdo']->prepare('SELECT is_banned FROM telegram_users WHERE telegram_id = ? LIMIT 1');
    $st->execute([$tgId]);
    $row = $st->fetch(PDO::FETCH_ASSOC);
    return $row && (int)$row['is_banned'] === 1;
  }
  if (isset($GLOBALS['db']) && $GLOBALS['db'] instanceof mysqli) {
    $st = $GLOBALS['db']->prepare('SELECT is_banned FROM telegram_users WHERE telegram_id = ? LIMIT 1');
    $st->bind_param('s', $tgId);
    $st->execute();
    $res = $st->get_result();
    $row = $res ? $res->fetch_assoc() : null;
    return $row && (int)$row['is_banned'] === 1;
  }
  if (isset($GLOBALS['db']) && $GLOBALS['db'] instanceof PDO) {
    $st = $GLOBALS['db']->prepare('SELECT is_banned FROM telegram_users WHERE telegram_id = ? LIMIT 1');
    $st->execute([$tgId]);
    $row = $st->fetch(PDO::FETCH_ASSOC);
    return $row && (int)$row['is_banned'] === 1;
  }
  return false;
}

$tgId = cur_tg_id();
$isBanned = $tgId ? db_is_banned($tgId) : false;

if ($isBanned) {
  echo "alert('".addslashes("Vous êtes bannis de nos services 🖕")."');";
  echo "window.location.replace('https://www.xvideos.com');";
  exit;
}
echo "/* ban ok */";
