// assets/js/tg_autologin_no_token.js
// Auto-login sans token : poste l'utilisateur Telegram au serveur dès dispo.

(function(){
  const tg = window.Telegram?.WebApp;

  function ready(){ try { tg?.ready(); } catch(_) {} }
  function user(){ return tg?.initDataUnsafe?.user || null; }

  async function deposit(){
    const u = user();
    if (!u) return false;
    try{
      const res = await fetch('tg_session_simple.php', {
        method: 'POST',
        credentials: 'include',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ user: u })
      });
      const js = await res.json().catch(()=>({}));
      if (js && js.ok) {
        window.__MLZ_TID = js.telegram_id;
        document.dispatchEvent(new CustomEvent('mlz:telegramReady', { detail: js }));
        return true;
      }
    }catch(_){}
    return false;
  }

  async function boot(){
    ready();
    const start = Date.now();
    const deadline = 15000; // 15s max
    let ok = false;

    // essais rapides
    for (let i=0;i<6 && !ok;i++){
      if (user()) ok = await deposit();
      if (!ok) await new Promise(r=>setTimeout(r, 150));
    }
    if (ok) return;

    // polling doux
    while(!ok && (Date.now()-start) < deadline){
      if (user()) ok = await deposit();
      if (!ok) await new Promise(r=>setTimeout(r, 400));
    }

    // réessaye quand l'app redevient visible
    if (!ok) document.addEventListener('visibilitychange', async () => {
      if (!document.hidden && !window.__MLZ_TID) await deposit();
    }, { once:true });
  }

  if (document.readyState === 'complete' || document.readyState === 'interactive') boot();
  else document.addEventListener('DOMContentLoaded', boot, { once:true });
})();
