(function(){
  // Minimal, safe I18N loader (no overrides, no awaits in your code)
  function T(key, fallback){
    try { return (window.I18N && window.I18N[key]) || fallback || key; }
    catch(_) { return fallback || key; }
  }
  window.T = window.T || T;

  let _promise;
  async function ensureI18N(){
    if (window.I18N) return window.I18N;
    if (!_promise){
      _promise = (async () => {
        try{
          const res = await fetch('/i18n.json.php', {
            credentials: 'include',
            headers: { 'Accept': 'application/json' }
          });
          window.I18N = await res.json();
        }catch(e){ /* keep fallbacks */ }
        return window.I18N || {};
      })();
    }
    return _promise;
  }
  window.ensureI18N = window.ensureI18N || ensureI18N;

  // Preload ASAP
  ensureI18N();
})();