
// detail.js — vertical page behaviour, idempotent + AJAX-compatible
(function(){

// ---- I18N helper (reads PHP-exposed window.I18N) ----
function T(key, fallback){ try { return (window.I18N && window.I18N[key]) || fallback || key; } catch(_){ return fallback || key; } }

  function $(q,ctx=document){ return ctx.querySelector(q); }
  function on(el, ev, fn, opts){ if(!el) return; el.addEventListener(ev, fn, opts||false); }

  function showToast(msg, type){
    var t = $('#mlz-toast');
    if(!t) return;
    t.textContent = msg||'';
    t.className = 'mlz-toast ' + (type==='error'?'error':(type==='success'?'success':'')) + ' show';
    clearTimeout(showToast._t);
    showToast._t = setTimeout(function(){ t.classList.remove('show'); }, 2600);
  }

  function initDetailPage(root){
    root = root || document;
    var scope = root.querySelector('.mlz-apple.mlz-detail') || root.querySelector('.mlz-apple') || root;
    if (scope.__mlzDetailInit) return;
    scope.__mlzDetailInit = true;

    var priceRow = scope.querySelector('.prices-row');
    var btn = scope.querySelector('#mlz-add-btn');

    // (1) Sélection de quantité via délégation
    on(priceRow, 'click', function(e){
      var pill = e.target.closest('.badge-price.js-qty');
      if(!pill || !priceRow.contains(pill)) return;
      priceRow.querySelectorAll('.badge-price.js-qty.is-selected').forEach(function(n){ n.classList.remove('is-selected'); });
      pill.classList.add('is-selected');
      if(btn) btn.disabled = false;
    });

    // (2) Ajout au panier – conserve ton API globale
    on(btn, 'click', async function(){
      try{
        var sel = scope.querySelector('.badge-price.js-qty.is-selected');
        if(!sel){ btn.disabled = true; return; }
        var pid = parseInt(sel.getAttribute('data-pid'),10);
        var qty = sel.getAttribute('data-qty');
        if(!pid || !qty) throw new Error(T('detail.invalid_sel','Sélection invalide'));
        btn.disabled = true;

        if (typeof window.addToCart !== 'function') throw new Error(T('api.error','Erreur API'));
        const res = await window.addToCart(pid, qty);

        try{ if (typeof window.loadCart === 'function') await window.loadCart(); }catch(e){}
        try{ if (typeof window.updateCartBadge === 'function') window.updateCartBadge(); }catch(e){}
        try{ if (typeof window.openCartModal === 'function') window.openCartModal(); }catch(e){}
        showToast(T('detail.added','Ajouté au panier ✅'), 'success');
        btn.disabled = false;
      }catch(err){
        console.error('add-to-cart', err);
        showToast(err && err.message || T('order.error','Une erreur est survenue pendant l’envoi. Merci de réessayer.'),'error');
        btn.disabled = false;
      }
    });

    if(btn) btn.disabled = !scope.querySelector('.badge-price.js-qty.is-selected');
  }

  // Expose + auto-run (pour AJAX)
  window.initDetailPage = function(){ initDetailPage(document); };
  if (document.readyState === 'loading'){
    document.addEventListener('DOMContentLoaded', window.initDetailPage);
  } else {
    window.initDetailPage();
  }
})();

(function(){
  function createLightbox(){
    const lb = document.createElement("div");
    lb.className = "mlz-lightbox";
    lb.innerHTML = "<img src='' alt='zoom'>";
    document.body.appendChild(lb);
    lb.addEventListener("click", ()=> lb.classList.remove("show"));
    return lb;
  }

  const lightbox = createLightbox();
  const lbImg = lightbox.querySelector("img");

  // Active le zoom sur toutes les images produit
  document.addEventListener("click", function(e){
    const img = e.target.closest(".product-image img");
    if(!img) return;
    e.preventDefault();
    lbImg.src = img.src;
    lightbox.classList.add("show");
  });
})();
