/* detail-init-hook.js — recalls your initDetailPage() after AJAX swaps */
(function(){
  // When the app signals content is ready
  document.addEventListener('mlz:tiles-ready', function(){
    if (typeof window.initDetailPage === 'function') window.initDetailPage();
  });

  // Fallback: observe DOM swaps if no event is fired
  const mo = new MutationObserver(() => {
    const hint = document.querySelector('.mlz-apple.mlz-detail, #mlz-add-btn, .badge-price.js-qty');
    if (hint && typeof window.initDetailPage === 'function') window.initDetailPage();
  });
  mo.observe(document.body, { childList: true, subtree: true });
})();