<?php
declare(strict_types=1);
require __DIR__.'/config.php'; require_auth();
// Simple BTC→EUR rate via CoinGecko; cache 60s
$cache = __DIR__ . '/.rates_cache.json';
$now = time();
if (file_exists($cache)) {
  $data = json_decode(file_get_contents($cache), true);
  if ($data && ($now - ($data['ts'] ?? 0)) < 60) {
    echo json_encode(['ok'=>true,'btc_eur'=>$data['btc_eur'],'source'=>'cache']); exit;
  }
}
$url = 'https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=eur';
$ch = curl_init($url);
curl_setopt_array($ch, [
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_TIMEOUT => 10,
  CURLOPT_USERAGENT => 'MeltLabzRates/1.0'
]);
$body = curl_exec($ch);
$err = curl_error($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);
if ($err || $code !== 200) {
  http_response_code(502);
  echo json_encode(['ok'=>false,'error'=>'rate_fetch_failed','detail'=>$err,'code'=>$code]); exit;
}
$j = json_decode($body, true);
$eur = (float)($j['bitcoin']['eur'] ?? 0);
file_put_contents($cache, json_encode(['ts'=>$now,'btc_eur'=>$eur]));
echo json_encode(['ok'=>true,'btc_eur'=>$eur,'source'=>'coingecko']);
