<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

require __DIR__ . '/config.php';   // contient pdo(), require_auth_melt(), etc.

// --- inputs ---
$telegram_id = (int)($_GET['telegram_id'] ?? 0);
if (!$telegram_id) {
  echo json_encode(['ok'=>false,'error'=>'missing telegram_id']); exit;
}

// --- auth (session TG ou bearer) ---
require_auth_melt($telegram_id);

// --- taux EUR (cache 60 s) ---
function btc_eur_rate(): float {
  $cache = __DIR__ . '/.btc_eur.cache.json';
  if (is_file($cache) && (time() - filemtime($cache) < 60)) {
    $j = json_decode(@file_get_contents($cache), true);
    if (!empty($j['eur'])) return (float)$j['eur'];
  }
  // on essaye d'abord l'endpoint local /api/rates.php
  $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
  $eur = 0.0;
  $local = @file_get_contents($scheme.'://'.$host.'/api/rates.php');
  if ($local) {
    $js = json_decode($local, true);
    if (!empty($js['ok']) && !empty($js['btc_eur'])) $eur = (float)$js['btc_eur'];
  }
  // fallback CoinGecko
  if ($eur <= 0) {
    $co = @file_get_contents('https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=eur');
    if ($co) { $js = json_decode($co, true); $eur = (float)($js['bitcoin']['eur'] ?? 0); }
  }
  if ($eur > 0) @file_put_contents($cache, json_encode(['eur'=>$eur]));
  return max(0.0, $eur);
}

// --- lecture DB (solde interne + adresse) ---
try {
  $pdo = pdo();

  // s'assure que la ligne existe
  $st = $pdo->prepare("SELECT balance_sats, btc_address, btc_index FROM telegram_users WHERE telegram_id=?");
  $st->execute([$telegram_id]);
  $row = $st->fetch(PDO::FETCH_ASSOC);

  if (!$row) {
    // crée une ligne si besoin (solde 0)
    $pdo->prepare("INSERT INTO telegram_users(telegram_id, balance_sats, btc_index, btc_address) VALUES(?,0,0,NULL)")
        ->execute([$telegram_id]);
    $row = ['balance_sats'=>0, 'btc_address'=>null, 'btc_index'=>0];
  }

  $sats = (int)($row['balance_sats'] ?? 0);
  $btc  = $sats / 1e8;

  $rate = btc_eur_rate();
  $eur  = $rate > 0 ? $btc * $rate : 0.0;

  echo json_encode([
    'ok'            => true,
    'balance_sats'  => $sats,
    'balance_btc'   => $btc,
    'balance_eur'   => $eur,
    'btc_address'   => $row['btc_address'] ?? null,
    'btc_index'     => (int)($row['btc_index'] ?? 0),
  ]);
} catch (\Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>'server_error','detail'=>$e->getMessage()]);
}
