<?php

declare(strict_types=1);



// Ce fichier est inclus par d'autres endpoints.

// NE RIEN EXÉCUTER ICI (pas de "main" en bas).

if (!headers_sent()) {

  header('Content-Type: application/json; charset=utf-8');

}



/* ====== CONSTANTES (garde tes valeurs) ====== */

const API_TOKEN = 'QzFFLqMFeFP5XSUE3HUgQzqAfkWc2qXsuvqftKs8pQSrWJGtU1orPX8L';

const ACCOUNT_XPUB = 'xpub6DJSvnpyqHyPX4rkpHU2An1MKJziFRTFyoFVGcSxWWhXE2vogqT1rhRjaaw2zJ6jpXn34BDRzPMwKWTPvQzuHas4K2tmic6imuorfphVFSL';



$DB_HOST = '127.0.0.1';

$DB_NAME = 'meltxpwi_senzu';

$DB_USER = 'meltxpwi_captain';

$DB_PASS = 'LQU[58s%?Y6R';

$DB_CHARSET = 'utf8mb4';



/* ====== AUTH ====== */

// Auth générique par Bearer (utilisée par /api/rates.php, etc.)

function require_auth(): void {

  $hdr = $_SERVER['HTTP_AUTHORIZATION'] ?? '';

  if (preg_match('/Bearer\s+(.+)/i', $hdr, $m) && hash_equals(API_TOKEN, $m[1])) {

    return;

  }

  if (isset($_GET['debug']) && $_GET['debug'] === '1') {

    return;

  }

  http_response_code(401);

  echo json_encode(['ok'=>false,'error'=>'unauthorized']);

  exit;

}



// Auth liée à un utilisateur Telegram précis

function require_auth_melt(?int $telegramId = null): void {

  // 1) Bearer OK

  $hdr = $_SERVER['HTTP_AUTHORIZATION'] ?? '';

  if (preg_match('/Bearer\s+(.+)/i', $hdr, $m) && hash_equals(API_TOKEN, $m[1])) {

    return;

  }

  // 2) Debug (facultatif)

  if (isset($_GET['debug']) && $_GET['debug'] === '1') { return; }



  // 3) Session Telegram valide

  if ($telegramId) {

    if (session_status() === PHP_SESSION_NONE) { @session_start(); }

    if (!empty($_SESSION['telegram_id']) && (int)$_SESSION['telegram_id'] === (int)$telegramId) {

      return;

    }

  }



  http_response_code(401);

  echo json_encode(['ok'=>false,'error'=>'unauthorized']);

  exit;

}



/* ====== PDO (singleton) ====== */

function pdo(): PDO {

  static $pdo = null;

  if ($pdo === null) {

    $dsn = "mysql:host={$GLOBALS['DB_HOST']};dbname={$GLOBALS['DB_NAME']};charset={$GLOBALS['DB_CHARSET']}";

    $pdo = new PDO($dsn, $GLOBALS['DB_USER'], $GLOBALS['DB_PASS'], [

      PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,

      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,

    ]);

  }

  return $pdo;

}



/* ====== UTILITAIRES OPTIONNELS ====== */

function getBtcBalanceFromXpub(string $xpub): float {

  // Blockstream API

  $url = "https://blockstream.info/api/xpub/{$xpub}";

  $json = @file_get_contents($url);

  if (!$json) { return 0.0; }

  $d = json_decode($json, true);

  // total = funded - spent  (on prend chain_stats si present)

  $funded = (int)($d['chain_stats']['funded_txo_sum'] ?? 0);

  $spent  = (int)($d['chain_stats']['spent_txo_sum']  ?? 0);

  $sats   = max(0, $funded - $spent);

  return $sats / 1e8;

}



function convertBtcToEur(float $btc): float {

  // simple fallback direct CoinGecko (utilise plutôt /api/rates.php côté app)

  $resp = @file_get_contents('https://api.coingecko.com/api/v3/simple/price?ids=bitcoin&vs_currencies=eur');

  if (!$resp) { return 0.0; }

  $j = json_decode($resp, true);

  $eur_rate = (float)($j['bitcoin']['eur'] ?? 0);

  return $btc * $eur_rate;

}



/* IMPORTANT : ne rien exécuter après ce point. */

