<?php
/* ========================================================================== *
 * /14s4gAjpCa8o/colis.php — PAGE COMPLÈTE (AdminLTE, actions locales OK)
 * ========================================================================== */

/* --------- ROUTES AJAX LOCALES (add/update/delete) --------- */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
  require_once __DIR__ . '/../includes/db.php';
  header('Content-Type: application/json; charset=utf-8');
  if (!isset($pdo) || !($pdo instanceof PDO)) { echo json_encode(['ok'=>0,'error'=>'DB non disponible']); exit; }
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  $action = $_POST['action'];

  if ($action === 'add') {
    $tracking = trim((string)($_POST['tracking_number'] ?? ''));
    if ($tracking === '') { echo json_encode(['ok'=>0,'error'=>'tracking_number manquant']); exit; }

    $fn      = trim((string)($_POST['first_name'] ?? ''));
    $ln      = trim((string)($_POST['last_name'] ?? ''));
    $address = trim((string)($_POST['address'] ?? ''));
    $note    = trim((string)($_POST['note'] ?? ''));
    $status  = strtoupper(trim((string)($_POST['status'] ?? '')));
    $allowed = ['', 'IN_TRANSIT','DELIVERED','CUSTOMS','EXCEPTION','NOT_FOUND','PENDING','UNKNOWN'];
    if (!in_array($status, $allowed, true)) $status = '';
    if ($status === '') $status = 'PENDING';

    $sql = "INSERT INTO colis (tracking_number, first_name, last_name, address, note, status_code)
            VALUES (?,?,?,?,?,?)";
    $pdo->prepare($sql)->execute([$tracking,$fn,$ln,$address,$note,$status]);

    echo json_encode(['ok'=>1,'id'=>(int)$pdo->lastInsertId()]);
    exit;
  }

  if ($action === 'update') {
    $id = (int)($_POST['id'] ?? 0);
    if ($id <= 0) { echo json_encode(['ok'=>0,'error'=>'ID manquant']); exit; }

    $tracking = trim((string)($_POST['tracking_number'] ?? ''));
    $fn       = trim((string)($_POST['first_name'] ?? ''));
    $ln       = trim((string)($_POST['last_name'] ?? ''));
    $address  = trim((string)($_POST['address'] ?? ''));
    $note     = trim((string)($_POST['note'] ?? ''));
    $status   = strtoupper(trim((string)($_POST['status'] ?? '')));
    $allowed  = ['', 'IN_TRANSIT','DELIVERED','CUSTOMS','EXCEPTION','NOT_FOUND','PENDING','UNKNOWN'];
    if (!in_array($status, $allowed, true)) $status = '';

    $sets   = ['tracking_number=?','first_name=?','last_name=?','address=?','note=?'];
    $params = [$tracking,$fn,$ln,$address,$note];
    if ($status !== '') { $sets[]='status_code=?'; $params[]=$status; }
    $params[] = $id;

    $pdo->prepare('UPDATE colis SET '.implode(', ',$sets).' WHERE id=?')->execute($params);
    $st = $pdo->prepare('SELECT * FROM colis WHERE id=?'); $st->execute([$id]);
    echo json_encode(['ok'=>1,'row'=>$st->fetch(PDO::FETCH_ASSOC)]);
    exit;
  }

  if ($action === 'delete') {
    $id = (int)($_POST['id'] ?? 0);
    if ($id <= 0) { echo json_encode(['ok'=>0,'error'=>'ID manquant']); exit; }
    $pdo->prepare('DELETE FROM colis WHERE id=?')->execute([$id]);
    echo json_encode(['ok'=>1,'deleted'=>1,'id'=>$id]);
    exit;
  }

  echo json_encode(['ok'=>0,'error'=>'action inconnue']);
  exit;
}

/* --------- Rendu page --------- */
require_once __DIR__ . '/../includes/db.php';
if (!isset($pdo) || !($pdo instanceof PDO)) { die('DB indisponible'); }
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function badge_class($code){
  $c=strtoupper((string)$code);
  if ($c==='DELIVERED') return 'badge-success';
  if ($c==='IN_TRANSIT') return 'badge-primary';
  if (in_array($c,['CUSTOMS','EXCEPTION','NOT_FOUND','PENDING'])) return 'badge-secondary';
  return 'badge-secondary';
}

$stat=['total'=>0,'delivered'=>0,'in_transit'=>0,'customs'=>0,'exception'=>0,'not_found'=>0,'pending'=>0,'unknown'=>0];
$rows=$pdo->query("SELECT status_code, COUNT(*) c FROM colis GROUP BY status_code")->fetchAll(PDO::FETCH_ASSOC);
foreach($rows as $r){ $k=strtolower($r['status_code']??'unknown'); $c=(int)$r['c']; $stat['total']+=$c; if(isset($stat[$k]))$stat[$k]+=$c; }
$total=$stat['total']; $del=$stat['delivered']; $inT=$stat['in_transit'];
$issues=$stat['customs']+$stat['exception']+$stat['not_found']+$stat['unknown']; $pend=$stat['pending'];
$pct=$total?round($del*100/$total):0; $ratioCls=$pct>=80?'bg-success':($pct>=50?'bg-warning':'bg-danger');

$items=$pdo->query("SELECT * FROM colis ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

/* URL API distante (pour le tracking) */
$API_URL='/14s4gAjpCa8o/api/colis_actions.php';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <title>Tracking Colis</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- AdminLTE + Bootstrap + FA -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <style>
    @keyframes fadeInUp { from{opacity:0;transform:translateY(6px)} to{opacity:1;transform:none} }
    @keyframes fadeSlideIn { from{opacity:0;transform:translateY(10px)} to{opacity:1;transform:none} }
    .fadeInUp{ animation:fadeInUp .25s ease-out both; }
    .fadeSlideIn{ animation:fadeSlideIn .35s ease-out both; }
    .table-nowrap td,.table-nowrap th{ white-space:nowrap; }
    .td-ellipsis{ max-width:360px; overflow:hidden; text-overflow:ellipsis; white-space:nowrap; }
    .td-ellipsis-sm{ max-width:220px; overflow:hidden; text-overflow:ellipsis; white-space:nowrap; }
    .subrow td{ background:#f9fbfd; border-top:none; }
    /* === Console tracking (timeline) === */
.console-toolbar .btn.active { box-shadow: inset 0 0 0 2px rgba(0,0,0,.1); }
.timeline {
  position: relative; padding-left: 20px;
}
.timeline:before {
  content:""; position:absolute; left:9px; top:0; bottom:0; width:2px; background:#e9ecef;
}
.timeline-item {
  position: relative; padding:.5rem .5rem .5rem 1.25rem; margin-bottom:.35rem; border-radius:.35rem;
  background:#fff; border:1px solid #f1f1f1;
}
.timeline-item:before {
  content:""; position:absolute; left:3px; top:.9rem; width:12px; height:12px; border-radius:50%;
  background:#6c757d; border:2px solid #fff; box-shadow:0 0 0 2px #e9ecef;
}
.timeline-time { font-weight:600; }
.timeline-loc  { color:#6c757d; }
#console-raw { max-height: 320px; overflow:auto; }
  </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <?php include 'sidebar.php'; ?>

  <div class="content-wrapper">

    <section class="content-header">
      <div class="container-fluid">
        <h1 class="m-0"><i class="fas fa-box mr-2"></i> Tracking Colis</h1>
      </div>
    </section>

    <section class="content"><div class="container-fluid">

      <!-- KPI -->
      <div class="row">
        <div class="col-lg-3 col-6">
          <div id="box-touchdown" class="small-box <?= $ratioCls ?>">
            <div class="inner">
              <h3 id="td-pct"><?= $pct ?><sup style="font-size:20px">%</sup></h3>
              <p>Touchdown Ratio — % livrés</p>
              <div class="progress"><div id="td-bar" class="progress-bar" style="width:<?= $pct ?>%"></div></div>
              <small id="td-caption"><?= $del ?> / <?= $total ?> livrés</small>
            </div>
            <div class="icon"><i class="fas fa-check-circle"></i></div>
            <span class="small-box-footer">Actualisé après chaque suivi</span>
          </div>
        </div>
        <div class="col-lg-3 col-6"><div class="small-box bg-success"><div class="inner"><h3 id="td-delivered"><?= $del ?></h3><p>Livrés</p></div><div class="icon"><i class="fas fa-box"></i></div></div></div>
        <div class="col-lg-3 col-6"><div class="small-box bg-primary"><div class="inner"><h3 id="td-intransit"><?= $inT ?></h3><p>En cours</p></div><div class="icon"><i class="fas fa-truck"></i></div></div></div>
        <div class="col-lg-3 col-6"><div class="small-box bg-danger"><div class="inner"><h3 id="td-issues"><?= $issues ?></h3><p>Douane / Non livré / Erreurs</p></div><div class="icon"><i class="fas fa-exclamation-triangle"></i></div><span class="small-box-footer">En attente: <b id="td-pending"><?= $pend ?></b></span></div></div>
      </div>

      <!-- Ajouter un colis -->
      <div class="card card-primary fadeSlideIn">
        <div class="card-header">
          <h3 class="card-title"><i class="fas fa-plus-circle mr-1"></i> Ajouter un colis</h3>
          <div class="card-tools"><button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button></div>
        </div>
        <form id="add-colis-form" autocomplete="off">
          <div class="card-body">
            <div id="add-alerts"></div>
            <div class="row">
              <div class="col-md-4"><div class="form-group"><label>Numéro de suivie <span class="text-danger">*</span></label><input type="text" name="tracking_number" class="form-control" placeholder="Ex: CP081829930TH" required></div></div>
              <div class="col-md-4"><div class="form-group"><label>Prénom</label><input type="text" name="first_name" class="form-control"></div></div>
              <div class="col-md-4"><div class="form-group"><label>Nom</label><input type="text" name="last_name" class="form-control"></div></div>
            </div>
            <div class="row">
              <div class="col-md-8"><div class="form-group"><label>Adresse</label><input type="text" name="address" class="form-control"></div></div>
              <div class="col-md-4">
                <div class="form-group"><label>Statut (manuel)</label>
                  <select name="status" class="form-control">
                    <option value="">-- Auto --</option>
                    <option value="IN_TRANSIT">En cours</option>
                    <option value="DELIVERED">Livré</option>
                    <option value="CUSTOMS">Douane</option>
                    <option value="EXCEPTION">Problème</option>
                  </select>
                  <small class="form-text text-muted">Tu pourras modifier plus tard.</small>
                </div>
              </div>
            </div>
            <div class="form-group"><label>Note</label><textarea name="note" class="form-control" rows="2"></textarea></div>
            <div class="form-group">
              <label>API de tracking</label><br>
              <div class="custom-control custom-radio d-inline-block mr-3"><input class="custom-control-input" type="radio" name="provider" id="prov-auto" value="auto" checked><label class="custom-control-label" for="prov-auto">Automatique (ThaiPost → 17TRACK)</label></div>
              <div class="custom-control custom-radio d-inline-block mr-3"><input class="custom-control-input" type="radio" name="provider" id="prov-thaipost" value="thaipost"><label class="custom-control-label" for="prov-thaipost">ThaiPost</label></div>
              <div class="custom-control custom-radio d-inline-block mr-3"><input class="custom-control-input" type="radio" name="provider" id="prov-17" value="17track"><label class="custom-control-label" for="prov-17">17TRACK (auto)</label></div>
              <div class="custom-control custom-radio d-inline-block mr-3"><input class="custom-control-input" type="radio" name="provider" id="prov-laposte" value="laposte"><label class="custom-control-label" for="prov-laposte">La Poste (via 17TRACK)</label></div>
              <div class="custom-control custom-radio d-inline-block mr-3"><input class="custom-control-input" type="radio" name="provider" id="prov-all" value="all"><label class="custom-control-label" for="prov-all">Tous (3 APIs)</label></div>
            </div>
            <div class="custom-control custom-switch mb-0"><input type="checkbox" class="custom-control-input" id="runTrackNow" checked><label class="custom-control-label" for="runTrackNow">Lancer le tracking tout de suite</label></div>
          </div>
          <div class="card-footer">
            <button type="submit" class="btn btn-primary" id="btn-add-colis"><span class="spinner-border spinner-border-sm mr-2 d-none" id="addSpinner"></span>Ajouter</button>
            <button type="reset" class="btn btn-default ml-2">Effacer</button>
            <div class="float-right text-muted small" id="addColisHint"></div>
          </div>
        </form>
      </div>

      <!-- Suivis -->
      <div class="card card-outline card-primary fadeInUp">
        <div class="card-header d-flex align-items-center">
          <h3 class="card-title"><i class="fas fa-shipping-fast mr-2"></i> Suivis des colis</h3>
          <div class="card-tools">
            <div class="btn-group mr-2">
              <button type="button" class="btn btn-sm btn-default" id="btn-refresh-selected"><i class="fas fa-sync-alt"></i> Actualiser sélection</button>
              <button type="button" class="btn btn-sm btn-default" id="btn-refresh-all"><i class="fas fa-redo"></i> Tout actualiser</button>
            </div>
            <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
          </div>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-hover table-striped mb-0 table-nowrap" id="colis-table">
              <thead class="thead-light">
                <tr>
                  <th style="width:36px;">
                    <div class="custom-control custom-checkbox">
                      <input type="checkbox" class="custom-control-input" id="chk-all">
                      <label class="custom-control-label" for="chk-all"></label>
                    </div>
                  </th>
                  <th>#</th>
                  <th>Numéro</th>
                  <th>Client</th>
                  <th class="d-none d-md-table-cell">Adresse</th>
                  <th class="d-none d-lg-table-cell">Note</th>
                  <th>Dernière update</th>
                  <th>Statut</th>
                  <th>API</th>
                  <th class="text-right">Actions</th>
                </tr>
              </thead>
              <tbody>
              <?php foreach($items as $row): ?>
                <tr
                  data-id="<?= (int)$row['id'] ?>"
                  data-tracking="<?= e($row['tracking_number']) ?>"
                  data-fn="<?= e($row['first_name']) ?>"
                  data-ln="<?= e($row['last_name']) ?>"
                  data-address="<?= e($row['address'] ?? '') ?>"
                  data-note="<?= e($row['note'] ?? '') ?>"
                  data-status="<?= e($row['status_code'] ?? '') ?>">
                  <td>
                    <div class="custom-control custom-checkbox">
                      <input type="checkbox" class="custom-control-input row-chk" id="chk-<?= (int)$row['id'] ?>">
                      <label class="custom-control-label" for="chk-<?= (int)$row['id'] ?>"></label>
                    </div>
                  </td>
                  <td><?= (int)$row['id'] ?></td>
                  <td><strong><?= e($row['tracking_number']) ?></strong></td>
                  <td class="td-ellipsis-sm"><?= e(trim(($row['first_name']??'').' '.($row['last_name']??''))) ?></td>
                  <td class="td-ellipsis d-none d-md-table-cell"><?= e($row['address']??'') ?></td>
                  <td class="td-ellipsis d-none d-lg-table-cell"><?= e($row['note']??'') ?></td>
                  <td class="td-last text-muted">
                    <?php
                      $lastTxt=$row['status_text']??''; $lastAt=$row['last_event_at']??'';
                      if($lastTxt||$lastAt){ echo '<span class="text-body">'.e($lastTxt).'</span>'; if($lastAt) echo '<br><small class="text-muted">'.e($lastAt).'</small>'; }
                      else echo '—';
                    ?>
                  </td>
                  <td class="td-status">
                    <?php $cls=badge_class($row['status_code']??''); $labelMap=['DELIVERED'=>'Livré','IN_TRANSIT'=>'En cours','CUSTOMS'=>'Douane','EXCEPTION'=>'Problème','NOT_FOUND'=>'En attente','PENDING'=>'En attente']; $codeUp=strtoupper($row['status_code']??''); ?>
                    <span class="badge <?= $cls ?>"><?= e($labelMap[$codeUp] ?? '—') ?></span>
                  </td>
                  <td class="td-provider">
                    <div class="dropdown">
                      <button class="btn btn-xs btn-outline-secondary dropdown-toggle" type="button" data-toggle="dropdown">
                        <i class="fas fa-satellite-dish"></i> Auto
                      </button>
                      <div class="dropdown-menu">
                        <a class="dropdown-item provider-opt" href="#" data-provider="auto">Auto</a>
                        <a class="dropdown-item provider-opt" href="#" data-provider="thaipost">ThaiPost</a>
                        <a class="dropdown-item provider-opt" href="#" data-provider="17track">17TRACK (auto)</a>
                        <a class="dropdown-item provider-opt" href="#" data-provider="laposte">La Poste (Colissimo)</a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item provider-opt" href="#" data-provider="all">Tous (3 APIs)</a>
                      </div>
                    </div>
                  </td>
                  <td class="text-right">
                    <div class="btn-group">
                      <button class="btn btn-xs btn-outline-primary btn-expand" title="Historique"><i class="fas fa-plus"></i></button>
                      <button class="btn btn-xs btn-outline-secondary btn-refresh" title="Actualiser"><i class="fas fa-sync-alt"></i></button>
                      <button class="btn btn-xs btn-outline-dark btn-console" title="Console"><i class="fas fa-terminal"></i></button>
                      <button class="btn btn-xs btn-outline-info btn-edit" title="Modifier"><i class="fas fa-pen"></i></button>
                      <button class="btn btn-xs btn-outline-danger btn-delete" title="Supprimer"><i class="fas fa-trash"></i></button>
                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>

      <!-- MODAL EDIT -->
      <div class="modal fade" id="modal-edit-colis" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
          <form id="form-edit-colis" class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title"><i class="fas fa-pen mr-2"></i> Modifier le colis</h5>
              <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
            </div>
            <div class="modal-body">
              <div id="edit-msg"></div>
              <input type="hidden" name="id" id="edit-id">
              <div class="form-row">
                <div class="form-group col-md-4"><label>Numéro de suivie</label><input type="text" class="form-control" name="tracking_number" id="edit-tracking" required></div>
                <div class="form-group col-md-4"><label>Prénom</label><input type="text" class="form-control" name="first_name" id="edit-fn"></div>
                <div class="form-group col-md-4"><label>Nom</label><input type="text" class="form-control" name="last_name" id="edit-ln"></div>
              </div>
              <div class="form-row">
                <div class="form-group col-md-8"><label>Adresse</label><input type="text" class="form-control" name="address" id="edit-address"></div>
                <div class="form-group col-md-4"><label>Statut (manuel)</label>
                  <select class="form-control" name="status" id="edit-status">
                    <option value="">-- Auto --</option>
                    <option value="IN_TRANSIT">En cours</option>
                    <option value="DELIVERED">Livré</option>
                    <option value="CUSTOMS">Douane</option>
                    <option value="EXCEPTION">Problème</option>
                    <option value="NOT_FOUND">En attente</option>
                    <option value="PENDING">Pending</option>
                  </select>
                </div>
              </div>
              <div class="form-group"><label>Note</label><textarea class="form-control" rows="2" name="note" id="edit-note"></textarea></div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
              <button type="submit" class="btn btn-primary" id="btn-save-edit"><span class="spinner-border spinner-border-sm mr-2 d-none" id="editSpinner"></span>Enregistrer</button>
            </div>
          </form>
        </div>
      </div>

      <!-- MODAL DELETE -->
      <div class="modal fade" id="modal-delete-colis" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header bg-danger text-white">
              <h5 class="modal-title"><i class="fas fa-trash mr-2"></i> Supprimer le colis</h5>
              <button type="button" class="close text-white" data-dismiss="modal"><span>&times;</span></button>
            </div>
            <div class="modal-body">
              <div id="delete-msg"></div>
              <input type="hidden" id="del-id">
              <p>Confirmer la suppression du tracking <b id="del-track"></b> ?</p>
              <small class="text-muted">Action définitive.</small>
            </div>
            <div class="modal-footer">
              <button class="btn btn-default" data-dismiss="modal">Annuler</button>
              <button class="btn btn-danger" id="btn-confirm-delete"><span class="spinner-border spinner-border-sm mr-2 d-none" id="delSpinner"></span>Supprimer</button>
            </div>
          </div>
        </div>
      </div>

      <!-- MODAL CONSOLE -->
<div class="modal fade" id="modal-console" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">
          <i class="fas fa-terminal mr-2"></i> Console tracking — 
          <span id="console-track"></span>
        </h5>
        <button type="button" class="close text-white" data-dismiss="modal"><span>&times;</span></button>
      </div>
      <div class="modal-body">
        <div class="console-toolbar d-flex align-items-center flex-wrap mb-3">
          <div class="btn-group btn-group-sm mr-3" role="group">
            <button class="btn btn-outline-secondary console-prov" data-provider="thaipost">
              <i class="fas fa-flag mr-1"></i>ThaiPost
            </button>
            <button class="btn btn-outline-secondary console-prov" data-provider="17track">
              <i class="fas fa-hashtag mr-1"></i>17TRACK
            </button>
            <button class="btn btn-outline-secondary console-prov" data-provider="laposte">
              <i class="fas fa-mail-bulk mr-1"></i>La&nbsp;Poste
            </button>
          </div>
          <span id="console-status" class="text-muted small"></span>
        </div>

        <div id="console-alert"></div>
        <div id="console-events" class="timeline"></div>

        <pre id="console-raw" class="mt-3 bg-light p-2 rounded d-none"></pre>
      </div>
      <div class="modal-footer">
        <div class="form-check mr-auto">
          <input class="form-check-input" type="checkbox" id="console-toggle-raw">
          <label class="form-check-label" for="console-toggle-raw">Voir le JSON brut</label>
        </div>
        <button class="btn btn-secondary" data-dismiss="modal">Fermer</button>
      </div>
    </div>
  </div>
</div>



    </div></section>
  </div><!-- /.content-wrapper -->
</div><!-- /.wrapper -->

<!-- JS -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>

<script>
(function initWhenReady(){
  if(!window.jQuery || !window.$){ return setTimeout(initWhenReady,80); }
  if(!$.fn || !$.fn.modal){ return setTimeout(initWhenReady,80); }
  setupColisUI();
})();

function setupColisUI(){
  const API_URL = <?= json_encode($API_URL) ?>;  // '/14s4gAjpCa8o/api/colis_actions.php'

  /* ---------- Helpers ---------- */
  async function postJSON(url, obj){
    const r = await fetch(url, {
      method: 'POST',
      headers: {'Content-Type':'application/json'},
      body: JSON.stringify(obj)
    });
    const txt = await r.text();
    try { return JSON.parse(txt); }
    catch { throw new Error('Réponse non-JSON: ' + txt.slice(0,200)); }
  }

  const STATUS_BADGE = (code)=>{
    code=(code||'').toUpperCase();
    if(code==='DELIVERED') return '<span class="badge badge-success">Livré</span>';
    if(code==='IN_TRANSIT') return '<span class="badge badge-primary">En cours</span>';
    if(code==='CUSTOMS'||code==='EXCEPTION') return '<span class="badge badge-danger">Problème/Douane</span>';
    if(code==='NOT_FOUND'||code==='PENDING'||!code) return '<span class="badge badge-secondary">En attente</span>';
    return '<span class="badge badge-secondary">—</span>';
  };
  const providerLabel = p => (p==='thaipost'?'ThaiPost':p==='17track'?'17TRACK':p==='laposte'?'La Poste':p==='all'?'Tous':'Auto');

  function recalcKPI(){
    const $rows=$('#colis-table tbody tr').not('.subrow');
    let total=0,del=0,inT=0,issues=0,pending=0;
    $rows.each(function(){
      total++;
      const t=(($(this).find('.td-status .badge').text())||'').trim().toUpperCase();
      if(t==='LIVRÉ'||t==='LIVRE') del++;
      else if(t==='EN COURS') inT++;
      else if(t==='EN ATTENTE'||t==='—') pending++;
      else issues++;
    });
    const pct=total?Math.round(del*100/total):0;
    const cls=pct>=80?'bg-success':(pct>=50?'bg-warning':'bg-danger');
    $('#box-touchdown').removeClass('bg-success bg-warning bg-danger').addClass(cls);
    $('#td-pct').html(pct+'<sup style="font-size:20px">%</sup>');
    $('#td-bar').css('width',pct+'%');
    $('#td-caption').text(del+' / '+total+' livrés');
    $('#td-delivered').text(del); $('#td-intransit').text(inT); $('#td-issues').text(issues); $('#td-pending').text(pending);
  }
  function fmtLast(ev){
    if(!ev) return '—';
    const when = ev.time ? String(ev.time).replace('T',' ').replace('+07:00','') : '';
    const loc  = ev.loc ? ' <span class="text-secondary">· '+$('<div/>').text(ev.loc).html()+'</span>' : '';
    return '<span class="text-body">'+$('<div/>').text(ev.text||'').html()+'</span>'
         + (when?'<br><small class="text-muted">'+when+loc+'</small>':'');
  }

  /* ---------- Normalisation de réponse ---------- */
  function rankStatus(code){ const c=(code||'').toUpperCase();
    if(c==='DELIVERED') return 3; if(c==='IN_TRANSIT') return 2; if(c==='CUSTOMS') return 1; return 0;
  }
  function normalize(res, prefer){
    if(!res) return null;

    // Format "refresh": { rows: { "<id>": { ... } } }
    if (res.rows){
      const id = String(currentRowId || '');
      const r  = res.rows[id] || {};
      return {
        provider: prefer || 'auto',
        status_code: r.status_code || '',
        status_text: r.status_text || '',
        last_event_at: r.last_event_at || '',
        payload: {}, raw_all: null, from_refresh: true
      };
    }

    // Format "providers" (track all) ou plat
    if(res.providers){
      const provs = res.providers;
      const want  = (prefer && prefer!=='auto' && prefer!=='all') ? prefer : null;
      let key = want;
      if(!key){
        let best=null,score=-1;
        Object.keys(provs).forEach(k=>{
          const p=provs[k]||{};
          const s=rankStatus(p.status_code);
          const hasEvt = !!(p.last_event_at
            || ((((p||{}).raw||{}).track||{}).z0)
            || ((((p||{}).raw||{}).response||{}).items));
          const sc=s*10 + (hasEvt?1:0);
          if(sc>score){ score=sc; best=k; }
        });
        key = best || Object.keys(provs)[0];
      }
      const chosen = provs[key] || {};
      return {
        provider:key,
        status_code:chosen.status_code||'',
        status_text:chosen.status_text||'',
        last_event_at:chosen.last_event_at||'',
        payload: chosen.raw || chosen,
        raw_all: provs
      };
    }
    return {
      provider: prefer||'auto',
      status_code: res.status_code||'',
      status_text: res.status_text||'',
      last_event_at: res.last_event_at||'',
      payload: res.raw || res,
      raw_all: res.raw_all || null
    };
  }
  function goodEnoughNormalized(n){
    if(!n) return false;
    const sc=(n.status_code||'').toUpperCase();
    if(sc && sc!=='NOT_FOUND' && sc!=='EXCEPTION' && sc!=='UNKNOWN') return true;
    if(n.last_event_at) return true;
    const trk=((n.payload||{}).track)||{}; const tp=((n.payload||{}).response)||null;
    return !!(trk && (trk.z0 || (trk.z1||[]).length || (trk.z2||[]).length) || tp);
  }
  function parseEventsFromNormalized(n){
    try{
      if(n.from_refresh) return []; // refresh ne renvoie pas l'historique
      const provider=(n.provider||'').toLowerCase();
      const payload=n.payload||{};
      if(provider==='thaipost'){
        const items=((payload.response||{}).items)||{};
        const k=Object.keys(items)[0]; const arr=items[k]||[];
        return arr.map(x=>({time:x.status_date||'',text:x.status_description||x.status_detail||x.status||'Update',loc:x.location||''}))
                  .sort((a,b)=>(a.time<b.time?1:-1));
      }
      const trk=payload.track||{};
      const pool=[].concat(trk.z0||[], trk.z1||[], trk.z2||[], trk.z9||[]);
      return pool.map(e=>({time:e.a||'',text:e.z||'Update',loc:e.c||''}))
                 .sort((a,b)=>(a.time<b.time?1:-1));
    }catch(e){ return []; }
  }
  function renderTrackNormalized($tr, n){
    const sc=(n.status_code||'').toUpperCase();
    $tr.find('.td-status').html(STATUS_BADGE(sc));
    const evts = parseEventsFromNormalized(n);
    const last = evts[0] || (n.last_event_at?{time:n.last_event_at,text:n.status_text||'',loc:''}:null);
    $tr.data('events',evts); $tr.data('shown',0);
    $tr.nextAll('tr.subrow[data-parent="'+$tr.data('id')+'"]').remove();
    $tr.find('.td-last').html( fmtLast(last) );
    recalcKPI();
  }

  /* ---------- Appels API ---------- */
// --- Helper: unwrap provider payload (fix La Poste proxied via 17TRACK) ---
function unwrapForProvider(raw, provider){
  let sub = raw;
  if (raw && raw.providers && raw.providers[provider]) {
    sub = raw.providers[provider];
  } else if (raw && raw[provider]) {
    sub = raw[provider];
  }
  // prefer .raw if present
  const base = (sub && sub.raw) ? sub.raw : sub;
  // parseProv defaults to requested provider; switch to '17track' only for La Poste proxied by 17TRACK
  let parseProv = provider;
  if (provider === 'laposte' && ((sub && (sub.source === '17track' || sub.source === '17TRACK')) || (base && base.track))) {
    parseProv = '17track';
  }
  return { base, parseProv };
}
// --- /Helper ---------------------------------------------------------------

  let currentRowId = null;

  // Essaye 'track' (JSON). Si pas concluant/erreur -> fallback 'refresh' (JSON).
  async function trackOnce(id, provider, timeoutSec){
    currentRowId = String(id);

    // 1) tentative 'track'
    try {
      const r1 = await postJSON(API_URL, {
        action: 'track', id, provider,
        include_raw: 1, timeout: timeoutSec || 20
      });
      // Si ça a l'air bon, on renvoie
      if (r1 && (r1.providers || r1.status_code || r1.raw)) return r1;
    } catch(_) { /* on tombera sur refresh */ }

    // 2) fallback 'refresh'
    return await postJSON(API_URL, {
      action: 'refresh',
      ids: [id],
      api_choice: provider
    });
  }

  const looksColissimo = n => /(^[A-Z]{2}\d{9}FR$)|(^6[A-Z0-9]{12,13}$)/i.test(n||'');

  async function trackCascade($tr, prefer){
    const id  = $tr.data('id');
    const num = (String($tr.data('tracking')||'')).toUpperCase();
    const seq = [];
    if(prefer==='thaipost' || prefer==='auto' || !prefer){ seq.push('thaipost','17track'); if(looksColissimo(num)) seq.push('laposte'); }
    else if(prefer==='17track'){ seq.push('17track','thaipost'); if(looksColissimo(num)) seq.push('laposte'); }
    else if(prefer==='laposte'){ seq.push('laposte','17track','thaipost'); }
    else if(prefer==='all'){ seq.push('thaipost','17track','laposte'); }
    else { seq.push('17track'); }

    let lastNorm=null,lastErr=null;
    for(const p of seq){
      try{
        const raw = await trackOnce(id, p, p==='thaipost'?25:20);
        const n   = normalize(raw, p); lastNorm=n;
        if(goodEnoughNormalized(n)){ renderTrackNormalized($tr,n); return {ok:1}; }
        lastErr = n?.status_text || 'Aucune donnée';
      }catch(e){ lastErr = e?.message || 'Erreur API'; }
    }
    if(lastNorm) renderTrackNormalized($tr,lastNorm);
    $tr.find('.td-last').html('<span class="text-danger" title="'+$('<div/>').text(String(lastErr||'API error')).html()+'">API error</span>');
    return {ok:0};
  }

  function setRowLoading($tr,on){
    $tr.toggleClass('table-active',on);
    $tr.find('.btn-refresh i').toggleClass('fa-sync-alt fa-spinner fa-spin',on);
  }

  /* ---------- Add / Edit / Delete ---------- */
  $('#add-colis-form').off('submit').on('submit', function(e){
    e.preventDefault();
    const fd=$(this).serializeArray().reduce((a,x)=>(a[x.name]=x.value,a),{});
    const provider = fd.provider || 'auto';
    const runNow   = $('#runTrackNow').is(':checked');

    $.post(window.location.pathname, {
      action:'add',
      tracking_number:(fd.tracking_number||'').trim(),
      first_name:fd.first_name||'',
      last_name:fd.last_name||'',
      address:fd.address||'',
      note:fd.note||'',
      status:fd.status||''
    }, null, 'json').done(async (res)=>{
      if(!res||res.ok!=1){ $('#add-alerts').html('<div class="alert alert-danger">Ajout impossible. '+(res?.error||'Réponse invalide')+'</div>'); return; }
      const row={ id:res.id, tracking_number:fd.tracking_number, first_name:fd.first_name||'', last_name:fd.last_name||'', address:fd.address||'', note:fd.note||'', status_code:fd.status||'PENDING' };
      const trHtml=`<tr data-id="${row.id}" data-tracking="${$('<div/>').text(row.tracking_number).html()}">
        <td><div class="custom-control custom-checkbox"><input type="checkbox" class="custom-control-input row-chk" id="chk-${row.id}"><label class="custom-control-label" for="chk-${row.id}"></label></div></td>
        <td>${row.id}</td>
        <td><strong>${row.tracking_number}</strong></td>
        <td class="td-ellipsis-sm">${(row.first_name+' '+row.last_name).trim()}</td>
        <td class="td-ellipsis d-none d-md-table-cell">${$('<div/>').text(row.address).html()}</td>
        <td class="td-ellipsis d-none d-lg-table-cell">${$('<div/>').text(row.note).html()}</td>
        <td class="td-last text-muted">—</td>
        <td class="td-status">${STATUS_BADGE(row.status_code)}</td>
        <td class="td-provider">
          <div class="dropdown">
            <button class="btn btn-xs btn-outline-secondary dropdown-toggle" data-toggle="dropdown"><i class="fas fa-satellite-dish"></i> Auto</button>
            <div class="dropdown-menu">
              <a class="dropdown-item provider-opt" href="#" data-provider="auto">Auto</a>
              <a class="dropdown-item provider-opt" href="#" data-provider="thaipost">ThaiPost</a>
              <a class="dropdown-item provider-opt" href="#" data-provider="17track">17TRACK (auto)</a>
              <a class="dropdown-item provider-opt" href="#" data-provider="laposte">La Poste (Colissimo)</a>
              <div class="dropdown-divider"></div>
              <a class="dropdown-item provider-opt" href="#" data-provider="all">Tous (3 APIs)</a>
            </div>
          </div>
        </td>
        <td class="text-right">
          <div class="btn-group">
            <button class="btn btn-xs btn-outline-primary btn-expand"><i class="fas fa-plus"></i></button>
            <button class="btn btn-xs btn-outline-secondary btn-refresh"><i class="fas fa-sync-alt"></i></button>
            <button class="btn btn-xs btn-outline-dark btn-console"><i class="fas fa-terminal"></i></button>
            <button class="btn btn-xs btn-outline-info btn-edit"><i class="fas fa-pen"></i></button>
            <button class="btn btn-xs btn-outline-danger btn-delete"><i class="fas fa-trash"></i></button>
          </div>
        </td>
      </tr>`;
      const $tr=$(trHtml).hide(); $('#colis-table tbody').prepend($tr); $tr.fadeIn(120);
      $('#add-alerts').html('<div class="alert alert-success">Colis ajouté (#'+row.id+')</div>');
      if(runNow){ setRowLoading($tr,true); await trackCascade($tr,provider); setRowLoading($tr,false); }
      $('#add-colis-form')[0].reset(); $('#prov-auto').prop('checked',true);
      recalcKPI();
    }).fail(xhr=> $('#add-alerts').html('<div class="alert alert-danger">Erreur serveur: '+xhr.status+' '+xhr.statusText+'</div>'));
  });

  /* ---------- Dropdown API + refresh/expand ---------- */
  $('#colis-table').on('click','.provider-opt', async function(e){
    e.preventDefault();
    const $tr=$(this).closest('tr'); const prov=$(this).data('provider');
    $tr.find('.dropdown-toggle').html('<i class="fas fa-satellite-dish"></i> '+providerLabel(prov));
    setRowLoading($tr,true); await trackCascade($tr,prov); setRowLoading($tr,false);
  });

  $('#colis-table').on('click','.btn-refresh', async function(){
    const $tr=$(this).closest('tr');
    const txt=($tr.find('.dropdown-toggle').text().match(/ThaiPost|17TRACK|La Poste|Tous/i)||['Auto'])[0].toLowerCase();
    const map={'auto':'auto','thaipost':'thaipost','17track':'17track','la poste':'laposte','tous':'all'};
    setRowLoading($tr,true); await trackCascade($tr, map[txt]||'auto'); setRowLoading($tr,false);
  });

  $('#btn-refresh-selected').off('click').on('click', async function(){
    const rows=$('#colis-table tbody tr').has('.row-chk:checked');
    for(const tr of rows.toArray()){ const $tr=$(tr); setRowLoading($tr,true); await trackCascade($tr,'auto'); setRowLoading($tr,false); }
  });
  $('#btn-refresh-all').off('click').on('click', async function(){
    const rows=$('#colis-table tbody tr').not('.subrow');
    for(const tr of rows.toArray()){
      const $tr=$(tr); setRowLoading($tr,true);
      await new Promise(r=>setTimeout(r,110));
      await trackCascade($tr,'auto'); setRowLoading($tr,false);
    }
  });

  $('#colis-table').on('click','.btn-expand', async function(){
    const $tr=$(this).closest('tr');
    if((($tr.data('events')||[]).length===0)){ setRowLoading($tr,true); await trackCascade($tr,'auto'); setRowLoading($tr,false); }
    // Ajouter une ligne d'historique
    const list=$tr.data('events')||[]; let idx=$tr.data('shown')||0;
    if(idx>=list.length) return;
    const ev=list[idx++]; $tr.data('shown',idx);
    const html=`<tr class="subrow" data-parent="${$tr.data('id')}">
      <td></td><td colspan="8">
        <div class="d-flex align-items-start">
          <i class="fas fa-history text-secondary mr-2"></i>
          <div>${fmtLast(ev)}</div>
          <span class="ml-auto badge badge-light">${providerLabel(($tr.find('.dropdown-toggle').text().trim()||'Auto').toLowerCase())}</span>
        </div>
      </td></tr>`;
    $(html).insertAfter($tr).hide().slideDown(140);
  });

  /* ---------- Modals ---------- */
  $('#colis-table').on('click','.btn-edit', function(){
    const $tr=$(this).closest('tr');
    $('#edit-id').val($tr.data('id'));
    $('#edit-tracking').val(($tr.find('td').eq(2).text()||'').trim());
    const client=($tr.find('td').eq(3).text()||'').trim();
    const parts=client.split(/\s+/); $('#edit-fn').val(parts.shift()||''); $('#edit-ln').val(parts.join(' ')||'');
    $('#edit-address').val(($tr.find('td').eq(4).text()||'').trim());
    $('#edit-note').val(($tr.find('td').eq(5).text()||'').trim());
    $('#edit-status').val('');
    $('#modal-edit-colis').modal('show');
  });

  $('#form-edit-colis').on('submit', function(e){
    e.preventDefault();
    const fd=$(this).serializeArray().reduce((a,x)=>(a[x.name]=x.value,a),{});
    $.post(window.location.pathname, { action:'update', ...fd }, null, 'json')
    .done(function(res){
      if(!res||res.ok!=1||!res.row){ alert('Mise à jour impossible'); return; }
      const r=res.row; const $tr=$('#colis-table tbody tr').filter((i,el)=>+$(el).data('id')===+r.id).first();
      if($tr.length){
        $tr.find('td').eq(2).html('<strong>'+r.tracking_number+'</strong>');
        $tr.find('td').eq(3).text((r.first_name||'')+' '+(r.last_name||'')); 
        $tr.find('td').eq(4).text(r.address||''); 
        $tr.find('td').eq(5).text(r.note||'');
        $tr.find('.td-status').html(STATUS_BADGE(r.status_code||''));
      }
      $('#modal-edit-colis').modal('hide'); recalcKPI();
    }).fail(()=> alert('Erreur serveur'));
  });

  $('#colis-table').on('click','.btn-delete', function(){
    const $tr=$(this).closest('tr');
    $('#del-id').val($tr.data('id'));
    $('#del-track').text(($tr.find('td').eq(2).text()||'').trim());
    $('#modal-delete-colis').modal('show');
  });
  $('#btn-confirm-delete').on('click', function(){
    const id=+$('#del-id').val();
    $(this).prop('disabled',true);
    $.post(window.location.pathname,{action:'delete', id:id}, null, 'json')
    .done(function(res){
      if(!res||res.ok!=1){ alert('Suppression impossible'); return; }
      const $tr=$('#colis-table tbody tr').filter((i,el)=>+$(el).data('id')===+id).first();
      $tr.nextAll('tr.subrow[data-parent="'+id+'"]').remove();
      $tr.remove(); $('#modal-delete-colis').modal('hide'); recalcKPI();
    }).always(()=> $('#btn-confirm-delete').prop('disabled',false));
  });

  /* === Console tracking ================================================== */
let consoleRowId = null, consoleTrackNum = '';

function providerNice(p){
  return p==='thaipost'?'ThaiPost' : p==='17track'?'17TRACK' : p==='laposte'?'La Poste' : 'Auto';
}
function toSelftestKey(p){
  return p==='17track' ? 'seventeen' : p; // thaipost|laposte restent identiques
}
function buildTimeline(evts){
  if(!evts || !evts.length) return '<div class="text-muted">—</div>';
  return evts.map(ev=>{
    const when = (ev.time||'').toString().replace('T',' ').replace('+07:00','');
    const txt  = $('<div/>').text(ev.text||'').html();
    const loc  = ev.loc ? ' <span class="timeline-loc">· ' + $('<div/>').text(ev.loc).html() + '</span>' : '';
    return `
      <div class="timeline-item">
        <div class="timeline-time">${when || '—'}</div>
        <div class="timeline-text">${txt}${loc}</div>
      </div>`;
  }).join('');
}

async function callTrack(id, provider){
  // tente 'track' (certaines installs ne l’ont pas)
  try {
    const r = await postJSON(API_URL, (function(){
  const payload = { action:'track', id, provider, include_raw:1, timeout:(provider==='thaipost'?25:20) };
  if(provider==='17track'){
    payload.origin_hint = 'TH';
    payload.seventeen_origin = 'TH';
    payload.seventeen_carrier = 20041; // ThaiPost
    payload.lang = 'fr';
  } else if(provider==='laposte'){
    payload.origin_hint = 'TH';
    payload.seventeen_origin = 'TH';
    payload.destination_hint = 'FR';
    payload.seventeen_destination = 'FR';
    // Try to force Colissimo routing on 17TRACK via common slug variants
    payload.seventeen_carrier_slug = 'la-poste-colissimo';
    payload.seventeen_dest_carrier_slug = 'la-poste-colissimo';
    payload.carrier_slug = 'la-poste-colissimo';
    payload.seventeen_carrier_code = 'la-poste-colissimo';
    payload.lang = 'fr';
  }
  return payload;
})());
    // on considère valide si on a providers, raw, track, status_code ou status_text
    if (r && (r.providers || r.raw || (r.track) || r.status_code || r.status_text)) return r;
  } catch(_) {}
  return null;
}
async function callSelftest(number, provider){
  // selftest attend des clés thaipost | seventeen | laposte
  const key = toSelftestKey(provider);
  const payload = { action:'selftest', timeout:(provider==='thaipost'?25:20) };
  if(provider==='17track'){
    payload.origin_hint = 'TH';
    payload.seventeen_origin = 'TH';
    payload.seventeen_carrier = 20041;
  } else if(provider==='laposte'){
    payload.origin_hint = 'TH';
    payload.seventeen_origin = 'TH';
    payload.destination_hint = 'FR';
    payload.seventeen_destination = 'FR';
    payload.seventeen_carrier_slug = 'la-poste-colissimo';
    payload.seventeen_dest_carrier_slug = 'la-poste-colissimo';
    payload.carrier_slug = 'la-poste-colissimo';
    payload.seventeen_carrier_code = 'la-poste-colissimo';
  }
  payload[key] = number;
  try {
    const r = await postJSON(API_URL, payload);
    // on essaie de récupérer la branche correspondant au provider
    const sub = r && (r[key] || r[provider] || r[toSelftestKey(provider)]);
    if (sub) {
      // on le met au format "plat" pour normalize()
      return { raw: sub.raw || sub, status_code: sub.status_code || '', status_text: sub.status_text || '', last_event_at: sub.last_event_at || '' };
    }
    // certaines implémentations renvoient directement un objet déjà normalisable
    if (r && (r.raw || r.providers || r.track)) return r;
  } catch(_) {}
  return null;
}
async function callRefresh(id, provider){
  try {
    return await postJSON(API_URL, { action:'refresh', ids:[id], api_choice:provider });
  } catch(_) { return null; }
}

async function consoleLoad(provider){
  $('#console-status').text('Chargement…');
  $('#console-alert').empty();
  $('#console-events').html('');
  $('#console-raw').addClass('d-none').text('');

  // 1) track ➜ 2) selftest (par numéro) ➜ 3) refresh (dernier statut)
  let raw = await callTrack(consoleRowId, provider);
  if (!raw) raw = await callSelftest(consoleTrackNum, provider);
  if (!raw) raw = await callRefresh(consoleRowId, provider);

  if (!raw){
    $('#console-alert').html('<div class="alert alert-danger">Impossible d’interroger '+providerNice(provider)+'.</div>');
    $('#console-status').text('Erreur');
    return;
  }

  const { base: rawForNorm, parseProv } = unwrapForProvider(raw, provider);
  const n = normalize(rawForNorm, parseProv); // utilise ta normalisation existante
  const evts = parseEventsFromNormalized(n) || [];
  
  // 17TRACK last interrogation timestamp (if present)
  const lastPoll = (((typeof rawForNorm!=='undefined' && rawForNorm) || {}).track || {}).ylt1 || null;
$('#console-events').html( buildTimeline(evts) );
  $('#console-raw').text( JSON.stringify((typeof rawForNorm!=='undefined'?rawForNorm:raw), null, 2) );
  if(!evts.length && (provider==='17track' || provider==='laposte')){
    try{
      let rawTP = await callTrack(consoleRowId, 'thaipost');
      if(!rawTP) rawTP = await callSelftest(consoleTrackNum, 'thaipost');
      if(rawTP){
        const nTP    = normalize(rawTP, 'thaipost');
        const evtsTP = parseEventsFromNormalized(nTP) || [];
        if(evtsTP.length){
          $('#console-alert').html(
            `<div class="alert alert-info mb-2">
               Aucun évènement renvoyé par <b>${providerNice(provider)}</b> pour ce numéro.
               Affichage des évènements disponibles depuis <b>ThaiPost</b> (fallback).
             </div>`
          );
          $('#console-events').html( buildTimeline(evtsTP) );
          $('#console-status').text(`${providerNice(provider)} • 0 évènement · fallback ThaiPost: ${evtsTP.length} évènement${evtsTP.length>1?'s':''}`);
          return;
        }
      }
    }catch(_){}
  }

  if(!evts.length){
    $('#console-alert').html(
      `<div class="alert alert-warning mb-2">
         Aucun évènement renvoyé par <b>${providerNice(provider)}</b> pour ce numéro.
         ${ (provider==='17track' || provider==='laposte') ? '(Il se peut que '+providerNice(provider)+' n\’ait pas encore indexé ce colis.)' : '' }
         ${ n.last_event_at ? 'Dernier statut reçu : <b>'+ $('<div/>').text(n.last_event_at||'').html() + '</b> · ' + $('<div/>').text(n.status_text||'').html() : '' }
         ${ lastPoll ? '<div class="small text-muted mt-1">Dernière interrogation : ' + $('<div/>').text(String(lastPoll)).html() + '</div>' : '' }
       </div>`
    );
  }
  $('#console-status').text(`${providerNice(provider)} • ${evts.length} évènement${evts.length>1?'s':''}`);
}

// Ouvrir la console depuis le tableau
$('#colis-table').on('click','.btn-console', function(){
  const $tr = $(this).closest('tr');
  consoleRowId   = $tr.data('id');
  consoleTrackNum = ($tr.find('td').eq(2).text()||'').trim();

  $('#console-track').text(`${consoleTrackNum} (#${consoleRowId})`);

  // provider courant affiché sur la ligne
  const txt = ($tr.find('.dropdown-toggle').text().match(/ThaiPost|17TRACK|La Poste/i)||['ThaiPost'])[0].toLowerCase();
  const map = {'thaipost':'thaipost','17track':'17track','la poste':'laposte'};
  const prov = map[txt] || 'thaipost';

  $('#modal-console .console-prov').removeClass('active');
  $('#modal-console .console-prov[data-provider="'+prov+'"]').addClass('active');

  $('#modal-console').modal('show');
  consoleLoad(prov);
});

// Changer de provider dans la console
$('#modal-console').on('click', '.console-prov', function(){
  $('#modal-console .console-prov').removeClass('active');
  $(this).addClass('active');
  const prov = $(this).data('provider');
  consoleLoad(prov);
});

// Afficher/Masquer le RAW
$('#console-toggle-raw').on('change', function(){
  $('#console-raw').toggleClass('d-none', !this.checked);
});
/* === /Console tracking ================================================= */



  /* ---------- Démarrage ---------- */
  recalcKPI();
  // Première passe cascade douce
  $('#btn-refresh-all').trigger('click');
}
</script>

</body>
</html>