\
<?php
/* --- Force La Poste through 17TRACK (Colissimo) --- */
$__provider_original = isset($in['provider']) ? $in['provider'] : null;
$__act = isset($in['action']) ? $in['action'] : (isset($in['act']) ? $in['act'] : null);
if ($__act === 'track' && ($in['provider'] ?? '') === 'laposte') {
    // route to 17TRACK with Colissimo hints
    $in['provider'] = '17track';
    // generic hints
    if (empty($in['origin_hint']))      $in['origin_hint']      = 'TH';
    if (empty($in['destination_hint'])) $in['destination_hint'] = 'FR';
    if (empty($in['lang']))             $in['lang']             = 'fr';
    // nested hints object used by some wrappers
    if (!isset($in['seventeen']) || !is_array($in['seventeen'])) $in['seventeen'] = [];
    $in['seventeen'] = array_merge([
        'carrier_slug' => 'la-poste-colissimo',
        'carrier_code' => 'la-poste-colissimo',
        'origin'       => 'TH',
        'destination'  => 'FR',
        'lang'         => 'fr',
        'locale'       => 'fr-FR',
    ], $in['seventeen']);
}
/* --- /Force Colissimo --- */

header('Content-Type: application/json; charset=utf-8');
ini_set('display_errors','0');
if (!ob_get_level()) ob_start();
session_start();

try {
  $raw = file_get_contents('php://input') ?: '';
  $req = json_decode($raw, true) ?: [];
  $action = $req['action'] ?? '';

  require_once __DIR__ . '/../includes/tracking_providers.php';
  $need_db = in_array($action, ['save','refresh'], true);
  if ($need_db) {
    require_once __DIR__ . '/../../includes/db.php';
    if (!isset($pdo) || !($pdo instanceof PDO)) { throw new Exception('DB $pdo non défini (vérifie /includes/db.php)'); }
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  }

  $out = function($a){
    while (ob_get_level()) { ob_end_clean(); }
    echo json_encode($a, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
    exit;
  };

  if ($action === 'selftest') {
    $tp_num  = trim($req['thaipost'] ?? '');
    $s17_num = trim($req['seventeen'] ?? '');
    $lp_num  = trim($req['laposte'] ?? '');
    $timeout = isset($req['timeout']) ? max(10, (int)$req['timeout']) : 20;

    $ret = ['ok'=>1, 'providers'=>[]];
    if ($tp_num!=='')  $ret['providers']['thaipost'] = track_with_thaipost($tp_num, $timeout);
    if ($s17_num!=='') $ret['providers']['17track']  = track_with_17track($s17_num);
    if ($lp_num!=='')  $ret['providers']['laposte']  = track_with_17track($lp_num, 'la-poste-colissimo', 'FR'); // via 17TRACK
    $out($ret);
  }

  if ($action === 'save') {
    $id = (int)($req['id'] ?? 0);
    if ($id<=0) $out(['error'=>'bad id']);

    $st = $pdo->prepare("UPDATE colis SET api_choice=:api, note=:note, status_code=:sc WHERE id=:id");
    $st->execute([
      ':api' => $req['api_choice'] ?? 'auto',
      ':note'=> $req['note'] ?? '',
      ':sc'  => $req['status_code'] ?? 'PENDING',
      ':id'  => $id,
    ]);
    $row = $pdo->query("SELECT * FROM colis WHERE id={$id}")->fetch(PDO::FETCH_ASSOC);
    $out(['ok'=>1,'row'=>$row]);
  }

  if ($action === 'refresh') {
    $ids = $req['ids'] ?? [];
    if (!is_array($ids) || !count($ids)) $out(['error'=>'no ids']);
    $overrideApi = $req['api_choice'] ?? '__row__';

    $ph = implode(',', array_fill(0, count($ids), '?'));
    $st = $pdo->prepare("SELECT * FROM colis WHERE id IN ($ph)");
    $st->execute(array_map('intval',$ids));
    $rows = $st->fetchAll(PDO::FETCH_ASSOC);

    $rowsOut = [];
    foreach ($rows as $r) {
      $id  = (int)$r['id'];
      $api = ($overrideApi==='__row__') ? ($r['api_choice'] ?: 'auto') : $overrideApi;
      $tn  = $r['tracking_number'];

      $resp = track_dispatch($tn, $api);

      $status_code  = $resp['status_code'] ?? 'UNKNOWN';
      $status_text  = $resp['status_text'] ?? null;
      $last_event   = $resp['last_event_at'] ?? null;
      $delivered_at = $resp['delivered_at'] ?? null;
      $now          = date('Y-m-d H:i:s');

      $upd = $pdo->prepare("UPDATE colis
        SET status_code=:sc, status_text=:st, last_event_at=:le,
            delivered_at=:da, last_checked_at=:lc, times_checked=times_checked+1,
            last_source=:src, last_json=:raw, updated_at=:u
        WHERE id=:id");
      $upd->execute([
        ':sc'=>$status_code, ':st'=>$status_text, ':le'=>$last_event, ':da'=>$delivered_at,
        ':lc'=>$now, ':src'=>$resp['source'] ?? null,
        ':raw'=>json_encode($resp, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES),
        ':u'=>$now, ':id'=>$id,
      ]);

      $rowsOut[$id] = [
        'status_code'=>$status_code, 'status_text'=>$status_text,
        'last_event_at'=>$last_event, 'last_checked_at'=>$now,
        'times_checked'=>(int)($r['times_checked'] ?? 0)+1,
      ];
    }

    $out(['ok'=>1,'rows'=>$rowsOut]);
  }

  $out(['error'=>'unknown action']);
} catch (Throwable $e) {
  http_response_code(200);
  while (ob_get_level()) { ob_end_clean(); }
  echo json_encode(['error'=>'fatal','message'=>$e->getMessage()]);
  exit;
}

/* --- Remap 17TRACK->La Poste for console --- */
if (isset($__provider_original) && $__provider_original === 'laposte') {
    if (isset($out['providers']['17track'])) {
        $out['providers']['laposte'] = $out['providers']['17track'];
        $out['providers']['laposte']['source'] = '17track_colissimo';
        unset($out['providers']['17track']);
    } elseif (!isset($out['providers']) && (isset($out['track']) || isset($out['raw']) || isset($out['status_code']))) {
        $raw = isset($out['raw']) ? $out['raw'] : $out;
        $out = [
            'ok' => isset($out['ok']) ? $out['ok'] : 1,
            'providers' => [
                'laposte' => [
                    'source'        => '17track_colissimo',
                    'status_code'   => isset($out['status_code']) ? $out['status_code'] : null,
                    'status_text'   => isset($out['status_text']) ? $out['status_text'] : null,
                    'last_event_at' => isset($out['last_event_at']) ? $out['last_event_at'] : null,
                    'delivered_at'  => isset($out['delivered_at']) ? $out['delivered_at'] : null,
                    'raw'           => $raw
                ]
            ]
        ];
    }
}
/* --- /Remap --- */