<?php
require_once '../includes/db.php';
require_once __DIR__ . '/auth_guard.php';
session_start();

// Vérifier que l'utilisateur est admin
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit();
}

// Vérifier paramètres
$commande_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$action = $_GET['action'] ?? '';

$statuts_valides = ['valider', 'annuler', 'refuser'];
if ($commande_id <= 0 || !in_array($action, $statuts_valides)) {
    header('Location: commandes.php?erreur=parametres');
    exit();
}

// Mettre à jour le statut
$stmt = $pdo->prepare("UPDATE commandes SET statut = ? WHERE id = ?");
$stmt->execute([$action, $commande_id]);

// Rediriger
header('Location: commandes.php?success=commande_' . $action);
exit();