<?php
session_start();
require_once '../includes/db.php';
require_once __DIR__ . '/auth_guard.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit();
}

if (isset($_GET['id']) && isset($_GET['action'])) {
    $telegram_id = intval($_GET['id']);
    $action = $_GET['action'] === 'ban' ? 1 : 0;

    $stmt = $pdo->prepare("UPDATE telegram_users SET is_banned = ? WHERE telegram_id = ?");
    $stmt->execute([$action, $telegram_id]);

    $msg = $action ? "Utilisateur banni avec succès." : "Utilisateur débanni avec succès.";
    $_SESSION['flash_message'] = $msg;
}

header('Location: clients.php');
exit();