<?php
session_start();
require_once '../includes/db.php';
require_once __DIR__ . '/auth_guard.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit();
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: produits.php?deleted=error");
    exit();
}

$id = intval($_GET['id']);

// Récupérer le chemin de l'image à supprimer
$stmt = $pdo->prepare("SELECT image FROM produits WHERE id = ?");
$stmt->execute([$id]);
$produit = $stmt->fetch();

if ($produit) {
    // Supprimer l’image si elle existe
    if (!empty($produit['image'])) {
        $image_path = '../' . $produit['image'];
        if (file_exists($image_path)) {
            unlink($image_path);
        }
    }

    // Supprimer de la base
    $stmt = $pdo->prepare("DELETE FROM produits WHERE id = ?");
    if ($stmt->execute([$id])) {
        header("Location: produits.php?deleted=success");
        exit();
    } else {
        header("Location: produits.php?deleted=error");
        exit();
    }
} else {
    header("Location: produits.php?deleted=error");
    exit();
}
?>