<?php
session_start();
require_once '../includes/db.php';
require_once __DIR__ . '/auth_guard.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit();
}

// Vérification du paramètre id
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header('Location: codes.php?error=invalid_id');
    exit();
}

$code_id = (int)$_GET['id'];

// Vérifie si le code existe
$stmt = $pdo->prepare("SELECT * FROM codes WHERE id = ?");
$stmt->execute([$code_id]);
$code = $stmt->fetch();

if (!$code) {
    header("Location: codes.php?error=not_found");
    exit();
}

// Supprime le code
$stmt = $pdo->prepare("DELETE FROM codes WHERE id = ?");
$stmt->execute([$code_id]);

header("Location: codes.php?success=suppression");
exit();
?>