<?php
session_start();

// Clear remember cookie and remove from store
$cookie_name = 'admin_remember';
$store_path  = __DIR__ . '/remember_tokens.json';

if (!empty($_COOKIE[$cookie_name])){
    $raw = $_COOKIE[$cookie_name];
    $hash = hash('sha256', $raw);
    if (file_exists($store_path)){
        $json = @file_get_contents($store_path);
        $data = json_decode($json, true);
        if (is_array($data)){
            $data = array_values(array_filter($data, function($item) use ($hash){
                return isset($item['token']) ? ($item['token'] !== $hash) : true;
            }));
            @file_put_contents($store_path, json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
        }
    }
    // expire cookie
    $secure = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on');
    setcookie($cookie_name, '', [
        'expires' => time() - 3600,
        'path'    => '/',
        'secure'  => $secure,
        'httponly'=> true,
        'samesite'=> 'Lax',
    ]);
}

session_unset();
session_destroy();
header('Location: index.php');
exit;
?>