<?php
session_start();
require_once '../includes/db.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    // Authentification simple (à adapter selon ton système)
    if ($username === 'admin' && $password === 'admin123') {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_username'] = $username;

        // Remember me (30 days)
        if (!empty($_POST['remember'])) {
            $cookie_name = 'admin_remember';
            $store_path  = __DIR__ . '/remember_tokens.json';
            if (!function_exists('_remember_store_read')){
                function _remember_store_read($store_path){
                    if (!file_exists($store_path)) return [];
                    $json = @file_get_contents($store_path);
                    if ($json === false) return [];
                    $data = json_decode($json, true);
                    return is_array($data) ? $data : [];
                }
                function _remember_store_write($store_path, $data){
                    // prune expired
                    $now = time();
                    $data = array_values(array_filter($data, function($item) use ($now){
                        return isset($item['expires']) && $item['expires'] > $now && isset($item['token']);
                    }));
                    @file_put_contents($store_path, json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
                }
            }

            $token = bin2hex(random_bytes(32));
            $hash  = hash('sha256', $token);
            $expires = time() + 30*24*3600;

            $store = _remember_store_read($store_path);
            $store[] = ['token' => $hash, 'expires' => $expires, 'username' => $username];
            _remember_store_write($store_path, $store);

            $secure = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on');
            $params = [
                'expires'  => $expires,
                'path'     => '/',
                'secure'   => $secure,
                'httponly' => true,
                'samesite' => 'Lax',
            ];
            setcookie($cookie_name, $token, $params);
        }

        header('Location: index.php');
        exit();
    } else {
        $error = 'Identifiants incorrects';
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Connexion Admin - MeltLabz</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>
<body class="hold-transition login-page">
<div class="login-box">
  <div class="card card-outline card-primary">
    <div class="card-header text-center">
      <a href="#" class="h1"><b>MeltLabz</b> Admin</a>
    </div>
    <div class="card-body">
      <p class="login-box-msg">Connecte-toi pour accéder à l'admin</p>

      <?php if ($error): ?>
        <div class="alert alert-danger alert-dismissible">
          <?= htmlspecialchars($error) ?>
        </div>
      <?php endif; ?>

      <form method="post">
        <div class="mb-3">
          <label>Nom d'utilisateur</label>
          <input type="text" name="username" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>Mot de passe</label>
          <input type="password" name="password" class="form-control" required>
        </div>
        <div class="form-check my-2">
  <input class="form-check-input" type="checkbox" name="remember" id="remember" value="1">
  <label class="form-check-label" for="remember">Se souvenir de moi (30 jours)</label>
</div>
<div class="row">
          <div class="col-12">
            <button type="submit" class="btn btn-primary w-100">Connexion</button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div><script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>