<?php require 'auth.php'; ?>
<?php
require_once '../includes/db.php';
require_once __DIR__ . '/auth_guard.php';

$message = "";
$generatedCodes = [];

// Créer le dossier uploads si nécessaire
$uploadDir = '../uploads/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $strain = trim($_POST["strain"]);
    $description = trim($_POST["description"]);
    $count = isset($_POST["count"]) ? max(1, intval($_POST["count"])) : 1;

    $imagePath = null;

    // Gérer l'upload d'image
    if (!empty($_FILES["image"]["name"])) {
        $allowedTypes = ['image/jpeg', 'image/png', 'image/webp'];
        $fileType = mime_content_type($_FILES["image"]["tmp_name"]);
        $fileSize = $_FILES["image"]["size"];

        if (!in_array($fileType, $allowedTypes)) {
            $message = "<div class='alert alert-danger'>❌ Type de fichier non autorisé.</div>";
        } elseif ($fileSize > 5 * 1024 * 1024) {
            $message = "<div class='alert alert-danger'>❌ Fichier trop volumineux (max 5MB).</div>";
        } else {
            $fileName = uniqid() . "_" . basename($_FILES["image"]["name"]);
            $targetFilePath = $uploadDir . $fileName;
            if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFilePath)) {
                $imagePath = 'uploads/' . $fileName;
            }
        }
    }

    if (!$message) {
        $stmt = $pdo->prepare("INSERT INTO codes (code, strain, description, image_path) VALUES (?, ?, ?, ?)");

        for ($i = 0; $i < $count; $i++) {
            $code = strtoupper(bin2hex(random_bytes(4)));
            $stmt->execute([$code, $strain, $description, $imagePath]);
            $generatedCodes[] = $code;
        }

        $message = "<div class='alert alert-success'>✅ " . count($generatedCodes) . " code(s) généré(s) avec succès.</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
<title>Générer un Code</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <style> body { background:#121212; color:white; } .form-control, .form-select { background:#1e1e1e; color:white; } </style>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link rel="stylesheet" href="assets/responsive-fixes.css">
</head>
<body>
<div class="container py-5">
  <h2 class="mb-4">🔐 Générer des codes de vérification</h2>
  <div class="mb-4">
    <a href="../index.php" class="btn btn-outline-light me-2">🏠 Accueil</a>
    <a href="codes.php" class="btn btn-outline-info">📄 Liste des codes</a>
  </div>
🔐 Générer des codes de vérification</h2>

  <?= $message ?>

  <?php if (!empty($generatedCodes)): ?>
    <div class="card bg-dark p-3 mb-4">
      <h5 class="text-success mb-3">📋 Codes générés :</h5>
      <ul class="text-light">
        <?php foreach ($generatedCodes as $i => $code): ?>
          <li><strong><?= $i+1 ?>.</strong> CODE : <?= htmlspecialchars($code) ?></li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>

  <form method="POST" enctype="multipart/form-data" class="bg-dark p-4 rounded shadow">
    <div class="mb-3">
      <label class="form-label">Nom de la variété</label>
      <input type="text" name="strain" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Description</label>
      <textarea name="description" class="form-control" rows="3" required></textarea>
    </div>
    <div class="mb-3">
      <label class="form-label">Image / Logo</label>
      <input type="file" name="image" accept="image/*" class="form-control">
    </div>
    <div class="mb-3">
      <label class="form-label">Nombre de codes à générer</label>
      <input type="number" name="count" class="form-control" value="1" min="1">
    </div>
    <button type="submit" class="btn btn-primary">Générer</button>
  </form>
</div><script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>