<?php require_once __DIR__ . '/auth_guard.php'; ?>
<?php
require '../includes/auth.php';
require '../includes/db.php';
require_admin();

if (!isset($_GET['id'])) {
    header('Location: codes.php');
    exit;
}

$id = $_GET['id'];
$stmt = $pdo->prepare("SELECT * FROM codes WHERE id = ?");
$stmt->execute([$id]);
$code = $stmt->fetch();

if (!$code) {
    echo "<p style='color: white; background-color: red; padding: 10px;'>Code introuvable.</p>";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $strain = $_POST['strain'];
    $desc = $_POST['description'];
    $stmt = $pdo->prepare("UPDATE codes SET strain = ?, description = ? WHERE id = ?");
    $stmt->execute([$strain, $desc, $id]);
    header("Location: codes.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
<title>Modifier le Code</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <style>
    body { background-color: #121212; color: #fff; }
    .card { background-color: #1f1f1f; border: none; }
    .btn-primary { background-color: #ffc107; border: none; color: #000; }
  </style>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link rel="stylesheet" href="assets/responsive-fixes.css">
</head>
<body class="p-4">
  <div class="container">
    <a href="codes.php" class="btn btn-secondary mb-3">← Retour à la liste des codes</a>
    <div class="card p-4 shadow">
      <h2 class="mb-4">Modifier le code : <?= htmlspecialchars($code['code']) ?></h2>
      <form method="POST">
        <div class="mb-3">
          <label for="strain" class="form-label">Variété</label>
          <input type="text" id="strain" name="strain" value="<?= htmlspecialchars($code['strain']) ?>" class="form-control" required>
        </div>
        <div class="mb-3">
          <label for="description" class="form-label">Description</label>
          <textarea id="description" name="description" class="form-control" rows="4" required><?= htmlspecialchars($code['description']) ?></textarea>
        </div>
        <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
      </form>
    </div>
  </div><script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>
