<?php
// delete_product.php — suppression produit (et prix liés) + tentative de suppression du fichier image
session_start();
require_once '../includes/db.php';
require_once __DIR__ . '/auth_guard.php';

function flash($type, $msg){
  $_SESSION['flash'] = ['type' => $type, 'msg' => $msg];
}

// Récupère l'ID depuis GET (ton lien actuel l’envoie ainsi)
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  flash('danger', "ID invalide.");
  header('Location: produits.php');
  exit;
}

try {
  // Récupérer le chemin d'image AVANT suppression (pour tentative de unlink)
  $st = $pdo->prepare("SELECT image FROM produits WHERE id = ?");
  $st->execute([$id]);
  $image = $st->fetchColumn();

  // Si le produit n'existe pas
  if ($image === false) {
    flash('warning', "Produit #{$id} introuvable.");
    header('Location: produits.php');
    exit;
  }

  $pdo->beginTransaction();

  // Supprimer les prix liés
  $stP = $pdo->prepare("DELETE FROM produit_prix WHERE produit_id = ?");
  $stP->execute([$id]);

  // Supprimer le produit
  $stD = $pdo->prepare("DELETE FROM produits WHERE id = ?");
  $stD->execute([$id]);

  $pdo->commit();

  // Tentative de suppression du fichier image si chemin relatif (pas http/https, pas / absolu, pas data:)
  if ($image) {
    $src = trim((string)$image);
    // On ne touche qu'aux chemins RELATIFS (ex: "uploads/xxx.jpg")
    if (!preg_match('~^(?:https?:)?/|^data:~i', $src)) {
      // On part de la racine du projet (admin/..)
      $root = realpath(dirname(__DIR__));
      if ($root) {
        $full = $root . DIRECTORY_SEPARATOR . ltrim($src, '/\\');
        $real = realpath($full);
        // Sécurité : on supprime seulement si le fichier résolu est bien dans $root
        if ($real !== false && strpos($real, $root) === 0 && is_file($real)) {
          @unlink($real);
        }
      }
    }
  }

  flash('success', "Produit #{$id} supprimé avec succès.");
} catch (Throwable $e) {
  if ($pdo->inTransaction()) { $pdo->rollBack(); }
  // Log interne possible: error_log($e->getMessage());
  flash('danger', "Erreur pendant la suppression (#{$id}) : " . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8'));
}

// Redirection finale vers la liste
header('Location: produits.php');
exit;
