<?php
session_start();
require_once '../includes/db.php';
require_once __DIR__ . '/auth_guard.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
  header('Location: login.php');
  exit();
}

// Récupération des commandes avec infos utilisateur et adresse
$stmt = $pdo->query("
  SELECT c.*, 
         tu.username, tu.photo_url, 
         a.nom, a.prenom, a.adresse, a.code_postal, a.telephone
  FROM commandes c
  LEFT JOIN telegram_users tu ON c.telegram_id = tu.telegram_id
  LEFT JOIN adresses a ON c.telegram_id = a.telegram_id
  ORDER BY c.date_commande DESC
");
$commandes = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Commandes</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link rel="stylesheet" href="assets/responsive-fixes.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
<nav class="main-header navbar navbar-expand navbar-white navbar-light">
  <ul class="navbar-nav">
    <li class="nav-item">
      <a class="nav-link" data-widget="pushmenu" href="#" role="button">☰</a>
    </li>
    <li class="nav-item d-sm-none d-block">
      <span class="navbar-text">MeltLabz Admin</span>
    </li>
  </ul>
</nav>
  <?php include 'sidebar.php'; ?>
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <h1 class="m-0">📦 Commandes clients</h1>
      </div>
    </div>
    <div class="content">
      <div class="container-fluid">
        <div class="card">
          <div class="card-body">
            <table id="commandesTable" class="table table-bordered table-hover">
              <thead>
                <tr>
                  <th>Avatar</th>
                  <th>@Telegram</th>
                  <th>Produits</th>
                  <th>Prix Total</th>
                  <th>Adresse</th>
                  <th>Actions</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($commandes as $commande): ?>
                  <tr>
                    <td>
                      <img src="<?= htmlspecialchars($commande['photo_url']) ?>" alt="avatar" width="40" class="rounded-circle">
                    </td>
                    <td>
                      @<?= htmlspecialchars($commande['username']) ?>
                      <br><small class="badge badge-secondary">ID: <?= $commande['telegram_id'] ?></small>
                    </td>
                    <td>
                      <?= nl2br(htmlspecialchars($commande['contenu'])) ?>
                    </td>
                    <td><strong><?= number_format($commande['total'], 2) ?> €</strong></td>
                    <td>
                      <?= htmlspecialchars($commande['prenom'] . ' ' . $commande['nom']) ?><br>
                      <?= htmlspecialchars($commande['adresse']) ?><br>
                      <?= htmlspecialchars($commande['code_postal']) ?><br>
                      <small><?= htmlspecialchars($commande['telephone']) ?></small>
                    </td>
                    <td>
                      <a href="traiter_commande.php?id=<?= $commande['id'] ?>&action=valider" class="btn btn-success btn-sm mb-1">✅ Valider</a><br>
                      <a href="traiter_commande.php?id=<?= $commande['id'] ?>&action=annuler" class="btn btn-warning btn-sm mb-1">⛔ Annuler</a><br>
                      <a href="traiter_commande.php?id=<?= $commande['id'] ?>&action=refuser" class="btn btn-danger btn-sm">❌ Refuser</a>
                    </td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Scripts --><script>
  $(document).ready(function () {
    $('#commandesTable').DataTable({
      language: {
        url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json'
      },
      pageLength: 10
    });
  });
</script><script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>