<?php
session_start();
require_once '../includes/db.php';
require_once __DIR__ . '/auth_guard.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit();
}

$limit = 10;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $limit;
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$params = [];

$sql = "SELECT * FROM codes";
$countSql = "SELECT COUNT(*) FROM codes";

if ($search !== '') {
    $sql .= " WHERE code LIKE :s OR strain LIKE :s OR description LIKE :s";
    $countSql .= " WHERE code LIKE :s OR strain LIKE :s OR description LIKE :s";
    $params['s'] = '%' . $search . '%';
}

$sql .= " ORDER BY created_at DESC LIMIT :limit OFFSET :offset";

$stmt = $pdo->prepare($sql);
foreach ($params as $k => $v) $stmt->bindValue(":$k", $v);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$codes = $stmt->fetchAll(PDO::FETCH_ASSOC);

$stmtCount = $pdo->prepare($countSql);
foreach ($params as $k => $v) $stmtCount->bindValue(":$k", $v);
$stmtCount->execute();
$totalRows = $stmtCount->fetchColumn();
$totalPages = ceil($totalRows / $limit);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Gérer les codes - MeltLabz</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
  <style>
    .table-responsive { margin-top: 20px; }
    .code-img { height: 40px; border-radius: 4px; }
    .search-input { max-width: 400px; margin-bottom: 15px; }
    .pagination .page-link { padding: 5px 12px; }
  </style>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link rel="stylesheet" href="assets/responsive-fixes.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <ul class="navbar-nav">
      <li class="nav-item"><a class="nav-link" data-widget="pushmenu" href="#"><i class="fas fa-bars"></i></a></li>
    </ul>
  </nav>

  <!-- Sidebar -->
<?php include 'sidebar.php'; ?>

  <!-- Content -->
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <h1 class="m-0">📋 Liste des codes</h1>
        <input type="text" id="search" class="form-control search-input" placeholder="🔍 Rechercher un code, strain, description...">
      </div>
    </div>

    <div class="content">
      <div class="container-fluid" id="results">
        <div class="table-responsive">
          <table class="table table-bordered table-hover table-striped" id="codesTable">
            <thead class="table-dark">
              <tr>
                <th>🔢 Code</th>
                <th>🌿 Strain</th>
                <th>📝 Description</th>
                <th>📷 Image</th>
                <th>📅 Créé le</th>
                <th>👁️ Vérifications</th>
                <th>⚙️ Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($codes as $code): ?>
                <tr>
                  <td><?= htmlspecialchars($code['code']) ?></td>
                  <td><?= htmlspecialchars($code['strain']) ?></td>
                  <td style="max-width: 250px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
  <?= htmlspecialchars($code['description']) ?>
</td>
                  <td>
                    <?php if ($code['image_path']): ?>
                      <img src="../<?= htmlspecialchars($code['image_path']) ?>" class="code-img">
                    <?php else: ?>
                      <span class="text-muted">Aucune</span>
                    <?php endif; ?>
                  </td>
                  <td><?= date('d/m/Y H:i', strtotime($code['created_at'])) ?></td>
                  <td><span class="badge bg-primary"><?= intval($code['verification_count']) ?></span></td>
                  <td>
                    <a href="modifier_code.php?id=<?= $code['id'] ?>" class="btn btn-sm btn-secondary"><i class="fas fa-edit"></i></a>
                    <a href="supprimer_code.php?id=<?= $code['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Supprimer ce code ?')"><i class="fas fa-trash"></i></a>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
          <?php if (count($codes) === 0): ?>
            <div class="alert alert-warning">Aucun code trouvé pour le moment.</div>
          <?php endif; ?>

          <!-- Pagination -->
          <nav>
            <ul class="pagination justify-content-center">
              <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <li class="page-item <?= $i == $page ? 'active' : '' ?>">
                  <a href="?page=<?= $i ?>&search=<?= urlencode($search) ?>" class="page-link"><?= $i ?></a>
                </li>
              <?php endfor; ?>
            </ul>
          </nav>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Scripts --><script>
$(document).ready(function () {
  function fetchData(page = 1) {
    const query = $('#search').val();
    $.get('codes.php', { search: query, page: page }, function (data) {
      const html = $(data).find('#results').html();
      $('#results').html(html);
    });
  }

  $('#search').on('input', function () {
    fetchData(1);
  });

  $(document).on('click', '.pagination .page-link', function (e) {
    e.preventDefault();
    const page = $(this).text();
    fetchData(page);
  });
});
</script><script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>