<?php
session_start();
require_once '../includes/db.php';
require_once __DIR__ . '/auth_guard.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit();
}

$success = "";
$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nom = trim($_POST['nom']);
    $description = trim($_POST['description']);
    $farm = trim($_POST['farm']);
    $categorie = trim($_POST['categorie']);

    // Image principale
    $image_path = null;
    if (!empty($_FILES['image_principale']['name'])) {
        $target_dir = '../uploads/';
        if (!is_dir($target_dir)) mkdir($target_dir);
        $filename = time() . '_main_' . basename($_FILES['image_principale']['name']);
        $full_path = $target_dir . $filename;
        $relative_path = 'uploads/' . $filename;

        if (move_uploaded_file($_FILES['image_principale']['tmp_name'], $full_path)) {
            $image_path = $relative_path;
        } else {
            $error = "❌ Upload de l'image principale échoué.";
        }
    }

    if (!$error) {
        $stmt = $pdo->prepare("INSERT INTO produits (nom, description, image, farm, categorie) VALUES (?, ?, ?, ?, ?)");
        if ($stmt->execute([$nom, $description, $image_path, $farm, $categorie])) {
            $produit_id = $pdo->lastInsertId();

            // Upload fichiers multiples
            $total_files = count($_FILES['medias']['name']);
            for ($i = 0; $i < $total_files; $i++) {
                $file_tmp  = $_FILES['medias']['tmp_name'][$i];
                $file_name = time() . '_' . basename($_FILES['medias']['name'][$i]);
                $target_dir = '../uploads/';
                $file_path = $target_dir . $file_name;
                $relative_path = 'uploads/' . $file_name;
                $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
                $type = in_array($ext, ['mp4', 'webm', 'mov']) ? 'video' : 'image';

                if (move_uploaded_file($file_tmp, $file_path)) {
                    $pdo->prepare("INSERT INTO produit_medias (produit_id, media_path, type) VALUES (?, ?, ?)")
                        ->execute([$produit_id, $relative_path, $type]);
                }
            }

            // Quantité / prix
            if (!empty($_POST['quantite']) && !empty($_POST['prix'])) {
                foreach ($_POST['quantite'] as $index => $qte) {
                    $prix = $_POST['prix'][$index];
                    if ($qte && $prix) {
                        $pdo->prepare("INSERT INTO produit_prix (produit_id, quantite, prix) VALUES (?, ?, ?)")
                            ->execute([$produit_id, $qte, $prix]);
                    }
                }
            }

            $success = "✅ Produit ajouté avec succès.";
        } else {
            $error = "❌ Erreur lors de l'insertion du produit.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
<title>Ajouter un produit</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link rel="stylesheet" href="assets/responsive-fixes.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
<nav class="main-header navbar navbar-expand navbar-white navbar-light">
  <ul class="navbar-nav">
    <li class="nav-item">
      <a class="nav-link" data-widget="pushmenu" href="#" role="button">☰</a>
    </li>
    <li class="nav-item d-sm-none d-block">
      <span class="navbar-text">MeltLabz Admin</span>
    </li>
  </ul>
</nav>

  <?php include 'sidebar.php'; ?>

  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <h1 class="m-0">➕ Ajouter un produit</h1>
      </div>
    </div>

    <div class="content">
      <div class="container-fluid">

        <?php if ($error): ?>
          <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php elseif ($success): ?>
          <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
        <?php endif; ?>

        <div class="card card-light p-4">
          <form method="post" enctype="multipart/form-data">
            <div class="row g-3">
              <div class="col-md-6">
                <label class="form-label">Nom du produit</label>
                <input type="text" name="nom" class="form-control" required>
              </div>
              <div class="col-md-6">
                <label class="form-label">Farm</label>
                <input type="text" name="farm" class="form-control" required>
              </div>

              <div class="col-md-6">
                <label class="form-label">Catégorie</label>
                <select name="categorie" class="form-select" required>
                  <option value="">-- Choisir --</option>
                  <option value="piatella">piatella</option>
                  <option value="wpff">wpff</option>
                  <option value="la mousse">la mousse</option>
                  <option value="iceolator">iceolator</option>
                  <option value="accessoires">accessoires</option>
                </select>
              </div>

              <div class="col-md-6">
                <label class="form-label">Médias (images/vidéos)</label>
                <input type="file" name="medias[]" class="form-control" accept="image/*,video/*" multiple required>
              </div>

              <div class="col-md-12">
                <label class="form-label">Image principale (logo/aperçu)</label>
                <input type="file" name="image_principale" class="form-control" accept="image/*" required>
              </div>

              <div class="col-12">
                <label class="form-label">Description</label>
                <textarea name="description" class="form-control" rows="4" required></textarea>
              </div>

              <div class="col-12">
                <label class="form-label">Quantité & Prix</label>
                <div id="prix-container">
                  <div class="row g-2 mb-2">
                    <div class="col-5">
                      <input type="text" name="quantite[]" class="form-control" placeholder="Ex: 3g">
                    </div>
                    <div class="col-5">
                      <input type="number" name="prix[]" step="0.01" class="form-control" placeholder="Prix en ฿">
                    </div>
                    <div class="col-2">
                      <button type="button" class="btn btn-outline-danger w-100 remove-row">🗑️</button>
                    </div>
                  </div>
                </div>
                <button type="button" id="add-prix" class="btn btn-sm btn-outline-secondary mt-2">➕ Ajouter une ligne</button>
              </div>

              <div class="col-12 text-end">
                <button type="submit" class="btn btn-dark px-4">✅ Ajouter</button>
              </div>
            </div>
          </form>
        </div>

        <footer class="text-center mt-4 text-muted small">
          &copy; <?= date('Y') ?> MeltLabz
        </footer>

      </div>
    </div>
  </div>
</div>

<script>
  document.getElementById('add-prix').addEventListener('click', function () {
    const row = document.createElement('div');
    row.className = "row g-2 mb-2";
    row.innerHTML = `
      <div class="col-5">
        <input type="text" name="quantite[]" class="form-control" placeholder="Ex: 5g">
      </div>
      <div class="col-5">
        <input type="number" name="prix[]" step="0.01" class="form-control" placeholder="Prix en ฿">
      </div>
      <div class="col-2">
        <button type="button" class="btn btn-outline-danger w-100 remove-row">🗑️</button>
      </div>`;
    document.getElementById('prix-container').appendChild(row);
  });

  document.addEventListener('click', function (e) {
    if (e.target.classList.contains('remove-row')) {
      e.target.closest('.row').remove();
    }
  });
</script><script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>