<?php
session_start();
require_once '../includes/db.php';
require_once __DIR__ . '/auth_guard.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit();
}

$messages = [];
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $strain = trim($_POST['strain']);
        $description = trim($_POST['description']);
        $count = max(1, intval($_POST['count']));

        $image_path = null;
        if (!empty($_FILES['image']['name'])) {
            $target_dir = '../uploads/';
            if (!is_dir($target_dir)) mkdir($target_dir);
            $filename = time() . '_' . basename($_FILES['image']['name']);
            $target_file = $target_dir . $filename;
            if (move_uploaded_file($_FILES['image']['tmp_name'], $target_file)) {
                $image_path = 'uploads/' . $filename;
            }
        }

        $inserted = [];
        for ($i = 0; $i < $count; $i++) {
            $code = strtoupper(bin2hex(random_bytes(4)));
            $stmt = $pdo->prepare("INSERT INTO codes (code, strain, description, image_path, created_at, verification_count) VALUES (?, ?, ?, ?, NOW(), 0)");
            $stmt->execute([$code, $strain, $description, $image_path]);
            $inserted[] = $code;
        }

        $messages = $inserted;
    } catch (Exception $e) {
        $error = 'Erreur : ' . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
<title>Ajouter un code - MeltLabz</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
  <style>
    .card-code { position: relative; }
    .card-code .close-btn {
      position: absolute;
      top: 5px;
      right: 10px;
      background: transparent;
      border: none;
      color: white;
      font-size: 20px;
      cursor: pointer;
    }
  </style>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link rel="stylesheet" href="assets/responsive-fixes.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#"><i class="fas fa-bars"></i></a>
      </li>
    </ul>
  </nav>

<?php include 'sidebar.php'; ?>

  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <h1 class="m-0 animate__animated animate__fadeInDown">➕ Générer des codes d'authenticité</h1>
      </div>
    </div>

    <div class="content">
      <div class="container-fluid">
        <?php if ($error): ?>
          <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <div class="card card-light mb-4">
          <div class="card-body">
            <form method="post" enctype="multipart/form-data">
              <div class="mb-3">
                <label class="form-label">Strain 🌿</label>
                <input type="text" name="strain" class="form-control" required>
              </div>
              <div class="mb-3">
                <label class="form-label">Description 📝</label>
                <textarea name="description" class="form-control" rows="5" required></textarea>
              </div>
              <div class="mb-3">
                <label class="form-label">Image (facultative) 🖼️</label>
                <input type="file" name="image" class="form-control">
              </div>
              <div class="mb-3">
                <label class="form-label">Nombre de codes à générer 🔁</label>
                <input type="number" name="count" class="form-control" value="1" min="1">
              </div>
              <div class="mb-3">
                <button type="submit" class="btn btn-success w-100">🚀 Générer</button>
              </div>
            </form>
          </div>
          
        </div>

        <?php if (!empty($messages)): ?>
          <div class="row">
            <?php foreach ($messages as $msg): ?>
              <div class="col-md-4" id="code-card-<?= $msg ?>">
                <div class="card card-code bg-success text-white animate__animated animate__fadeInUp mb-3">
                  <button class="close-btn" onclick="document.getElementById('code-card-<?= $msg ?>').remove();">&times;</button>
                  <div class="card-body">
                    <h5 class="card-title">✅ Code généré :</h5>
                    <h3 class="card-text"><?= htmlspecialchars($msg) ?></h3>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div><script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
</body>
</html>