<?php
// admin/colis.php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/includes/tracking_providers.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
  header('Location: login.php'); exit;
}
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

/* Helpers */
function e($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function try_inc(array $rel){ foreach ($rel as $f){ $p=__DIR__.'/'.$f; if (is_file($p)){ include $p; return true; } } return false; }
function badge_class($code){
  $c=strtoupper((string)$code);
  if ($c==='DELIVERED') return 'bg-success';
  if ($c==='IN_TRANSIT')return 'bg-primary';
  if (in_array($c,['CUSTOMS','EXCEPTION','NOT_FOUND'])) return 'bg-danger';
  return 'bg-secondary';
}

/* Touchdown stats */
$stat = ['total'=>0,'delivered'=>0,'in_transit'=>0,'customs'=>0,'exception'=>0,'not_found'=>0,'pending'=>0,'unknown'=>0];
$rowsStat = $pdo->query("SELECT status_code, COUNT(*) c FROM colis GROUP BY status_code")->fetchAll(PDO::FETCH_ASSOC);
foreach ($rowsStat as $r){ $k=strtolower($r['status_code']??'unknown'); $c=(int)$r['c']; $stat['total']+=$c; if(isset($stat[$k]))$stat[$k]+=$c; }
$total=$stat['total']; $del=$stat['delivered']; $inT=$stat['in_transit'];
$issues=$stat['customs']+$stat['exception']+$stat['not_found']+$stat['unknown']; $pend=$stat['pending'];
$pct = $total? round($del*100/$total):0; $ratioCls = $pct>=80?'bg-success':($pct>=50?'bg-warning':'bg-danger');

/* Data */
$items = $pdo->query("SELECT * FROM colis ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

/* URL API ABSOLUE (basée sur /14s4gAjpCa8o/) */
$ROOT_BASE = rtrim(dirname(dirname($_SERVER['SCRIPT_NAME'])), '/'); // ex: /14s4gAjpCa8o
$API_URL   = $ROOT_BASE . '/api/colis_actions.php';
?><!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="utf-8">
  <title>Tracking Colis</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Si ton layout inclut déjà CSS/JS, tu peux retirer ces CDN -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

  <style>
    .table td,.table th{vertical-align:middle}
    .addr-col{max-width:420px; white-space:pre-wrap}
    .note-input{min-width:220px}
    .status-badge{font-size:.85rem}
    .small-box .progress{height:6px;margin-top:.5rem}
    pre.apiout{max-height:360px; overflow:auto; background:#111; color:#ddd; padding:12px; border-radius:6px}
  </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <?php
    // Inclus ton menu / header comme sur produits.php si présent
    try_inc(['_navbar.php','navbar.php','partials/navbar.php','layout/navbar.php','header.php','_top.php'])
    || print('<nav class="main-header navbar navbar-expand navbar-white navbar-light"><ul class="navbar-nav"><li class="nav-item"><a class="nav-link" data-widget="pushmenu" href="#"><i class="fas fa-bars"></i></a></li></ul><span class="ml-3 font-weight-bold">Tracking Colis</span></nav>');

    try_inc(['_sidebar.php','sidebar.php','partials/sidebar.php','layout/sidebar.php','menu.php'])
    || print('<aside class="main-sidebar sidebar-dark-primary elevation-4"><a href="#" class="brand-link"><span class="brand-text font-weight-light">Admin</span></a><div class="sidebar"></div></aside>');
  ?>

  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6"><h1>📦 Tracking Colis</h1></div>
          <div class="col-sm-6"><ol class="breadcrumb float-sm-right"><li class="breadcrumb-item"><a href="/admin/index.php">Home</a></li><li class="breadcrumb-item active">Tracking Colis</li></ol></div>
        </div>
      </div>
    </section>

    <section class="content">
      <div class="container-fluid">

        <!-- KPI -->
        <div class="row">
          <div class="col-lg-3 col-6">
            <div id="box-touchdown" class="small-box <?= $ratioCls ?>">
              <div class="inner">
                <h3 id="td-pct"><?= $pct ?><sup style="font-size:20px">%</sup></h3>
                <p>Touchdown Ratio — % livrés</p>
                <div class="progress"><div id="td-bar" class="progress-bar" style="width:<?= $pct ?>%"></div></div>
                <small id="td-caption"><?= $del ?> / <?= $total ?> livrés</small>
              </div>
              <div class="icon"><i class="fas fa-check-circle"></i></div>
              <span class="small-box-footer">Actualisé après chaque suivi</span>
            </div>
          </div>
          <div class="col-lg-3 col-6"><div class="small-box bg-success"><div class="inner"><h3 id="td-delivered"><?= $del ?></h3><p>Livrés</p></div><div class="icon"><i class="fas fa-box-check"></i></div></div></div>
          <div class="col-lg-3 col-6"><div class="small-box bg-primary"><div class="inner"><h3 id="td-intransit"><?= $inT ?></h3><p>En cours</p></div><div class="icon"><i class="fas fa-truck"></i></div></div></div>
          <div class="col-lg-3 col-6"><div class="small-box bg-danger"><div class="inner"><h3 id="td-issues"><?= $issues ?></h3><p>Douane / Non livré / Erreurs</p></div><div class="icon"><i class="fas fa-exclamation-triangle"></i></div><span class="small-box-footer">En attente: <b id="td-pending"><?= $pend ?></b></span></div></div>
        </div>

        <!-- API Self-Test -->
        <div class="row">
          <div class="col-12">
            <div class="card card-outline card-warning">
              <div class="card-header"><h3 class="card-title">API Self-Test (ThaiPost & 17TRACK)</h3></div>
              <div class="card-body">
                <div class="form-row">
                  <div class="form-group col-md-4">
                    <label>Numéro ThaiPost (ex: EX123456789TH)</label>
                    <input id="tp-num" class="form-control" placeholder="EX123456789TH">
                  </div>
                  <div class="form-group col-md-4">
                    <label>Numéro 17TRACK (ex: RR123456789CN)</label>
                    <input id="s17-num" class="form-control" placeholder="RR123456789CN">
                  </div>
                  <div class="form-group col-md-4 d-flex align-items-end">
                    <button id="btn-selftest" class="btn btn-warning"><i class="fas fa-vial mr-1"></i>Lancer le test</button>
                    <span id="selftest-status" class="ml-3 text-muted"></span>
                  </div>
                </div>
                <pre class="apiout mt-3" id="selftest-out" hidden></pre>
              </div>
            </div>
          </div>
        </div>

        <!-- Ajouter un colis -->
        <div class="row">
          <div class="col-12">
            <div class="card card-outline card-primary">
              <div class="card-header"><h3 class="card-title">Ajouter un colis</h3></div>
              <div class="card-body">
                <form method="post" class="form">
                  <input type="hidden" name="add_colis" value="1">
                  <div class="form-row">
                    <div class="form-group col-md-3"><label>Numéro de suivi</label><input name="tracking_number" class="form-control" required></div>
                    <div class="form-group col-md-3"><label>API</label>
                      <select name="api_choice" class="form-control">
                        <option value="auto">Auto</option><option value="thaipost">ThaiPost</option><option value="17track">17Track</option><option value="laposte">La Poste</option><option value="all">Tous (3)</option>
                      </select>
                    </div>
                    <div class="form-group col-md-3"><label>Prénom</label><input name="first_name" class="form-control"></div>
                    <div class="form-group col-md-3"><label>Nom</label><input name="last_name" class="form-control"></div>
                    <div class="form-group col-md-6"><label>Adresse</label><textarea name="address" rows="2" class="form-control"></textarea></div>
                    <div class="form-group col-md-6"><label>Note</label><textarea name="note" rows="2" class="form-control"></textarea></div>
                  </div>
                  <button class="btn btn-primary"><i class="fas fa-plus-circle mr-1"></i>Ajouter</button>
                </form>
                <?php
                if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['add_colis'])) {
                  $st = $pdo->prepare("INSERT INTO colis (tracking_number, api_choice, first_name, last_name, address, note) VALUES (:t,:api,:fn,:ln,:ad,:no)");
                  $st->execute([':t'=>trim($_POST['tracking_number']??''), ':api'=>$_POST['api_choice']??'auto', ':fn'=>trim($_POST['first_name']??''), ':ln'=>trim($_POST['last_name']??''), ':ad'=>trim($_POST['address']??''), ':no'=>trim($_POST['note']??'') ]);
                  echo '<div class="mt-2 text-success">Ajouté ✅ — recharge la page pour voir la ligne.</div>';
                }
                ?>
              </div>
            </div>
          </div>
        </div>

        <!-- Table + Bulk refresh -->
        <div class="row">
          <div class="col-12">
            <div class="card card-outline card-secondary">
              <div class="card-header d-flex align-items-center flex-wrap">
                <h3 class="card-title mr-3">Suivis</h3>
                <div class="ml-auto d-flex align-items-center flex-wrap">
                  <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="bulk_api" id="api_use_row" value="__row__" checked><label class="form-check-label" for="api_use_row">API par ligne</label></div>
                  <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="bulk_api" value="thaipost" id="api_tp"><label class="form-check-label" for="api_tp">ThaiPost</label></div>
                  <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="bulk_api" value="17track" id="api_17"><label class="form-check-label" for="api_17">17Track</label></div>
                  <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="bulk_api" value="laposte" id="api_lp"><label class="form-check-label" for="api_lp">La Poste</label></div>
                  <div class="form-check form-check-inline"><input class="form-check-input" type="radio" name="bulk_api" value="all" id="api_all"><label class="form-check-label" for="api_all">Tous (3)</label></div>
                  <button id="btn-refresh" class="btn btn-outline-primary btn-sm ml-3"><i class="fas fa-sync-alt mr-1"></i>Actualiser le tracking</button>
                  <span id="refresh-status" class="ml-2 text-muted small"></span>
                </div>
              </div>

              <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap align-middle" id="tbl-colis">
                  <thead class="table-light">
                    <tr>
                      <th style="width:36px"><input type="checkbox" id="chk-all"></th>
                      <th style="width:60px">ID</th>
                      <th>Numéro</th>
                      <th style="width:160px">API</th>
                      <th>Prénom / Nom</th>
                      <th style="min-width:320px">Adresse</th>
                      <th style="min-width:220px">Note</th>
                      <th style="min-width:260px">Statut</th>
                      <th>Dernier évènement</th>
                      <th>Vérifié</th>
                      <th style="width:120px">Actions</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php foreach ($items as $r): $badge=badge_class($r['status_code']); ?>
                      <tr data-id="<?= (int)$r['id'] ?>">
                        <td><input type="checkbox" class="rowchk"></td>
                        <td><?= (int)$r['id'] ?></td>
                        <td><code><?= e($r['tracking_number']) ?></code></td>
                        <td>
                          <select class="form-control form-control-sm api-choice">
                            <?php $apis=['auto'=>'Auto','thaipost'=>'ThaiPost','17track'=>'17Track','laposte'=>'La Poste','all'=>'Tous (3)'];
                              foreach($apis as $k=>$label){ $sel=($k===($r['api_choice']??'auto'))?'selected':''; echo "<option value=\"$k\" $sel>$label</option>"; } ?>
                          </select>
                        </td>
                        <td><?= e(trim(($r['first_name']??'').' '.($r['last_name']??''))) ?></td>
                        <td class="addr-col"><?= nl2br(e($r['address']??'')) ?></td>
                        <td><textarea class="form-control form-control-sm note-input" rows="1"><?= e($r['note']??'') ?></textarea></td>
                        <td>
                          <div class="d-flex align-items-center">
                            <span class="badge status-badge <?= $badge ?>">
                              <?= e($r['status_code']) ?><?= $r['status_text']?' · '.e($r['status_text']):'' ?>
                            </span>
                            <select class="form-control form-control-sm status-select ml-2" style="max-width:150px">
                              <?php foreach (['PENDING','IN_TRANSIT','DELIVERED','CUSTOMS','EXCEPTION','NOT_FOUND','UNKNOWN'] as $s): ?>
                                <option <?= $s===($r['status_code']??'')?'selected':'' ?>><?= $s ?></option>
                              <?php endforeach; ?>
                            </select>
                          </div>
                        </td>
                        <td><?= e($r['last_event_at'] ?? '—') ?></td>
                        <td><small><?= e($r['last_checked_at'] ?? '—') ?></small><br><small class="text-muted"><?= (int)$r['times_checked'] ?>×</small></td>
                        <td>
                          <div class="btn-group btn-group-sm">
                            <button class="btn btn-outline-success btn-save" title="Sauver"><i class="fas fa-save"></i></button>
                            <button class="btn btn-outline-secondary btn-one-refresh" title="Actualiser"><i class="fas fa-sync-alt"></i></button>
                          </div>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div><!-- /.card-body -->
            </div>
          </div>
        </div>

      </div>
    </section>
  </div>

  <?php if (!try_inc(['_footer.php','footer.php','partials/footer.php','layout/footer.php'])): ?>
    <footer class="main-footer"><strong>&copy; <?= date('Y') ?></strong><div class="float-right d-none d-sm-inline-block">MeltLabz Admin</div></footer>
  <?php endif; ?>
</div>

<!-- JS -->
<script>const API_URL = '<?= $API_URL ?>';</script>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>

<script>
const $ = (s, el=document) => el.querySelector(s);
const $all = (s, el=document) => Array.from(el.querySelectorAll(s));

/* Check-all */
$('#chk-all')?.addEventListener('change', (e)=>{
  $all('#tbl-colis tbody .rowchk').forEach(ch => ch.checked = e.target.checked);
});

/* Ajax helpers */
async function postJSON(url, data) {
  const r = await fetch(url, { method:'POST', headers:{'Content-Type':'application/json'}, body:JSON.stringify(data) });
  if (!r.ok) throw new Error('HTTP '+r.status);
  return await r.json();
}
function rowPayload(tr){
  return { id:Number(tr.dataset.id), api_choice:tr.querySelector('.api-choice').value, note:tr.querySelector('.note-input').value, status_code:tr.querySelector('.status-select').value };
}
function applyRowUpdate(tr, data) {
  const badge = tr.querySelector('.status-badge');
  if (data.status_code) {
    const cls = {DELIVERED:'bg-success',IN_TRANSIT:'bg-primary',CUSTOMS:'bg-danger',EXCEPTION:'bg-danger',NOT_FOUND:'bg-danger',UNKNOWN:'bg-secondary',PENDING:'bg-secondary'}[data.status_code] || 'bg-secondary';
    badge.className = 'badge status-badge ' + cls;
    badge.textContent = data.status_code + (data.status_text ? (' · ' + data.status_text) : '');
    tr.querySelector('.status-select').value = data.status_code;
  }
  if (data.last_event_at) tr.children[8].textContent = data.last_event_at;
  if (data.last_checked_at || data.times_checked !== undefined) {
    tr.children[9].innerHTML = `<small>${data.last_checked_at ?? '—'}</small><br><small class="text-muted">${data.times_checked ?? 0}×</small>`;
  }
}

/* Touchdown recalcul depuis DOM */
function recalcTouchdownFromTable() {
  const trs = $all('#tbl-colis tbody tr');
  let total=0, delivered=0, inTransit=0, issues=0, pending=0;
  trs.forEach(tr=>{
    total++;
    const s = (tr.querySelector('.status-select')?.value || 'UNKNOWN').toUpperCase();
    if (s==='DELIVERED') delivered++;
    else if (s==='IN_TRANSIT') inTransit++;
    else if (s==='PENDING') pending++;
    else if (['CUSTOMS','EXCEPTION','NOT_FOUND','UNKNOWN'].includes(s)) issues++;
  });
  const pct = total ? Math.round(delivered*100/total) : 0;
  const box = $('#box-touchdown');
  const cls = pct>=80?'bg-success':(pct>=50?'bg-warning':'bg-danger');
  if (box) box.className = 'small-box ' + cls;
  $('#td-pct').innerHTML = pct + '<sup style="font-size:20px">%</sup>';
  $('#td-bar').style.width = pct + '%';
  $('#td-caption').textContent = `${delivered} / ${total} livrés`;
  $('#td-delivered').textContent = delivered;
  $('#td-intransit').textContent = inTransit;
  $('#td-issues').textContent = issues;
  $('#td-pending').textContent = pending;
}

/* Save */
$all('.btn-save').forEach(btn=>{
  btn.addEventListener('click', async (e)=>{
    const tr = e.target.closest('tr');
    try {
      const res = await postJSON(API_URL, {action:'save', ...rowPayload(tr)});
      applyRowUpdate(tr, res.row || {}); recalcTouchdownFromTable();
    } catch(err){ alert('Erreur save: '+err.message); }
  });
});

/* One refresh */
$all('.btn-one-refresh').forEach(btn=>{
  btn.addEventListener('click', async (e)=>{
    const tr = e.target.closest('tr');
    const payload = rowPayload(tr);
    const bulkApi = document.querySelector('input[name="bulk_api"]:checked')?.value || '__row__';
    const api = (bulkApi==='__row__') ? payload.api_choice : bulkApi;
    try {
      const res = await postJSON(API_URL, {action:'refresh', ids:[payload.id], api_choice:api});
      if (res.rows && res.rows[payload.id]) { applyRowUpdate(tr, res.rows[payload.id]); recalcTouchdownFromTable(); }
    } catch(err){ alert('Erreur refresh: '+err.message); }
  });
});

/* Bulk refresh */
$('#btn-refresh')?.addEventListener('click', async ()=>{
  const ids=[]; $all('#tbl-colis tbody tr').forEach(tr=>{ if (tr.querySelector('.rowchk').checked) ids.push(Number(tr.dataset.id)); });
  if (!ids.length) return alert('Sélectionne au moins une ligne.');
  $('#refresh-status').textContent = 'Actualisation en cours...';
  const bulkApi = document.querySelector('input[name="bulk_api"]:checked')?.value || '__row__';
  try {
    const res = await postJSON(API_URL, {action:'refresh', ids, api_choice:bulkApi});
    for (const id of ids){ const tr=document.querySelector(`tr[data-id="${id}"]`); if (tr && res.rows && res.rows[id]) applyRowUpdate(tr, res.rows[id]); }
    $('#refresh-status').textContent = 'OK'; recalcTouchdownFromTable();
  } catch(err){ $('#refresh-status').textContent = 'Erreur'; alert('Erreur refresh: '+err.message); }
});

/* Self-test */
$('#btn-selftest')?.addEventListener('click', async ()=>{
  const tp = $('#tp-num')?.value.trim() || '';
  const s17 = $('#s17-num')?.value.trim() || '';
  if (!tp && !s17) return alert('Mets au moins un numéro.');
  $('#selftest-status').textContent = 'Test en cours...';
  $('#selftest-out').hidden = true;
  try {
    const r = await postJSON(API_URL, {action:'selftest', thaipost:tp, seventeen:s17});
    $('#selftest-status').textContent = 'OK';
    $('#selftest-out').textContent = JSON.stringify(r, null, 2);
    $('#selftest-out').hidden = false;
  } catch (err){
    $('#selftest-status').textContent = 'Erreur';
    $('#selftest-out').textContent = 'FAIL: '+err.message;
    $('#selftest-out').hidden = false;
  }
});

/* Init */
document.addEventListener('DOMContentLoaded', recalcTouchdownFromTable);
</script>
</body>
</html>