<?php
// /api/colis_actions.php
declare(strict_types=1);

session_start();
require_once __DIR__ . '/../../includes/db.php';
require_once __DIR__ . '/../admin/auth_guard.php'; // protège l'API par session admin
require_once __DIR__ . '/../includes/tracking_providers.php';

header('Content-Type: application/json; charset=utf-8');

$raw = file_get_contents('php://input');
$req = json_decode($raw, true) ?: [];
$action = $req['action'] ?? '';

function out($a){ echo json_encode($a, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

/* ===== Save row ===== */
if ($action === 'save') {
  $id = (int)($req['id'] ?? 0);
  if ($id<=0) out(['error'=>'bad id']);

  $st = $pdo->prepare("UPDATE colis SET api_choice=:api, note=:note, status_code=:sc WHERE id=:id");
  $st->execute([
    ':api' => $req['api_choice'] ?? 'auto',
    ':note'=> $req['note'] ?? '',
    ':sc'  => $req['status_code'] ?? 'PENDING',
    ':id'  => $id,
  ]);
  $row = $pdo->query("SELECT * FROM colis WHERE id={$id}")->fetch(PDO::FETCH_ASSOC);
  out(['ok'=>1,'row'=>$row]);
}

/* ===== Refresh N rows ===== */
if ($action === 'refresh') {
  $ids = $req['ids'] ?? [];
  if (!is_array($ids) || !count($ids)) out(['error'=>'no ids']);
  $overrideApi = $req['api_choice'] ?? '__row__';

  $ph = implode(',', array_fill(0, count($ids), '?'));
  $st = $pdo->prepare("SELECT * FROM colis WHERE id IN ($ph)");
  $st->execute(array_map('intval',$ids));
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);

  $rowsOut = [];
  foreach ($rows as $r) {
    $id  = (int)$r['id'];
    $api = ($overrideApi==='__row__') ? ($r['api_choice'] ?: 'auto') : $overrideApi;
    $tn  = $r['tracking_number'];

    $resp = track_dispatch($tn, $api);

    $status_code  = $resp['status_code'] ?? 'UNKNOWN';
    $status_text  = $resp['status_text'] ?? null;
    $last_event   = $resp['last_event_at'] ?? null;
    $delivered_at = $resp['delivered_at'] ?? null;
    $now          = date('Y-m-d H:i:s');

    $upd = $pdo->prepare("UPDATE colis
      SET status_code=:sc, status_text=:st, last_event_at=:le,
          delivered_at=:da, last_checked_at=:lc, times_checked=times_checked+1,
          last_source=:src, last_json=:raw, updated_at=:u
      WHERE id=:id");
    $upd->execute([
      ':sc'=>$status_code, ':st'=>$status_text, ':le'=>$last_event, ':da'=>$delivered_at,
      ':lc'=>$now, ':src'=>$resp['source'] ?? null,
      ':raw'=>json_encode($resp, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES),
      ':u'=>$now, ':id'=>$id,
    ]);

    $rowsOut[$id] = [
      'status_code'=>$status_code, 'status_text'=>$status_text,
      'last_event_at'=>$last_event, 'last_checked_at'=>$now,
      'times_checked'=>(int)$r['times_checked']+1,
    ];
  }

  out(['ok'=>1,'rows'=>$rowsOut]);
}

/* ===== Self test ===== */
if ($action === 'selftest') {
  $tp_num  = trim($req['thaipost'] ?? '');
  $s17_num = trim($req['seventeen'] ?? '');
  if ($tp_num==='' && $s17_num==='') out(['error'=>'no test numbers provided']);

  $ret = ['ok'=>1, 'providers'=>[]];
  if ($tp_num!=='')  $ret['providers']['thaipost'] = track_with_thaipost($tp_num);
  if ($s17_num!=='') $ret['providers']['17track']  = track_with_17track($s17_num);
  out($ret);
}

/* ===== Default ===== */
out(['error'=>'unknown action']);